/*
 * Decompiled with CFR 0.152.
 */
package com.intel.wizards.managers;

import com.intel.wizards.logger.WizardLogger;
import com.intel.wizards.xml.Allowed_item;
import com.intel.wizards.xml.Control;
import com.intel.wizards.xml.Controls;
import com.intel.wizards.xml.ControlsItem;
import com.intel.wizards.xml.Item_dependency;
import com.intel.wizards.xml.Items;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;

public class ControlsXMLChecker {
    private static Controls controls;

    public static void main(String[] stringArray) {
        File file = new File(stringArray[0]);
        if (file == null || !file.exists()) {
            System.out.println("File doesn't exist: " + file.getAbsolutePath());
        } else {
            try {
                FileReader fileReader = new FileReader(file);
                controls = (Controls)Unmarshaller.unmarshal(Controls.class, (Reader)fileReader);
                ((Reader)fileReader).close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                WizardLogger.writeLogMessage(1, fileNotFoundException);
            }
            catch (ValidationException validationException) {
                WizardLogger.writeLogMessage(1, validationException);
            }
            catch (MarshalException marshalException) {
                WizardLogger.writeLogMessage(1, marshalException);
            }
            catch (IOException iOException) {
                WizardLogger.writeLogMessage(1, iOException);
            }
            ControlsXMLChecker.checkAllowedItemIds();
        }
    }

    private static void checkAllowedItemIds() {
        System.out.println("Checking for allowed item ids that don't exist");
        int n = 0;
        while (n < controls.getControlsItemCount()) {
            ControlsItem controlsItem = controls.getControlsItem(n);
            int n2 = 0;
            while (n2 < controlsItem.getControlCount()) {
                if (controlsItem.getControl(n2).getItems() != null) {
                    Items items = controlsItem.getControl(n2).getItems();
                    int n3 = 0;
                    while (n3 < items.getItemCount()) {
                        int n4 = 0;
                        while (n4 < items.getItem(n3).getItem_dependencyCount()) {
                            Item_dependency item_dependency = items.getItem(n3).getItem_dependency(n4);
                            int n5 = 0;
                            while (n5 < item_dependency.getAllowed_itemCount()) {
                                Allowed_item allowed_item = item_dependency.getAllowed_item(n5);
                                if (!ControlsXMLChecker.doesAllowedItemIdExist(allowed_item.getAllowed_item_id(), item_dependency.getItk_ref())) {
                                    System.out.println("Control: " + controlsItem.getControl(n2).getItem_type_key() + " for Item " + items.getItem(n3).getItem_id() + " has incorrect allowed_item_id: " + allowed_item.getAllowed_item_id());
                                    System.out.println("Allowed ids include: ");
                                    ControlsXMLChecker.printAllowedItems(item_dependency.getItk_ref());
                                }
                                ++n5;
                            }
                            ++n4;
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            ++n;
        }
        System.out.println("Finished Checking for allowed item ids that don't exist");
    }

    private static Control getControlByITK(String string) {
        int n = 0;
        while (n < controls.getControlsItemCount()) {
            ControlsItem controlsItem = controls.getControlsItem(n);
            int n2 = 0;
            while (n2 < controlsItem.getControlCount()) {
                String string2 = controlsItem.getControl(n2).getItem_type_key();
                if (string2.equalsIgnoreCase(string)) {
                    return controlsItem.getControl(n2);
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    private static void printAllowedItems(String string) {
        Control control = ControlsXMLChecker.getControlByITK(string);
        if (control == null) {
            System.out.println("The item reference key does not exist: " + string);
        } else {
            int n = 0;
            while (n < control.getItems().getItemCount()) {
                System.out.println(control.getItems().getItem(n).getItem_id());
                ++n;
            }
        }
    }

    private static boolean doesAllowedItemIdExist(String string, String string2) {
        Control control = ControlsXMLChecker.getControlByITK(string2);
        if (control == null) {
            System.out.println("The item reference key does not exist: " + string2);
            return false;
        }
        int n = 0;
        while (n < control.getItems().getItemCount()) {
            if (control.getItems().getItem(n).getItem_id().equalsIgnoreCase(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

