/*
 * Decompiled with CFR 0.152.
 */
package com.intel.wizards.utilities;

import com.intel.wizards.generator.GenerationCancelledException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.apache.tools.tar.TarOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtility {
    private FileUtility() {
    }

    public static void recursiveCopyToDir(File file, File file2) throws IOException {
        FileUtility.recursiveCopyToDir(file, file2, (IProgressMonitor)new NullProgressMonitor(), true);
    }

    public static void recursiveCopyToDir(File file, File file2, IProgressMonitor iProgressMonitor, boolean bl) throws IOException {
        file2.mkdirs();
        File file3 = new File(file2, file.getName());
        if (bl && file.isDirectory()) {
            file3.mkdirs();
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                FileUtility.recursiveCopyToDir(fileArray[n], file3, iProgressMonitor, true);
                ++n;
            }
        } else {
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            FileOutputStream fileOutputStream = new FileOutputStream(file3);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            int n = 0;
            while ((n = bufferedInputStream.read()) > -1) {
                bufferedOutputStream.write(n);
            }
            iProgressMonitor.subTask("Copying " + file.getName());
            iProgressMonitor.worked(100);
            bufferedInputStream.close();
            fileInputStream.close();
            bufferedOutputStream.flush();
            fileOutputStream.close();
            bufferedOutputStream.close();
        }
    }

    public static boolean recursiveDelete(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                int n = 0;
                while (n < fileArray.length) {
                    if (!FileUtility.recursiveDelete(fileArray[n])) {
                        return false;
                    }
                    ++n;
                }
            }
            return file.delete();
        }
        return true;
    }

    public static String addFinalSeparator(String string) {
        if (!string.endsWith(File.separator)) {
            string = String.valueOf(string) + File.separator;
        }
        return string;
    }

    public static void unZipFile(File file, File file2) throws IOException, GenerationCancelledException {
        FileUtility.unZipFile(file, file2, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void unZipFile(File file, File file2, IProgressMonitor iProgressMonitor) throws IOException, GenerationCancelledException {
        File file3 = null;
        File file4 = null;
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        if (!file2.exists()) {
            file2.mkdirs();
        }
        while (enumeration.hasMoreElements()) {
            if (!iProgressMonitor.isCanceled()) {
                int n;
                ZipEntry zipEntry = enumeration.nextElement();
                file4 = new File(zipEntry.getName());
                file3 = new File(file2, file4.getPath());
                file3.deleteOnExit();
                if (zipEntry.isDirectory()) {
                    if (file3.exists()) continue;
                    file3.mkdirs();
                    continue;
                }
                if (!file3.getParentFile().exists()) {
                    file3.getParentFile().mkdirs();
                    file3.getParentFile().deleteOnExit();
                }
                iProgressMonitor.subTask("Unzipping " + file3.getName());
                iProgressMonitor.worked(50);
                file3.createNewFile();
                FileOutputStream fileOutputStream = new FileOutputStream(file3);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                while ((n = bufferedInputStream.read()) != -1) {
                    fileOutputStream.write(n);
                }
                fileOutputStream.close();
                bufferedInputStream.close();
                continue;
            }
            throw new GenerationCancelledException();
        }
    }

    public static void unZipFile(File file, File file2, IProgressMonitor iProgressMonitor, ArrayList<String> arrayList) throws IOException, GenerationCancelledException {
        File file3 = null;
        File file4 = null;
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        if (!file2.exists()) {
            file2.mkdirs();
        }
        while (enumeration.hasMoreElements()) {
            if (!iProgressMonitor.isCanceled()) {
                int n;
                ZipEntry zipEntry = enumeration.nextElement();
                file4 = new File(zipEntry.getName());
                file3 = new File(file2, file4.getPath());
                file3.deleteOnExit();
                if (zipEntry.isDirectory()) {
                    if (file3.exists()) continue;
                    file3.mkdirs();
                    continue;
                }
                if (!file3.getParentFile().exists()) {
                    file3.getParentFile().mkdirs();
                    file3.getParentFile().deleteOnExit();
                }
                if (arrayList != null && !arrayList.contains(file3.getName())) continue;
                iProgressMonitor.subTask("Unzipping " + file3.getName());
                iProgressMonitor.worked(50);
                file3.createNewFile();
                FileOutputStream fileOutputStream = new FileOutputStream(file3);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                while ((n = bufferedInputStream.read()) != -1) {
                    fileOutputStream.write(n);
                }
                fileOutputStream.close();
                bufferedInputStream.close();
                continue;
            }
            throw new GenerationCancelledException();
        }
    }

    public static void zipFile(File file, String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(String.valueOf(FileUtility.addFinalSeparator(string)) + file.getName() + ".zip");
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream));
        FileUtility.zipDir(file.toString(), zipOutputStream);
        zipOutputStream.close();
    }

    public static void zipDir(String string, ZipOutputStream zipOutputStream) throws IOException, FileNotFoundException {
        File file = new File(string);
        int n = 0;
        byte[] byArray = new byte[2048];
        String[] stringArray = file.list();
        int n2 = 0;
        while (n2 < stringArray.length) {
            Object object;
            File file2 = new File(file, stringArray[n2]);
            if (file2.isDirectory()) {
                object = file2.getPath();
                FileUtility.zipDir((String)object, zipOutputStream);
            } else {
                object = new FileInputStream(file2);
                ZipEntry zipEntry = new ZipEntry(file2.getPath());
                zipOutputStream.putNextEntry(zipEntry);
                while ((n = ((FileInputStream)object).read(byArray)) != -1) {
                    zipOutputStream.write(byArray, 0, n);
                }
                ((FileInputStream)object).close();
            }
            ++n2;
        }
    }

    public static void replaceFileInZip(File file, File file2, File file3, IProgressMonitor iProgressMonitor) throws IOException, GenerationCancelledException {
        File file4 = null;
        file.mkdirs();
        if (file2.exists() && file3.exists()) {
            ZipFile zipFile = new ZipFile(file2);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            FileOutputStream fileOutputStream = new FileOutputStream(file + File.separator + file2.getName());
            ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream));
            while (enumeration.hasMoreElements()) {
                if (!iProgressMonitor.isCanceled()) {
                    int n;
                    ZipEntry zipEntry = enumeration.nextElement();
                    file4 = new File(zipEntry.getName());
                    iProgressMonitor.subTask("Retrieving " + file4.getName());
                    iProgressMonitor.worked(1);
                    if (file4.getName().equalsIgnoreCase(file3.getName())) {
                        int n2 = 0;
                        byte[] byArray = new byte[2048];
                        FileInputStream fileInputStream = new FileInputStream(file3);
                        ZipEntry zipEntry2 = new ZipEntry(file4.getPath());
                        zipOutputStream.putNextEntry(zipEntry2);
                        while ((n2 = fileInputStream.read(byArray)) != -1) {
                            zipOutputStream.write(byArray, 0, n2);
                        }
                        fileInputStream.close();
                        continue;
                    }
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                    zipOutputStream.putNextEntry(new ZipEntry(zipEntry.getName()));
                    while ((n = bufferedInputStream.read()) != -1) {
                        zipOutputStream.write(n);
                    }
                    zipOutputStream.closeEntry();
                    bufferedInputStream.close();
                    continue;
                }
                zipOutputStream.close();
                zipFile.close();
                throw new GenerationCancelledException();
            }
            zipOutputStream.close();
            zipFile.close();
        }
    }

    public static void tarFile(File file, String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(String.valueOf(FileUtility.addFinalSeparator(string)) + file.getName() + ".tar");
        TarOutputStream tarOutputStream = new TarOutputStream((OutputStream)new BufferedOutputStream(fileOutputStream));
        FileUtility.tarDir(file.toString(), tarOutputStream);
        tarOutputStream.close();
        fileOutputStream.close();
        String string2 = String.valueOf(FileUtility.addFinalSeparator(string)) + file.getName() + ".tar";
        FileUtility.createGZip(string2);
    }

    public static void createGZip(String string) throws IOException, FileNotFoundException {
        int n;
        byte[] byArray = new byte[2048];
        File file = new File(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file + ".gz");
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(fileOutputStream);
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        while ((n = bufferedInputStream.read(byArray)) >= 0) {
            gZIPOutputStream.write(byArray, 0, n);
        }
        bufferedInputStream.close();
        gZIPOutputStream.close();
    }

    public static void tarDir(String string, TarOutputStream tarOutputStream) throws IOException, FileNotFoundException {
        File file = new File(string);
        int n = 0;
        byte[] byArray = new byte[2048];
        String[] stringArray = file.list();
        int n2 = 0;
        while (n2 < stringArray.length) {
            Object object;
            File file2 = new File(file, stringArray[n2]);
            if (file2.isDirectory()) {
                object = file2.getPath();
                FileUtility.tarDir((String)object, tarOutputStream);
            } else {
                object = new FileInputStream(file2);
                TarEntry tarEntry = new TarEntry(file2);
                tarEntry.setModTime(file2.lastModified());
                tarEntry.setSize(file2.length());
                tarOutputStream.putNextEntry(tarEntry);
                while ((n = ((FileInputStream)object).read(byArray)) != -1) {
                    tarOutputStream.write(byArray, 0, n);
                }
                ((FileInputStream)object).close();
                tarOutputStream.closeEntry();
            }
            ++n2;
        }
    }

    public static void untarFile(File file, File file2) throws IOException {
        TarEntry tarEntry;
        TarInputStream tarInputStream = file.getName().toLowerCase().endsWith(".tar.gz") || file.getName().toLowerCase().endsWith(".tgz") ? new TarInputStream((InputStream)new GZIPInputStream(new FileInputStream(file))) : new TarInputStream((InputStream)new FileInputStream(file));
        while ((tarEntry = tarInputStream.getNextEntry()) != null) {
            File file3 = new File(file2, tarEntry.getName());
            if (tarEntry.isDirectory()) {
                file3.mkdir();
                continue;
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file3);
            tarInputStream.copyEntryContents((OutputStream)fileOutputStream);
            fileOutputStream.close();
        }
        tarInputStream.close();
    }

    public static void untarFile(File file, File file2, IProgressMonitor iProgressMonitor) throws IOException, GenerationCancelledException {
        TarEntry tarEntry;
        TarInputStream tarInputStream = file.getName().toLowerCase().endsWith(".tar.gz") || file.getName().toLowerCase().endsWith(".tgz") ? new TarInputStream((InputStream)new GZIPInputStream(new FileInputStream(file))) : new TarInputStream((InputStream)new FileInputStream(file));
        while ((tarEntry = tarInputStream.getNextEntry()) != null) {
            if (!iProgressMonitor.isCanceled()) {
                File file3 = new File(file2, tarEntry.getName());
                if (tarEntry.isDirectory()) {
                    file3.mkdir();
                    continue;
                }
                File file4 = new File(tarEntry.getName());
                iProgressMonitor.subTask("Unzipping " + file4.getName());
                iProgressMonitor.worked(50);
                FileOutputStream fileOutputStream = new FileOutputStream(file3);
                tarInputStream.copyEntryContents((OutputStream)fileOutputStream);
                fileOutputStream.close();
                continue;
            }
            tarInputStream.close();
            throw new GenerationCancelledException();
        }
        tarInputStream.close();
    }

    public static void untarFile(File file, File file2, IProgressMonitor iProgressMonitor, ArrayList<String> arrayList) throws IOException, GenerationCancelledException {
        TarEntry tarEntry;
        TarInputStream tarInputStream = file.getName().toLowerCase().endsWith(".tar.gz") || file.getName().toLowerCase().endsWith(".tgz") ? new TarInputStream((InputStream)new GZIPInputStream(new FileInputStream(file))) : new TarInputStream((InputStream)new FileInputStream(file));
        while ((tarEntry = tarInputStream.getNextEntry()) != null) {
            if (!iProgressMonitor.isCanceled()) {
                File file3 = new File(file2, tarEntry.getName());
                if (tarEntry.isDirectory()) {
                    file3.mkdir();
                    continue;
                }
                File file4 = new File(tarEntry.getName());
                if (arrayList != null && !arrayList.contains(file4.getName())) continue;
                iProgressMonitor.subTask("Unzipping " + file4.getName());
                iProgressMonitor.worked(50);
                FileOutputStream fileOutputStream = new FileOutputStream(file3);
                tarInputStream.copyEntryContents((OutputStream)fileOutputStream);
                fileOutputStream.close();
                continue;
            }
            tarInputStream.close();
            throw new GenerationCancelledException();
        }
        tarInputStream.close();
    }

    public static void addFileToTar(File file, File file2, File file3, IProgressMonitor iProgressMonitor) throws IOException {
        int n;
        BufferedInputStream bufferedInputStream;
        FileInputStream fileInputStream;
        GZIPOutputStream gZIPOutputStream;
        FileOutputStream fileOutputStream;
        Object object;
        Object object2;
        File file4 = null;
        file.mkdirs();
        String string = null;
        if (file3.exists()) {
            int n2;
            int n3;
            object2 = null;
            if (file2.getName().toLowerCase().endsWith(".tar.gz") || file2.getName().toLowerCase().endsWith(".tgz")) {
                object = new TarInputStream((InputStream)new GZIPInputStream(new FileInputStream(file2)));
                n3 = file2.getName().toLowerCase().indexOf(".tar.gz");
                if (n3 < 0) {
                    n3 = file2.getName().toLowerCase().indexOf(".tgz");
                }
                string = file2.getName().substring(0, n3);
            } else {
                object = new TarInputStream((InputStream)new FileInputStream(file2));
                n3 = file2.getName().toLowerCase().indexOf(".tar");
                string = file2.getName().substring(0, n3);
            }
            FileOutputStream fileOutputStream2 = new FileOutputStream(file + File.separator + string + ".tar");
            fileOutputStream = new TarOutputStream((OutputStream)new BufferedOutputStream(fileOutputStream2));
            while ((gZIPOutputStream = object.getNextEntry()) != null) {
                int n4;
                file4 = new File(gZIPOutputStream.getName());
                iProgressMonitor.subTask("Retrieving " + file4.getName());
                iProgressMonitor.worked(1);
                if (file4.getPath().endsWith("Linux" + File.separator + "driver")) {
                    object2 = file4.getPath();
                }
                fileInputStream = new TarEntry(gZIPOutputStream.getName());
                fileInputStream.setModTime(gZIPOutputStream.getModTime());
                fileInputStream.setSize(gZIPOutputStream.getSize());
                fileOutputStream.putNextEntry((TarEntry)fileInputStream);
                while ((n4 = object.read()) != -1) {
                    fileOutputStream.write(n4);
                }
                fileOutputStream.closeEntry();
            }
            object.close();
            fileInputStream = new FileInputStream(file3);
            bufferedInputStream = new TarEntry(String.valueOf(object2) + File.separator + file3.getName());
            bufferedInputStream.setModTime(file3.lastModified());
            bufferedInputStream.setSize(file3.length());
            fileOutputStream.putNextEntry((TarEntry)bufferedInputStream);
            while ((n2 = fileInputStream.read()) != -1) {
                fileOutputStream.write(n2);
            }
            fileOutputStream.closeEntry();
            fileInputStream.close();
            fileOutputStream.close();
        }
        object2 = new File(file + File.separator + string + ".tar");
        object = new byte[2048];
        fileOutputStream = new FileOutputStream(new File(file + File.separator + string + ".tgz"));
        gZIPOutputStream = new GZIPOutputStream(fileOutputStream);
        fileInputStream = new FileInputStream((File)object2);
        bufferedInputStream = new BufferedInputStream(fileInputStream);
        while ((n = bufferedInputStream.read((byte[])object)) >= 0) {
            gZIPOutputStream.write((byte[])object, 0, n);
        }
        bufferedInputStream.close();
        gZIPOutputStream.close();
        ((File)object2).delete();
    }

    public static void addKMFileToTar(File file, File file2, File file3, File[] fileArray, IProgressMonitor iProgressMonitor) throws IOException, GenerationCancelledException {
        int n;
        Object object;
        FileInputStream fileInputStream;
        GZIPOutputStream gZIPOutputStream;
        FileOutputStream fileOutputStream;
        Object object2;
        Object object3;
        File file4 = null;
        file2.mkdirs();
        String string = null;
        File file5 = null;
        String string2 = null;
        HashMap<Object, File> hashMap = new HashMap<Object, File>();
        boolean bl = false;
        iProgressMonitor.subTask("Extracting EMGD sources ");
        iProgressMonitor.worked(1);
        if (fileArray.length > 0) {
            int n2;
            object3 = null;
            if (file3.getName().toLowerCase().endsWith(".tar.gz") || file3.getName().toLowerCase().endsWith(".tgz")) {
                object2 = new TarInputStream((InputStream)new GZIPInputStream(new FileInputStream(file3)));
                n2 = file3.getName().toLowerCase().indexOf(".tar.gz");
                if (n2 < 0) {
                    n2 = file3.getName().toLowerCase().indexOf(".tgz");
                }
                string = file3.getName().substring(0, n2);
            } else {
                object2 = new TarInputStream((InputStream)new FileInputStream(file3));
                n2 = file3.getName().toLowerCase().indexOf(".tar");
                string = file3.getName().substring(0, n2);
            }
            FileOutputStream fileOutputStream2 = new FileOutputStream(file2 + File.separator + string + ".tar");
            fileOutputStream = new TarOutputStream((OutputStream)new BufferedOutputStream(fileOutputStream2));
            while ((gZIPOutputStream = object2.getNextEntry()) != null) {
                if (!iProgressMonitor.isCanceled()) {
                    file4 = new File(gZIPOutputStream.getName());
                    iProgressMonitor.subTask("Retrieving " + file4.getName());
                    iProgressMonitor.worked(1);
                    if (file4.getPath().endsWith("Linux" + File.separator + "F11" + File.separator + "driver") || file4.getPath().endsWith("Linux" + File.separator + "Moblin2.2" + File.separator + "driver") || file4.getPath().endsWith("Linux" + File.separator + "MeeGo1.0" + File.separator + "driver")) {
                        int n3 = 0;
                        while (n3 < fileArray.length) {
                            string2 = fileArray[n3].getName();
                            if (string2.endsWith(".x")) {
                                file5 = fileArray[n3];
                                break;
                            }
                            ++n3;
                        }
                        object3 = file4.getPath();
                        hashMap.put(String.valueOf(object3) + "\\debug.x", file5);
                    } else if (file4.getPath().endsWith("emgd_drm.tgz")) {
                        String string3 = null;
                        string3 = file4.getPath().endsWith("F11" + File.separator + "driver" + File.separator + "emgd_drm.tgz") ? "F11" : (file4.getPath().endsWith("Moblin2.2" + File.separator + "driver" + File.separator + "emgd_drm.tgz") ? "Moblin2.2" : "MeeGo1.0");
                        iProgressMonitor.subTask("Inserting user config file");
                        iProgressMonitor.worked(1);
                        file5 = FileUtility.insertKMFile(file, fileArray, file2, file4, string3);
                        object3 = file4.getPath().replace(String.valueOf(File.separator) + "emgd_drm.tgz", "");
                        hashMap.put(object3, file5);
                        bl = true;
                    }
                    if (!bl) {
                        int n4;
                        TarEntry tarEntry = new TarEntry(gZIPOutputStream.getName());
                        tarEntry.setModTime(gZIPOutputStream.getModTime());
                        tarEntry.setSize(gZIPOutputStream.getSize());
                        fileOutputStream.putNextEntry(tarEntry);
                        while ((n4 = object2.read()) != -1) {
                            fileOutputStream.write(n4);
                        }
                    }
                    fileOutputStream.closeEntry();
                    bl = false;
                    continue;
                }
                fileOutputStream.close();
                object2.close();
                fileOutputStream2.close();
                throw new GenerationCancelledException();
            }
            object2.close();
            fileInputStream = null;
            object = hashMap.entrySet();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                int n5;
                Map.Entry entry = (Map.Entry)iterator.next();
                File file6 = new File(entry.getValue().toString());
                fileInputStream = new FileInputStream(file6);
                object3 = entry.getKey().toString().replace("\\debug.x", "");
                String string4 = String.valueOf(object3) + File.separator + file6.getName();
                string4 = string4.replace("\\", "/");
                TarEntry tarEntry = new TarEntry(string4);
                tarEntry.setModTime(file6.lastModified());
                tarEntry.setSize(file6.length());
                fileOutputStream.putNextEntry(tarEntry);
                while ((n5 = fileInputStream.read()) != -1) {
                    fileOutputStream.write(n5);
                }
                fileOutputStream.closeEntry();
                fileInputStream.close();
            }
            fileOutputStream.closeEntry();
            fileInputStream.close();
            fileOutputStream.close();
        }
        iProgressMonitor.subTask("Creating package");
        iProgressMonitor.worked(1);
        object3 = new File(file2 + File.separator + string + ".tar");
        object2 = new byte[2048];
        fileOutputStream = new FileOutputStream(new File(file2 + File.separator + string + ".tgz"));
        gZIPOutputStream = new GZIPOutputStream(fileOutputStream);
        fileInputStream = new FileInputStream((File)object3);
        object = new BufferedInputStream(fileInputStream);
        while ((n = ((FilterInputStream)object).read((byte[])object2)) >= 0) {
            gZIPOutputStream.write((byte[])object2, 0, n);
        }
        ((BufferedInputStream)object).close();
        gZIPOutputStream.close();
        ((File)object3).delete();
        fileInputStream.close();
        fileOutputStream.close();
        int n6 = 0;
        while (n6 < fileArray.length) {
            string2 = fileArray[n6].getName();
            if (string2.endsWith("user_config.c")) {
                FileUtility.recursiveDelete(fileArray[n6]);
                break;
            }
            ++n6;
        }
        n6 = 0;
        while (n6 < fileArray.length) {
            string2 = fileArray[n6].getName();
            if (string2.endsWith("image_data.h")) {
                FileUtility.recursiveDelete(fileArray[n6]);
                break;
            }
            ++n6;
        }
    }

    private static File insertKMFile(File file, File[] fileArray, File file2, File file3, String string) throws IOException {
        File file4;
        File file5;
        String string2;
        File file6;
        File file7 = null;
        File file8 = null;
        File file9 = new File(String.valueOf(file.getAbsolutePath()) + File.separator + file3);
        File file10 = new File(String.valueOf(file.getAbsolutePath()) + File.separator + "temp" + File.separator + string);
        if (!file10.exists()) {
            file10.mkdirs();
        }
        if (!(file6 = new File(String.valueOf(file10.getAbsolutePath()) + File.separator + File.separator + "emgd" + File.separator + "drm")).exists()) {
            FileUtility.untarFile(file9, file10);
        }
        int n = 0;
        while (n < fileArray.length) {
            string2 = fileArray[n].getName();
            if (string2.startsWith("user_config")) {
                file7 = fileArray[n];
                file5 = new File(String.valueOf(file6.getAbsolutePath()) + File.separator + "user_config.c");
                file5.delete();
                FileUtility.recursiveCopyToDir(file7, file6);
                file4 = new File(String.valueOf(file.getAbsolutePath()) + File.separator + string);
                file4.mkdir();
                FileUtility.tarFileFromTempDir(file10, file4.toString(), "emgd_drm");
                file8 = new File(String.valueOf(file.getAbsolutePath()) + File.separator + string + File.separator + "emgd_drm.tgz");
                break;
            }
            ++n;
        }
        n = 0;
        while (n < fileArray.length) {
            string2 = fileArray[n].getName();
            if (string2.startsWith("image_data")) {
                file7 = fileArray[n];
                file5 = new File(String.valueOf(file6.getAbsolutePath()) + File.separator + "image_data");
                file5.delete();
                FileUtility.recursiveCopyToDir(file7, file6);
                file4 = new File(String.valueOf(file.getAbsolutePath()) + File.separator + string);
                file4.mkdir();
                FileUtility.tarFileFromTempDir(file10, file4.toString(), "emgd_drm");
                file8 = new File(String.valueOf(file.getAbsolutePath()) + File.separator + string + File.separator + "emgd_drm.tgz");
                break;
            }
            ++n;
        }
        return file8;
    }

    public static void tarDir(String string, String string2, TarOutputStream tarOutputStream) throws IOException {
        File file = new File(string2);
        int n = 0;
        byte[] byArray = new byte[2048];
        String[] stringArray = file.list();
        int n2 = 0;
        while (n2 < stringArray.length) {
            Object object;
            File file2 = new File(file, stringArray[n2]);
            if (file2.isDirectory()) {
                object = file2.getPath();
                FileUtility.tarDir(string, (String)object, tarOutputStream);
            } else {
                object = new FileInputStream(file2);
                String string3 = file2.getPath().substring(string.length());
                string3 = string3.replace("\\", "/");
                TarEntry tarEntry = new TarEntry(string3);
                tarEntry.setModTime(file2.lastModified());
                tarEntry.setSize(file2.length());
                tarOutputStream.putNextEntry(tarEntry);
                while ((n = ((FileInputStream)object).read(byArray)) != -1) {
                    tarOutputStream.write(byArray, 0, n);
                }
                ((FileInputStream)object).close();
                tarOutputStream.closeEntry();
            }
            ++n2;
        }
    }

    public static void tarFileFromTempDir(File file, String string, String string2) throws IOException {
        int n;
        String string3 = String.valueOf(FileUtility.addFinalSeparator(string)) + string2 + ".tar";
        FileOutputStream fileOutputStream = new FileOutputStream(string3);
        TarOutputStream tarOutputStream = new TarOutputStream((OutputStream)new BufferedOutputStream(fileOutputStream));
        FileUtility.tarDir(file.toString(), file.toString(), tarOutputStream);
        tarOutputStream.close();
        fileOutputStream.close();
        File file2 = new File(String.valueOf(string) + File.separator + string2 + ".tar");
        byte[] byArray = new byte[2048];
        FileOutputStream fileOutputStream2 = new FileOutputStream(String.valueOf(FileUtility.addFinalSeparator(string)) + string2 + ".tgz");
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(fileOutputStream2);
        FileInputStream fileInputStream = new FileInputStream(file2);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        while ((n = bufferedInputStream.read(byArray)) >= 0) {
            gZIPOutputStream.write(byArray, 0, n);
        }
        bufferedInputStream.close();
        gZIPOutputStream.close();
        file2.delete();
        fileOutputStream2.close();
        gZIPOutputStream.close();
    }
}

