/*
 * Decompiled with CFR 0.152.
 */
package com.intel.wizards.utilities;

public class HexIntegerUtility {
    public static final int MIN_LENGTH = 2;
    public static final String START_HEX_LOWER = "0x";
    public static final String START_HEX_UPPER = "0X";
    public static final long TWOS_COMPLEMENT = Long.parseLong("100000000", 16);

    private HexIntegerUtility() {
    }

    public static int convertHexStringToInt(String string, boolean bl) {
        if (!HexIntegerUtility.validateHexString(string)) {
            return -1;
        }
        string = string.substring(2);
        if (bl) {
            Long l = Long.parseLong(string, 16) - TWOS_COMPLEMENT;
            return l.intValue();
        }
        return Integer.parseInt(string, 16);
    }

    public static String convertIntToHexString(int n) {
        return START_HEX_LOWER + Integer.toHexString(n);
    }

    public static boolean validateHexString(String string) {
        if ((string = string.toLowerCase()).startsWith(START_HEX_LOWER)) {
            char[] cArray = string.substring(2).toCharArray();
            if (cArray.length == 0) {
                return false;
            }
            int n = 0;
            while (n < cArray.length) {
                if (!HexIntegerUtility.isHexDigit(cArray[n])) {
                    return false;
                }
                ++n;
            }
        } else {
            return false;
        }
        return true;
    }

    public static boolean isHexDigit(char c) {
        char[] cArray = new char[]{'a', 'b', 'c', 'd', 'e', 'f', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0'};
        int n = 0;
        while (n < cArray.length) {
            if (c == cArray[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean validateIntString(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            if (!HexIntegerUtility.isDigit(cArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean validateFloatString(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        int n = string.indexOf(".");
        if (n >= 0) {
            string = string.substring(0, n).concat(string.substring(n + 1, string.length()));
        }
        char[] cArray = string.toCharArray();
        int n2 = 0;
        while (n2 < cArray.length) {
            if (!HexIntegerUtility.isDigit(cArray[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean isDigit(char c) {
        char[] cArray = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', '0'};
        int n = 0;
        while (n < cArray.length) {
            if (c == cArray[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

