/*
 * Decompiled with CFR 0.152.
 */
package russotto.iff;

import java.io.File;
import java.io.IOException;
import java.util.Stack;
import russotto.iff.IFFChunkInfo;
import russotto.iff.IFFChunkNotFoundException;
import russotto.iff.IFFFile;

public class IFFInputFile
extends IFFFile {
    private Stack openchunkends = new Stack();

    public IFFInputFile(File file) throws IOException {
        super(file, "r");
    }

    public IFFInputFile(String string) throws IOException {
        super(string, "r");
    }

    public synchronized IFFChunkInfo readChunkInfo() throws IOException {
        IFFChunkInfo iFFChunkInfo = new IFFChunkInfo();
        byte[] byArray = new byte[4];
        this.read(byArray, 0, 4);
        long l = this.getFilePointer();
        iFFChunkInfo.chunktype = new String(byArray, 0);
        iFFChunkInfo.chunklength = this.readInt();
        this.openchunks.push(new Long(l));
        this.openchunkends.push(new Long(this.getFilePointer() + (long)iFFChunkInfo.chunklength));
        return iFFChunkInfo;
    }

    public synchronized IFFChunkInfo skipToChunk(String string) throws IOException, IFFChunkNotFoundException {
        if (this.getFilePointer() >= (Long)this.openchunkends.peek()) {
            throw new IFFChunkNotFoundException("Chunk " + string + " not found at current level");
        }
        IFFChunkInfo iFFChunkInfo = this.readChunkInfo();
        while (!iFFChunkInfo.chunktype.equals(string)) {
            this.closeChunk();
            if (this.getFilePointer() >= (Long)this.openchunkends.peek()) {
                throw new IFFChunkNotFoundException("Chunk " + string + " not found at current level");
            }
            iFFChunkInfo = this.readChunkInfo();
        }
        return iFFChunkInfo;
    }

    public synchronized String readFORM() throws IOException {
        byte[] byArray = new byte[4];
        IFFChunkInfo iFFChunkInfo = this.readChunkInfo();
        if (iFFChunkInfo.chunktype.equals("FORM")) {
            this.read(byArray, 0, 4);
        }
        return new String(byArray, 0);
    }

    public synchronized void closeChunk() throws IOException {
        long l = (Long)this.openchunkends.pop() + 1L & 0xFFFFFFFFFFFFFFFEL;
        this.openchunks.pop();
        this.seek(l);
    }

    public synchronized void close() throws IOException {
        while (!this.openchunks.empty()) {
            try {
                this.closeChunk();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.close();
    }
}

