/*
 * Decompiled with CFR 0.152.
 */
package russotto.zplet.screenmodel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;

class ZCursor {
    Color cursorcolor;
    Color bgcolor;
    boolean shown = false;
    int t;
    int l;
    int w;
    int h;
    Component parent;

    ZCursor(Color color, Color color2, Component component) {
        this.cursorcolor = color;
        this.bgcolor = color2;
        this.parent = component;
    }

    ZCursor(Component component) {
        this(Color.green, Color.yellow, component);
    }

    ZCursor() {
        this(Color.green, Color.yellow, null);
    }

    synchronized void show() {
        if (!this.shown) {
            Graphics graphics;
            this.shown = true;
            if (this.parent != null && (graphics = this.parent.getGraphics()) != null) {
                graphics.setColor(this.cursorcolor);
                graphics.fillRect(this.l, this.t, this.w, this.h);
            }
        }
    }

    synchronized void hide() {
        if (this.shown) {
            this.shown = false;
            if (this.parent != null) {
                this.parent.repaint(this.l, this.t, this.w, this.h);
            }
        }
    }

    synchronized void redraw(Graphics graphics) {
        if (this.shown) {
            graphics.setColor(this.cursorcolor);
            graphics.fillRect(this.l, this.t, this.w, this.h);
        }
    }

    synchronized void move(int n, int n2) {
        boolean bl = this.shown;
        if (bl) {
            this.hide();
        }
        this.l = n;
        this.t = n2;
        if (bl) {
            this.show();
        }
    }

    synchronized void size(int n, int n2) {
        boolean bl = this.shown;
        if (bl) {
            this.hide();
        }
        this.w = n;
        this.h = n2;
        if (bl) {
            this.show();
        }
    }

    synchronized void setcolors(Color color, Color color2) {
        boolean bl = this.shown;
        if (bl) {
            this.hide();
        }
        this.cursorcolor = color;
        this.bgcolor = color2;
        if (bl) {
            this.show();
        }
    }
}

