/*
 * Decompiled with CFR 0.152.
 */
package russotto.zplet.screenmodel;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.util.NoSuchElementException;
import java.util.Vector;
import russotto.zplet.ZColor;
import russotto.zplet.screenmodel.NoSuchKeyException;
import russotto.zplet.screenmodel.SyncVector;
import russotto.zplet.screenmodel.ZCursor;
import russotto.zplet.screenmodel.ZWindow;

public class ZScreen
extends Canvas {
    int lines;
    int chars;
    Font fixedfont;
    FontMetrics fixedmetrics;
    Font variablefont;
    Font graphicsfont;
    SyncVector inputcodes;
    Vector bufferedcodes;
    boolean bufferdone;
    ZWindow inputwindow;
    ZCursor inputcursor;
    int zforeground = 2;
    int zbackground = 9;
    Image backing_store;
    Graphics g_store;
    Color zbcolor;
    boolean hasscrolled = false;
    static final char[] accent_table = new char[]{'\u00e4', '\u00f6', '\u00fc', '\u00c4', '\u00d6', '\u00dc', '\u00df', '\u00bb', '\u00ab', '\u00eb', '\u00ef', '\u00ff', '\u00cb', '\u00cf', '\u00e1', '\u00e9', '\u00ed', '\u00f3', '\u00fa', '\u00fd', '\u00c1', '\u00c9', '\u00cd', '\u00d3', '\u00da', '\u00dd', '\u00e0', '\u00e8', '\u00ec', '\u00f2', '\u00f9', '\u00c0', '\u00c8', '\u00cc', '\u00d2', '\u00d9', '\u00e2', '\u00ea', '\u00ee', '\u00f4', '\u00fb', '\u00c2', '\u00ca', '\u00ce', '\u00d4', '\u00da', '\u00e5', '\u00c5', '\u00f8', '\u00d8', '\u00e3', '\u00f1', '\u00f5', '\u00c3', '\u00d1', '\u00d5', '\u00e6', '\u00c6', '\u00e7', '\u00c7', '\u00fe', '\u00f0', '\u00de', '\u00d0', '\u00a3', '\u0153', '\u0152', '\u00a1', '\u00bf'};

    public ZScreen() {
        Dimension dimension = this.size();
        this.fixedfont = new Font("Courier", 0, 12);
        this.fixedmetrics = this.getFontMetrics(this.fixedfont);
        this.chars = dimension.width / this.fixedmetrics.charWidth(' ');
        this.lines = dimension.height / this.fixedmetrics.getHeight();
        this.inputcodes = new SyncVector();
        this.bufferedcodes = new Vector();
        this.inputcursor = new ZCursor(this);
        this.setForeground(ZColor.getcolor(this.zforeground));
        this.setBackground(ZColor.getcolor(this.zbackground));
    }

    protected boolean isterminator(int n) {
        return n == 10 || n == 13;
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        this.requestFocus();
        return true;
    }

    static char zascii_to_unicode(short s) {
        if (s >= 32 && s <= 126) {
            return (char)s;
        }
        if (s >= 155 && s <= 251) {
            if (s - 155 < accent_table.length) {
                return accent_table[s - 155];
            }
            return '?';
        }
        if (s == 0 || s >= 256) {
            return '?';
        }
        System.err.println("Illegal character code: " + s);
        return '?';
    }

    static short unicode_to_zascii(char c) throws NoSuchKeyException {
        if (c == '\n') {
            return 13;
        }
        if (c == '\b') {
            return 127;
        }
        if (c < ' ' && c != '\r' && c != '\u001b') {
            throw new NoSuchKeyException("Illegal character input: " + (short)c);
        }
        if (c < '\u0080') {
            return (short)c;
        }
        int n = 0;
        while (n < accent_table.length) {
            if (accent_table[n] == c) {
                return (short)(155 + n);
            }
            n = (short)(n + 1);
        }
        throw new NoSuchKeyException("Illegal character input: " + (short)c);
    }

    static short fkey_to_zascii(int n) throws NoSuchKeyException {
        switch (n) {
            case 1004: {
                return 129;
            }
            case 1005: {
                return 130;
            }
            case 1006: {
                return 131;
            }
            case 1007: {
                return 132;
            }
            case 1008: {
                return 133;
            }
            case 1009: {
                return 134;
            }
            case 1010: {
                return 135;
            }
            case 1011: {
                return 136;
            }
            case 1012: {
                return 137;
            }
            case 1013: {
                return 138;
            }
            case 1014: {
                return 139;
            }
            case 1015: {
                return 140;
            }
            case 1016: {
                return 141;
            }
            case 1017: {
                return 142;
            }
            case 1018: {
                return 143;
            }
            case 1019: {
                return 144;
            }
        }
        throw new NoSuchKeyException("Illegal function key " + n);
    }

    public boolean keyDown(Event event, int n) {
        try {
            short s = event.id == 401 ? ZScreen.unicode_to_zascii((char)n) : ZScreen.fkey_to_zascii(n);
            this.inputcodes.syncAddElement(new Integer(s));
        }
        catch (NoSuchKeyException noSuchKeyException) {
            System.err.println(noSuchKeyException);
        }
        return true;
    }

    public void set_input_window(ZWindow zWindow) {
        this.inputwindow = zWindow;
    }

    public short read_code() {
        Integer n = null;
        while (n == null) {
            n = (Integer)this.inputcodes.syncPopFirstElement();
        }
        return (short)n.intValue();
    }

    public short read_buffered_code() {
        Integer n;
        this.inputwindow.flush();
        int n2 = this.fixedmetrics.charWidth(' ');
        int n3 = this.fixedmetrics.getHeight();
        this.inputcursor.setcolors(this.getForeground(), this.zbcolor);
        this.inputcursor.size(n2, n3);
        while (!this.bufferdone) {
            this.inputwindow.flush();
            this.inputcursor.move((this.inputwindow.getLeft() + this.inputwindow.cursorx) * n2, (this.inputwindow.getTop() + this.inputwindow.cursory) * n3);
            this.inputcursor.show();
            Toolkit.getDefaultToolkit().sync();
            short s = this.read_code();
            this.inputcursor.hide();
            if (s == 8 || s == 127) {
                try {
                    n = (Integer)this.bufferedcodes.lastElement();
                    this.bufferedcodes.removeElementAt(this.bufferedcodes.size() - 1);
                    this.inputwindow.flush();
                    this.inputwindow.movecursor(this.inputwindow.cursorx - 1, this.inputwindow.cursory);
                    this.inputwindow.printzascii((short)32);
                    this.inputwindow.flush();
                    this.inputwindow.movecursor(this.inputwindow.cursorx - 1, this.inputwindow.cursory);
                }
                catch (NoSuchElementException noSuchElementException) {}
                continue;
            }
            if (this.isterminator(s)) {
                this.bufferdone = true;
                if (s == 10 || s == 13) {
                    this.inputwindow.newline();
                }
            } else {
                this.inputwindow.printzascii(s);
                this.inputwindow.flush();
            }
            this.bufferedcodes.addElement(new Integer(s));
        }
        n = (Integer)this.bufferedcodes.firstElement();
        this.bufferedcodes.removeElementAt(0);
        if (this.bufferedcodes.isEmpty()) {
            this.bufferdone = false;
        }
        return (short)n.intValue();
    }

    public int getlines() {
        return this.lines;
    }

    public int getchars() {
        return this.chars;
    }

    public synchronized void reshape(int n, int n2, int n3, int n4) {
        if (n3 >= 0 && n4 >= 0) {
            int n5 = n4 / this.fixedmetrics.getHeight();
            this.chars = n3 / this.fixedmetrics.charWidth(' ');
            this.backing_store = this.createImage(n3, n4);
            this.g_store = this.backing_store.getGraphics();
            this.g_store.setColor(this.zbcolor);
            this.g_store.fillRect(0, 0, n3, n4);
            this.lines = n5;
        }
        super.reshape(n, n2, n3, n4);
    }

    public int charwidth() {
        return this.fixedmetrics.charWidth(' ');
    }

    public synchronized void settext(int n, int n2, char[] cArray, int n3, int n4) {
        this.settext(n, n2, cArray, n3, n4, false, this.fixedfont);
    }

    public synchronized void settext(int n, int n2, char[] cArray, int n3, int n4, boolean bl, Font font) {
        try {
            this.g_store.setFont(font);
            this.drawtext(this.g_store, n, n2, cArray, n3, n4, bl);
            if (!this.hasscrolled) {
                Graphics graphics = this.getGraphics();
                graphics.setFont(font);
                this.drawtext(graphics, n, n2, cArray, n3, n4, bl);
            }
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("No graphics in settext");
        }
    }

    protected synchronized void drawtext(Graphics graphics, int n, int n2, char[] cArray, int n3, int n4, boolean bl) {
        int n5 = n4 * this.fixedmetrics.charWidth(' ');
        int n6 = this.fixedmetrics.getHeight();
        int n7 = n2 * this.fixedmetrics.charWidth(' ');
        int n8 = n6 * (n + 1) - this.fixedmetrics.getDescent();
        if (bl) {
            graphics.setColor(this.getForeground());
            graphics.fillRect(n7, n6 * n, n5, n6);
            graphics.setColor(this.zbcolor);
        } else {
            graphics.setColor(this.zbcolor);
            graphics.fillRect(n7, n6 * n, n5, n6);
            graphics.setColor(this.getForeground());
        }
        graphics.drawChars(cArray, n3, n4, n7, n8);
        graphics.setColor(this.getForeground());
    }

    public synchronized void scrollLines(int n, int n2, int n3) {
        try {
            int n4 = n * this.fixedmetrics.getHeight();
            this.g_store.copyArea(0, n4 + n3 * this.fixedmetrics.getHeight(), this.size().width, (n2 - n3) * this.fixedmetrics.getHeight(), 0, -n3 * this.fixedmetrics.getHeight());
            this.g_store.setColor(this.zbcolor);
            this.g_store.fillRect(0, n4 + (n2 - 1) * this.fixedmetrics.getHeight(), this.size().width, this.fixedmetrics.getHeight());
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("No graphics in scrollLines");
        }
        this.repaint();
        this.hasscrolled = true;
    }

    public synchronized void paint(Graphics graphics) {
        graphics.drawImage(this.backing_store, 0, 0, null);
        this.inputcursor.redraw(graphics);
        this.hasscrolled = false;
    }

    public void update(Graphics graphics) {
        graphics.setColor(this.getForeground());
        this.paint(graphics);
    }

    public void clear() {
        Dimension dimension = this.size();
        try {
            this.g_store.setColor(this.zbcolor);
            this.g_store.fillRect(0, 0, dimension.width, dimension.height);
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("No graphics in clear");
        }
        this.repaint();
    }

    public int getZForeground() {
        return this.zforeground;
    }

    public int getZBackground() {
        return this.zbackground;
    }

    public void setZForeground(int n) {
        this.zforeground = n;
        this.setForeground(ZColor.getcolor(n));
    }

    public void setZBackground(int n) {
        this.zbackground = n;
        this.zbcolor = ZColor.getcolor(n);
    }

    public Frame getFrame() {
        Component component = this;
        while (!(component instanceof Frame)) {
            component = component.getParent();
        }
        return (Frame)component;
    }

    public Dimension minimumSize() {
        return new Dimension(100, 100);
    }

    public Dimension preferredSize() {
        return new Dimension(500, 500);
    }
}

