/*
 * Decompiled with CFR 0.152.
 */
package russotto.zplet.screenmodel;

import java.awt.Font;
import russotto.zplet.screenmodel.ZScreen;

public class ZWindow {
    static final int ROMAN = 0;
    static final int REVERSE = 1;
    static final int BOLD = 2;
    static final int ITALIC = 4;
    static final int FIXED = 8;
    static final char FIRST_STYLE = '\u8000';
    static final char BUF_ROMAN = '\u8000';
    static final char BUF_REVERSE = '\u8001';
    static final char BUF_BOLD = '\u8002';
    static final char BUF_ITALIC = '\u8004';
    static final char BUF_FIXED = '\u8008';
    static final char LAST_STYLE = '\u800f';
    static final int NORMAL_FONT = 1;
    static final int PICTURE_FONT = 2;
    static final int GRAPHICS_FONT = 3;
    static final int FIXED_FONT = 4;
    static final char FIRST_FONT = '\u8010';
    static final char BUF_NORMAL_FONT = '\u8010';
    static final char BUF_PICTURE_FONT = '\u8011';
    static final char BUF_GRAPHICS_FONT = '\u8012';
    static final char BUF_FIXED_FONT = '\u8013';
    static final char LAST_FONT = '\u8013';
    ZScreen myscreen;
    int top = 0;
    int left = 0;
    int width = 10;
    int height = 10;
    int cursorx = 0;
    int cursory = 0;
    boolean buffer;
    boolean wrap;
    boolean scroll;
    boolean transcriptmode;
    int curzfont = 1;
    int curzstyle = 0;
    Font curfont;
    String linebuffer;
    int line_counter = 0;
    int zforeground;
    int zbackground;
    int residual = 0;

    public ZWindow(ZScreen zScreen) {
        this.myscreen = zScreen;
        this.curfont = zScreen.fixedfont;
        this.buffer = true;
        this.wrap = true;
        this.scroll = true;
        this.transcriptmode = true;
        this.linebuffer = "";
        this.zforeground = zScreen.zforeground;
        this.zbackground = zScreen.zbackground;
    }

    public void reset_line_count() {
        this.line_counter = 0;
    }

    void count_line() {
        ++this.line_counter;
    }

    void check_for_more() {
        String string = "[MORE]";
        String string2 = "         ";
        if (this.line_counter >= this.height - 1) {
            this.myscreen.settext(this.top + this.cursory, this.left, string.toCharArray(), 0, string.length(), true, this.myscreen.fixedfont);
            this.myscreen.read_code();
            this.myscreen.settext(this.top + this.cursory, this.left, string2.toCharArray(), 0, string2.length(), false, this.myscreen.fixedfont);
            this.line_counter = 0;
        }
    }

    public void erase_line(short s) {
        char[] cArray = new char[this.width];
        int n = 0;
        while (n < this.width) {
            cArray[n] = 32;
            n = (short)(n + 1);
        }
        if (s == 1) {
            this.myscreen.settext(this.cursory, this.left + this.cursorx, cArray, 0, this.width - this.cursorx);
        }
    }

    public void setbuffermode(boolean bl) {
        if (this.buffer && !bl) {
            this.flush();
        }
        this.buffer = bl;
    }

    public void setwrapmode(boolean bl) {
        if (this.buffer) {
            this.flush();
        }
        this.wrap = bl;
    }

    public void set_transcripting(boolean bl) {
        this.transcriptmode = bl;
    }

    public boolean transcripting() {
        return this.transcriptmode;
    }

    public void setscroll(boolean bl) {
        this.scroll = bl;
    }

    public void moveto(int n, int n2) {
        this.left = n;
        this.top = n2;
    }

    public void resize(int n, int n2) {
        this.width = n;
        this.height = n2;
        if (this.cursorx >= this.width || this.cursory >= this.height) {
            this.movecursor_noflush(0, 0);
        }
    }

    public int getLeft() {
        return this.left;
    }

    public int getTop() {
        return this.top;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getlines() {
        return this.height;
    }

    public int getchars() {
        return this.width;
    }

    public int getx() {
        return this.cursorx;
    }

    public int gety() {
        return this.cursory;
    }

    void movecursor_noflush(int n, int n2) {
        this.cursorx = n;
        this.cursory = n2;
    }

    public void movecursor(int n, int n2) {
        this.flush();
        this.cursorx = n;
        this.cursory = n2;
    }

    public void printzascii(short s) {
        short[] sArray = new short[]{s};
        this.printzascii(sArray);
    }

    public void printzascii(short[] sArray) {
        char[] cArray = new char[sArray.length];
        int n = 0;
        while (n < cArray.length) {
            cArray[n] = ZScreen.zascii_to_unicode(sArray[n]);
            ++n;
        }
        if (this.buffer) {
            this.bufferchars(cArray);
        } else {
            this.drawchars(cArray, 0, cArray.length);
        }
    }

    public void flush() {
        this.residual = this.charsWidth(this.linebuffer.toCharArray(), 0, this.linebuffer.length());
        this.drawstring(this.linebuffer);
        this.linebuffer = "";
    }

    public void newline() {
        this.newline(true);
    }

    protected void newline(boolean bl) {
        if (this.myscreen.zforeground != this.zforeground) {
            this.myscreen.setZForeground(this.zforeground);
        }
        if (this.myscreen.zbackground != this.zbackground) {
            this.myscreen.setZBackground(this.zbackground);
        }
        if (bl) {
            this.flush();
        }
        this.residual = 0;
        if (this.cursory == this.height - 1) {
            if (this.scroll) {
                this.myscreen.scrollLines(this.top, this.height, 1);
            }
            this.movecursor_noflush(0, this.cursory);
        } else {
            this.movecursor_noflush(0, this.cursory + 1);
        }
        this.count_line();
    }

    public synchronized void bufferchars(char[] cArray) {
        this.linebuffer = this.linebuffer + cArray;
        if (this.wrap) {
            int n = this.linebuffer.length();
            while (this.residual + this.charsWidth(this.linebuffer.toCharArray(), 0, n) > this.myscreen.size().width) {
                int n2 = this.linebuffer.lastIndexOf(32, n);
                if (n2 == -1) {
                    while (this.residual + this.charsWidth(this.linebuffer.toCharArray(), 0, n) > this.width * this.myscreen.charwidth()) {
                        --n;
                    }
                    this.drawchars(this.linebuffer.toCharArray(), 0, n);
                    this.linebuffer = this.linebuffer.substring(n);
                    this.newline(false);
                    n = this.linebuffer.length();
                    continue;
                }
                if (this.residual + this.charsWidth(this.linebuffer.toCharArray(), 0, n2) <= this.myscreen.size().width) {
                    String string = this.linebuffer.substring(0, n2);
                    this.drawstring(string);
                    while (n2 < this.linebuffer.length() && this.linebuffer.charAt(n2) == ' ') {
                        ++n2;
                    }
                    this.linebuffer = this.linebuffer.substring(n2);
                    n = this.linebuffer.length();
                    this.newline(false);
                    continue;
                }
                n = n2 - 1;
            }
        }
    }

    public void clear() {
        char[] cArray = new char[this.width];
        int n = 0;
        while (n < this.width) {
            cArray[n] = 32;
            ++n;
        }
        n = this.top;
        while (n < this.top + this.height) {
            this.myscreen.settext(n, this.left, cArray, 0, this.width);
            ++n;
        }
    }

    private void calculate_font() {
        int n = 0;
        Font font = this.myscreen.fixedfont;
        if ((this.curzstyle & 2) != 0) {
            n |= 1;
        }
        if ((this.curzstyle & 4) != 0) {
            n |= 2;
        }
        this.curfont = new Font(font.getName(), n, font.getSize());
    }

    public void set_color(int n, int n2) {
        this.flush();
        if (n != 0) {
            this.zforeground = n;
        }
        if (n2 != 0) {
            this.zbackground = n2;
        }
    }

    public void set_text_style(int n) {
        this.set_text_style(n, false);
    }

    protected void set_text_style(int n, boolean bl) {
        char[] cArray = new char[1];
        if (bl || !this.buffer) {
            this.curzstyle = n == 0 ? 0 : (this.curzstyle |= n);
            this.calculate_font();
        } else {
            cArray[0] = (char)(n | 0x8000);
            this.bufferchars(cArray);
        }
    }

    private boolean is_control(char c) {
        return c >= '\u8000';
    }

    private void parse_control(char c) {
        if (c >= '\u8000' && c <= '\u800f') {
            this.set_text_style(c & 0xFFFF7FFF, true);
        }
    }

    public void drawchars(char[] cArray, int n, int n2) {
        char c = '\u0000';
        if (n2 != 0) {
            if (this.myscreen.zforeground != this.zforeground) {
                this.myscreen.setZForeground(this.zforeground);
            }
            if (this.myscreen.zbackground != this.zbackground) {
                this.myscreen.setZBackground(this.zbackground);
            }
            if (this.scroll && this.cursorx == 0) {
                this.check_for_more();
            }
            int n3 = n;
            int n4 = 0;
            while (n3 < n + n2) {
                int n5 = n3 - n;
                while (n5 < n2) {
                    if (this.is_control(cArray[n + n5])) {
                        c = cArray[n + n5];
                        break;
                    }
                    ++n5;
                    ++n4;
                }
                this.myscreen.settext(this.top + this.cursory, this.left + this.cursorx, cArray, n3, n4, (this.curzstyle & 1) == 1, this.curfont);
                this.parse_control(c);
                c = '\u0000';
                n3 += n4 + 1;
                this.cursorx += n4;
                n4 = 0;
            }
        }
    }

    public void drawstring(String string) {
        this.drawchars(string.toCharArray(), 0, string.length());
    }

    public int charsWidth(char[] cArray, int n, int n2) {
        return this.myscreen.charwidth() * n2;
    }
}

