/*
 * Decompiled with CFR 0.152.
 */
package russotto.zplet.zmachine;

import russotto.zplet.zmachine.ZFrameBound;
import russotto.zplet.zmachine.ZMachine;
import russotto.zplet.zmachine.state.ZState;

public class ZInstruction {
    protected final short ZFALSE = 0;
    protected final short ZTRUE = 1;
    protected final short ZNOTDONE = 0;
    protected final short ZSAVE_SUCCESS = 1;
    protected final short ZRESTORE_SUCCESS = (short)2;
    protected static final int OP_JE = 1;
    protected static final int OP_JL = 2;
    protected static final int OP_JG = 3;
    protected static final int OP_DEC_CHK = 4;
    protected static final int OP_INC_CHK = 5;
    protected static final int OP_JIN = 6;
    protected static final int OP_TEST = 7;
    protected static final int OP_OR = 8;
    protected static final int OP_AND = 9;
    protected static final int OP_TEST_ATTR = 10;
    protected static final int OP_SET_ATTR = 11;
    protected static final int OP_CLEAR_ATTR = 12;
    protected static final int OP_STORE = 13;
    protected static final int OP_INSERT_OBJ = 14;
    protected static final int OP_LOADW = 15;
    protected static final int OP_LOADB = 16;
    protected static final int OP_GET_PROP = 17;
    protected static final int OP_GET_PROP_ADDR = 18;
    protected static final int OP_GET_NEXT_PROP = 19;
    protected static final int OP_ADD = 20;
    protected static final int OP_SUB = 21;
    protected static final int OP_MUL = 22;
    protected static final int OP_DIV = 23;
    protected static final int OP_MOD = 24;
    protected static final int OP_JZ = 128;
    protected static final int OP_GET_SIBLING = 129;
    protected static final int OP_GET_CHILD = 130;
    protected static final int OP_GET_PARENT = 131;
    protected static final int OP_GET_PROP_LEN = 132;
    protected static final int OP_INC = 133;
    protected static final int OP_DEC = 134;
    protected static final int OP_PRINT_ADDR = 135;
    public static final int OP_CALL_1S = 136;
    protected static final int OP_REMOVE_OBJ = 137;
    protected static final int OP_PRINT_OBJ = 138;
    protected static final int OP_RET = 139;
    protected static final int OP_JUMP = 140;
    protected static final int OP_PRINT_PADDR = 141;
    protected static final int OP_LOAD = 142;
    protected static final int OP_NOT = 143;
    protected static final int OP_RTRUE = 176;
    protected static final int OP_RFALSE = 177;
    protected static final int OP_PRINT = 178;
    protected static final int OP_PRINT_RET = 179;
    protected static final int OP_NOP = 180;
    protected static final int OP_SAVE = 181;
    protected static final int OP_RESTORE = 182;
    protected static final int OP_RESTART = 183;
    protected static final int OP_RET_POPPED = 184;
    protected static final int OP_POP = 185;
    protected static final int OP_QUIT = 186;
    protected static final int OP_NEW_LINE = 187;
    protected static final int OP_SHOW_STATUS = 188;
    protected static final int OP_VERIFY = 189;
    protected static final int OP_EXTENDED = 190;
    protected static final int OP_PIRACY = 191;
    protected static final int OP_CALL = 224;
    protected static final int OP_STOREW = 225;
    protected static final int OP_STOREB = 226;
    protected static final int OP_PUT_PROP = 227;
    protected static final int OP_SREAD = 228;
    protected static final int OP_PRINT_CHAR = 229;
    protected static final int OP_PRINT_NUM = 230;
    protected static final int OP_RANDOM = 231;
    protected static final int OP_PUSH = 232;
    protected static final int OP_PULL = 233;
    protected static final int OP_SPLIT_WINDOW = 234;
    protected static final int OP_SET_WINDOW = 235;
    protected static final int OP_CALL_VS2 = 236;
    protected static final int OP_OUTPUT_STREAM = 243;
    protected static final int OP_INPUT_STREAM = 244;
    protected static final int OP_SOUND_EFFECT = 245;
    protected static final int OP_CALL_VN2 = 250;
    protected static final int LOWER_WINDOW = 0;
    protected static final int UPPER_WINDOW = 1;
    protected int opnum;
    protected int count;
    protected int save_pc;
    protected short[] operands;
    protected short storevar;
    protected short branchoffset;
    protected boolean branchtype;
    protected ZMachine zm;
    static boolean[] store = null;
    static boolean[] branch = null;

    protected ZInstruction() {
    }

    public ZInstruction(ZMachine zMachine) {
        this.zm = zMachine;
        if (store == null) {
            store = new boolean[256];
            branch = new boolean[256];
            this.setupbs();
        }
        this.operands = new short[4];
    }

    public ZInstruction(int n, int n2, short[] sArray, short s, short s2, boolean bl) {
        this.opnum = n;
        this.count = n2;
        this.operands = sArray;
        this.storevar = s;
        this.branchoffset = s2;
        this.branchtype = bl;
    }

    public ZInstruction(int n, int n2, short[] sArray) {
        this(n, n2, sArray, 0, 0, false);
    }

    protected boolean isbranch() {
        return branch[this.opnum];
    }

    protected boolean isstore() {
        return store[this.opnum];
    }

    protected boolean isret() {
        switch (this.opnum) {
            case 139: 
            case 176: 
            case 177: 
            case 179: 
            case 184: {
                return true;
            }
        }
        return false;
    }

    public void decode_instruction() {
        this.decode_first_half();
        this.save_pc = this.zm.pc;
        this.decode_second_half();
    }

    protected void decode_first_half() {
        byte by = 0;
        int n = 0;
        int n2 = this.zm.get_code_byte() & 0xFF;
        if (n2 == 190) {
            n = 192;
        }
        block0 : switch (n | n2 & 0xC0) {
            case 192: {
                int n3;
                this.opnum = n != 192 ? n2 : 0x100 | this.zm.get_code_byte() & 0xFF;
                if ((n2 & 0x20) == 0) {
                    this.opnum = n2 & 0x1F;
                }
                this.count = 0;
                byte by2 = this.zm.get_code_byte();
                if (this.opnum == 236 || this.opnum == 250) {
                    n3 = 2;
                    by = this.zm.get_code_byte();
                } else {
                    n3 = 1;
                }
                while (n3-- != 0) {
                    int n4 = (by2 & 0xC0) >> 6;
                    if (n4 == 3) break block0;
                    this.operands[this.count++] = this.zm.get_operand(n4);
                    n4 = (by2 & 0x30) >> 4;
                    if (n4 == 3) break block0;
                    this.operands[this.count++] = this.zm.get_operand(n4);
                    n4 = (by2 & 0xC) >> 2;
                    if (n4 == 3) break block0;
                    this.operands[this.count++] = this.zm.get_operand(n4);
                    n4 = by2 & 3;
                    if (n4 == 3) break block0;
                    this.operands[this.count++] = this.zm.get_operand(n4);
                    by2 = by;
                }
                break;
            }
            case 128: {
                int n5 = (n2 & 0x30) >> 4;
                if (n5 == 3) {
                    this.opnum = n2;
                    this.count = 0;
                    break;
                }
                this.opnum = n2 & 0x8F;
                this.count = 1;
                this.operands[0] = this.zm.get_operand(n5);
                break;
            }
            default: {
                this.opnum = n2 & 0x1F;
                this.count = 2;
                int n6 = ((n2 & 0x40) >> 6) + 1;
                this.operands[0] = this.zm.get_operand(n6);
                n6 = ((n2 & 0x20) >> 5) + 1;
                this.operands[1] = this.zm.get_operand(n6);
            }
        }
    }

    protected void decode_second_half() {
        if (this.isstore()) {
            this.storevar = this.zm.get_code_byte();
        }
        if (this.isbranch()) {
            this.branchoffset = this.zm.get_code_byte();
            boolean bl = this.branchtype = (this.branchoffset & 0x80) != 0;
            this.branchoffset = (this.branchoffset & 0x40) != 0 ? (short)(this.branchoffset & 0x3F) : ((this.branchoffset & 0x20) != 0 ? (short)(0xC000 | (this.branchoffset << 8 | (short)this.zm.get_code_byte() & 0xFF)) : (short)((this.branchoffset & 0x3F) << 8 | (short)this.zm.get_code_byte() & 0xFF));
        }
    }

    public void execute() {
        short s;
        switch (this.opnum) {
            case 1: {
                s = this.op_je();
                break;
            }
            case 2: {
                s = this.op_jl();
                break;
            }
            case 3: {
                s = this.op_jg();
                break;
            }
            case 4: {
                s = this.op_dec_chk();
                break;
            }
            case 5: {
                s = this.op_inc_chk();
                break;
            }
            case 6: {
                s = this.op_jin();
                break;
            }
            case 7: {
                s = this.op_test();
                break;
            }
            case 8: {
                s = this.op_or();
                break;
            }
            case 9: {
                s = this.op_and();
                break;
            }
            case 10: {
                s = this.op_test_attr();
                break;
            }
            case 11: {
                s = this.op_set_attr();
                break;
            }
            case 12: {
                s = this.op_clear_attr();
                break;
            }
            case 13: {
                s = this.op_store();
                break;
            }
            case 14: {
                s = this.op_insert_obj();
                break;
            }
            case 15: {
                s = this.op_loadw();
                break;
            }
            case 16: {
                s = this.op_loadb();
                break;
            }
            case 17: {
                s = this.op_get_prop();
                break;
            }
            case 18: {
                s = this.op_get_prop_addr();
                break;
            }
            case 19: {
                s = this.op_get_next_prop();
                break;
            }
            case 20: {
                s = this.op_add();
                break;
            }
            case 21: {
                s = this.op_sub();
                break;
            }
            case 22: {
                s = this.op_mul();
                break;
            }
            case 23: {
                s = this.op_div();
                break;
            }
            case 24: {
                s = this.op_mod();
                break;
            }
            case 128: {
                s = this.op_jz();
                break;
            }
            case 129: {
                s = this.op_get_sibling();
                break;
            }
            case 130: {
                s = this.op_get_child();
                break;
            }
            case 131: {
                s = this.op_get_parent();
                break;
            }
            case 132: {
                s = this.op_get_prop_len();
                break;
            }
            case 133: {
                s = this.op_inc();
                break;
            }
            case 134: {
                s = this.op_dec();
                break;
            }
            case 135: {
                s = this.op_print_addr();
                break;
            }
            case 136: {
                s = this.op_call_1s();
                break;
            }
            case 137: {
                s = this.op_remove_obj();
                break;
            }
            case 138: {
                s = this.op_print_obj();
                break;
            }
            case 139: {
                s = this.op_ret();
                break;
            }
            case 140: {
                s = this.op_jump();
                break;
            }
            case 141: {
                s = this.op_print_paddr();
                break;
            }
            case 142: {
                s = this.op_load();
                break;
            }
            case 143: {
                s = this.op_not();
                break;
            }
            case 176: {
                s = this.op_rtrue();
                break;
            }
            case 177: {
                s = this.op_rfalse();
                break;
            }
            case 178: {
                s = this.op_print();
                break;
            }
            case 179: {
                s = this.op_print_ret();
                break;
            }
            case 180: {
                s = this.op_nop();
                break;
            }
            case 181: {
                s = this.op_save();
                break;
            }
            case 182: {
                s = this.op_restore();
                break;
            }
            case 183: {
                s = this.op_restart();
                break;
            }
            case 184: {
                s = this.op_ret_popped();
                break;
            }
            case 185: {
                s = this.op_pop();
                break;
            }
            case 186: {
                s = this.op_quit();
                break;
            }
            case 187: {
                s = this.op_new_line();
                break;
            }
            case 188: {
                s = this.op_show_status();
                break;
            }
            case 189: {
                s = this.op_verify();
                break;
            }
            case 190: {
                s = this.op_extended();
                break;
            }
            case 191: {
                s = this.op_piracy();
                break;
            }
            case 224: {
                s = this.op_call();
                break;
            }
            case 225: {
                s = this.op_storew();
                break;
            }
            case 226: {
                s = this.op_storeb();
                break;
            }
            case 227: {
                s = this.op_put_prop();
                break;
            }
            case 228: {
                s = this.op_sread();
                break;
            }
            case 229: {
                s = this.op_print_char();
                break;
            }
            case 230: {
                s = this.op_print_num();
                break;
            }
            case 231: {
                s = this.op_random();
                break;
            }
            case 232: {
                s = this.op_push();
                break;
            }
            case 233: {
                s = this.op_pull();
                break;
            }
            case 234: {
                s = this.op_split_window();
                break;
            }
            case 235: {
                s = this.op_set_window();
                break;
            }
            case 243: {
                s = this.op_output_stream();
                break;
            }
            case 244: {
                s = this.op_input_stream();
                break;
            }
            case 245: {
                s = this.op_sound_effect();
                break;
            }
            default: {
                s = this.op_illegal();
            }
        }
        if (this.opnum != 224 && this.isstore() || this.isret()) {
            this.zm.set_variable(this.storevar, s);
        }
        if (this.isbranch() && s == 0 != this.branchtype) {
            switch (this.branchoffset) {
                case 0: {
                    this.z_ret();
                    this.zm.set_variable(this.storevar, (short)0);
                    break;
                }
                case 1: {
                    this.z_ret();
                    this.zm.set_variable(this.storevar, (short)1);
                    break;
                }
                default: {
                    this.zm.pc += this.branchoffset - 2;
                }
            }
        }
    }

    protected short op_illegal() {
        this.zm.fatal("Unknown opcode");
        return 0;
    }

    protected short op_je() {
        int n = 1;
        while (n < this.count) {
            if (this.operands[0] == this.operands[n]) {
                return 1;
            }
            ++n;
        }
        return 0;
    }

    protected short op_jl() {
        if (this.operands[0] < this.operands[1]) {
            return 1;
        }
        return 0;
    }

    protected short op_jg() {
        if (this.operands[0] > this.operands[1]) {
            return 1;
        }
        return 0;
    }

    protected short op_dec_chk() {
        short s = this.zm.get_variable(this.operands[0]);
        s = (short)(s - 1);
        this.zm.set_variable(this.operands[0], s);
        if (s < this.operands[1]) {
            return 1;
        }
        return 0;
    }

    protected short op_inc_chk() {
        short s = this.zm.get_variable(this.operands[0]);
        s = (short)(s + 1);
        this.zm.set_variable(this.operands[0], s);
        if (s > this.operands[1]) {
            return 1;
        }
        return 0;
    }

    protected short op_jin() {
        if (this.zm.objects.parent(this.operands[0]) == this.operands[1]) {
            return 1;
        }
        return 0;
    }

    protected short op_test() {
        if ((this.operands[0] & this.operands[1]) == this.operands[1]) {
            return 1;
        }
        return 0;
    }

    protected short op_or() {
        return (short)((this.operands[0] | this.operands[1]) & 0xFFFF);
    }

    protected short op_and() {
        return (short)(this.operands[0] & this.operands[1] & 0xFFFF);
    }

    protected short op_test_attr() {
        if (this.zm.objects.attribute(this.operands[0], this.operands[1])) {
            return 1;
        }
        return 0;
    }

    protected short op_set_attr() {
        this.zm.objects.set_attribute(this.operands[0], this.operands[1]);
        return 0;
    }

    protected short op_clear_attr() {
        this.zm.objects.clear_attribute(this.operands[0], this.operands[1]);
        return 0;
    }

    protected short op_store() {
        this.zm.set_variable(this.operands[0], this.operands[1]);
        return 0;
    }

    protected short op_insert_obj() {
        this.detach_obj(this.operands[0]);
        short s = this.zm.objects.child(this.operands[1]);
        this.zm.objects.set_child(this.operands[1], this.operands[0]);
        this.zm.objects.set_sibling(this.operands[0], s);
        this.zm.objects.set_parent(this.operands[0], this.operands[1]);
        return 0;
    }

    protected short op_loadw() {
        int n = (this.operands[0] & 0xFFFF) + (this.operands[1] & 0xFFFF) * 2;
        short s = (short)(this.zm.memory_image[n] << 8 & 0xFF00 | this.zm.memory_image[n + 1] & 0xFF);
        return s;
    }

    protected short op_loadb() {
        int n = (this.operands[0] & 0xFFFF) + (this.operands[1] & 0xFFFF);
        return (short)(this.zm.memory_image[n] & 0xFF);
    }

    protected short op_get_prop() {
        return this.zm.objects.prop(this.operands[0], this.operands[1]);
    }

    protected short op_get_prop_addr() {
        return this.zm.objects.prop_address(this.operands[0], this.operands[1]);
    }

    protected short op_get_next_prop() {
        return this.zm.objects.next_prop(this.operands[0], this.operands[1]);
    }

    protected short op_add() {
        return (short)(this.operands[0] + this.operands[1]);
    }

    protected short op_sub() {
        return (short)(this.operands[0] - this.operands[1]);
    }

    protected short op_mul() {
        return (short)(this.operands[0] * this.operands[1]);
    }

    protected short op_div() {
        short s = this.operands[0];
        short s2 = this.operands[1];
        if (s2 == 0) {
            this.zm.fatal("Remainder from division by zero");
        }
        return (short)(s / s2);
    }

    protected short op_mod() {
        short s = this.operands[0];
        short s2 = this.operands[1];
        if (s2 == 0) {
            this.zm.fatal("Remainder from division by zero");
        }
        return (short)(s % s2);
    }

    protected short op_jz() {
        if (this.operands[0] == 0) {
            return 1;
        }
        return 0;
    }

    protected short op_get_sibling() {
        return this.zm.objects.sibling(this.operands[0]);
    }

    protected short op_get_child() {
        return this.zm.objects.child(this.operands[0]);
    }

    protected short op_get_parent() {
        return this.zm.objects.parent(this.operands[0]);
    }

    protected short op_get_prop_len() {
        return this.zm.objects.prop_len(this.operands[0]);
    }

    protected short op_inc() {
        short s = this.zm.get_variable(this.operands[0]);
        s = (short)(s + 1);
        this.zm.set_variable(this.operands[0], s);
        return 0;
    }

    protected short op_dec() {
        short s = this.zm.get_variable(this.operands[0]);
        s = (short)(s - 1);
        this.zm.set_variable(this.operands[0], s);
        return 0;
    }

    protected short op_print_addr() {
        this.zm.print_string(this.operands[0] & 0xFFFF);
        return 0;
    }

    protected short op_call_1s() {
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    void detach_obj(short var1_1) {
        block1: {
            var2_2 = this.zm.objects.parent(var1_1);
            if (var2_2 == 0) break block1;
            var3_3 = this.zm.objects.child(var2_2);
            if (var3_3 != var1_1) ** GOTO lbl9
            this.zm.objects.set_child(var2_2, this.zm.objects.sibling(var1_1));
            break block1;
lbl-1000:
            // 1 sources

            {
                if ((var3_3 = this.zm.objects.sibling(var3_3)) != 0) continue;
                this.zm.fatal("Malformed object tree");
lbl9:
                // 3 sources

                ** while (this.zm.objects.sibling((short)var3_3) != var1_1)
            }
lbl10:
            // 1 sources

            this.zm.objects.set_sibling(var3_3, this.zm.objects.sibling(var1_1));
        }
    }

    protected short op_remove_obj() {
        this.detach_obj(this.operands[0]);
        this.zm.objects.set_parent(this.operands[0], (short)0);
        this.zm.objects.set_sibling(this.operands[0], (short)0);
        return 0;
    }

    protected short op_print_obj() {
        this.zm.print_string(this.zm.objects.short_name_addr(this.operands[0]));
        return 1;
    }

    protected void z_ret() {
        Object e;
        while (!((e = this.zm.zstack.pop()) instanceof short[])) {
        }
        this.zm.locals = (short[])e;
        this.zm.pc = (Integer)this.zm.zstack.pop();
        this.storevar = (short)((Integer)this.zm.zstack.pop()).intValue();
        this.zm.zstack.pop();
    }

    protected short op_ret() {
        this.z_ret();
        return this.operands[0];
    }

    protected short op_jump() {
        this.zm.pc += this.operands[0] - 2;
        return 0;
    }

    protected short op_print_paddr() {
        this.zm.print_string(this.zm.string_address(this.operands[0]));
        return 0;
    }

    protected short op_load() {
        return this.zm.get_variable(this.operands[0]);
    }

    protected short op_not() {
        return ~this.operands[0];
    }

    protected short op_rtrue() {
        this.z_ret();
        return 1;
    }

    protected short op_rfalse() {
        this.z_ret();
        return 0;
    }

    protected short op_print() {
        int n = this.zm.print_string(this.zm.pc);
        this.zm.pc += n;
        return 0;
    }

    protected short op_print_ret() {
        this.zm.print_string(this.zm.pc);
        this.zm.print_ascii_char((short)13);
        this.z_ret();
        return 1;
    }

    protected short op_nop() {
        return 0;
    }

    protected short op_save() {
        if (new ZState(this.zm).disk_save(this.zm.screen.getFrame(), this.save_pc)) {
            return 1;
        }
        return 0;
    }

    protected short op_restore() {
        ZState zState = new ZState(this.zm);
        if (zState.restore_from_disk(this.zm.screen.getFrame())) {
            this.zm.restore(zState);
            this.decode_second_half();
            return 2;
        }
        return 0;
    }

    protected short op_restart() {
        this.zm.restart();
        return 0;
    }

    protected short op_ret_popped() {
        short s = this.zm.get_variable((short)0);
        this.z_ret();
        return s;
    }

    protected short op_pop() {
        this.zm.get_variable((short)0);
        return 0;
    }

    protected short op_quit() {
        this.zm.print_ascii_char((short)42);
        this.zm.print_ascii_char((short)42);
        this.zm.print_ascii_char((short)42);
        this.zm.print_ascii_char((short)69);
        this.zm.print_ascii_char((short)78);
        this.zm.print_ascii_char((short)68);
        this.zm.print_ascii_char((short)32);
        this.zm.print_ascii_char((short)79);
        this.zm.print_ascii_char((short)70);
        this.zm.print_ascii_char((short)32);
        this.zm.print_ascii_char((short)83);
        this.zm.print_ascii_char((short)69);
        this.zm.print_ascii_char((short)83);
        this.zm.print_ascii_char((short)83);
        this.zm.print_ascii_char((short)73);
        this.zm.print_ascii_char((short)79);
        this.zm.print_ascii_char((short)78);
        this.zm.print_ascii_char((short)42);
        this.zm.print_ascii_char((short)42);
        this.zm.print_ascii_char((short)42);
        this.zm.print_ascii_char((short)13);
        this.zm.stop();
        return 0;
    }

    protected short op_new_line() {
        this.zm.print_ascii_char((short)13);
        return 0;
    }

    protected short op_show_status() {
        this.zm.update_status_line();
        return 0;
    }

    protected short op_verify() {
        int n = this.zm.header.file_length();
        if (n > this.zm.memory_image.length || this.zm.header.checksum() != this.zm.checksum) {
            System.err.println("VERIFY failed: ");
            System.err.println("\texpected\tactual");
            System.err.println("length\t" + n + "\t" + this.zm.memory_image.length);
            System.err.println("checksum\t" + Integer.toString(this.zm.header.checksum() & 0xFFFF, 16) + "\t" + Integer.toString(this.zm.checksum, 16));
            return 0;
        }
        return 1;
    }

    protected short op_extended() {
        return 0;
    }

    protected short op_piracy() {
        return 0;
    }

    protected short op_call() {
        if (this.operands[0] == 0) {
            this.zm.set_variable(this.storevar, (short)0);
        } else {
            this.zm.zstack.push(new ZFrameBound(this.isstore()));
            this.zm.zstack.push(new Integer(this.storevar));
            this.zm.zstack.push(new Integer(this.zm.pc));
            this.zm.zstack.push(this.zm.locals);
            this.zm.pc = this.zm.routine_address(this.operands[0]);
            int n = this.zm.get_code_byte();
            this.zm.locals = new short[n];
            int n2 = 0;
            while (n2 < n) {
                short s = (short)(this.zm.get_code_byte() << 8 & 0xFF00 | this.zm.get_code_byte() & 0xFF);
                this.zm.locals[n2] = n2 < this.count - 1 ? this.operands[n2 + 1] : s;
                ++n2;
            }
        }
        return 0;
    }

    protected short op_storew() {
        int n = (this.operands[0] & 0xFFFF) + (this.operands[1] & 0xFFFF) * 2;
        this.zm.memory_image[n] = (byte)(this.operands[2] >>> 8);
        this.zm.memory_image[n + 1] = (byte)(this.operands[2] & 0xFF);
        return 0;
    }

    protected short op_storeb() {
        int n = (this.operands[0] & 0xFFFF) + (this.operands[1] & 0xFFFF);
        this.zm.memory_image[n] = (byte)(this.operands[2] & 0xFF);
        return 0;
    }

    protected short op_put_prop() {
        this.zm.objects.put_prop(this.operands[0], this.operands[1], this.operands[2]);
        return 0;
    }

    protected short op_sread() {
        byte by;
        int n = this.operands[0] & 0xFFFF;
        this.zm.update_status_line();
        this.zm.current_window.flush();
        this.zm.current_window.reset_line_count();
        int n2 = this.zm.memory_image[n] & 0xFF;
        if (n2 < 2) {
            this.zm.fatal("Text Buffer < 3 bytes");
        }
        --n2;
        int n3 = 1;
        while (n2 != 0 && (by = this.zm.get_input_byte(true)) != 13 && by != 10) {
            if (by >= 65 && by <= 90) {
                by = (byte)(by - 65 + 97);
            }
            this.zm.memory_image[n + n3] = by;
            ++n3;
            --n2;
        }
        this.zm.memory_image[n + n3] = 0;
        this.zm.zd.tokenise(n + 1, n3 - 1, this.operands[1] & 0xFFFF);
        return 0;
    }

    protected short op_print_char() {
        this.zm.print_ascii_char(this.operands[0]);
        return 0;
    }

    protected short op_print_num() {
        char[] cArray = Integer.toString(this.operands[0], 10).toCharArray();
        int n = 0;
        while (n < cArray.length) {
            this.zm.print_ascii_char((short)cArray[n]);
            ++n;
        }
        return 0;
    }

    protected short op_random() {
        if (this.operands[0] == 0) {
            this.zm.zrandom.setSeed(System.currentTimeMillis());
            return 0;
        }
        if (this.operands[0] < 0) {
            this.zm.zrandom.setSeed(-this.operands[0]);
            return 0;
        }
        return (short)((this.zm.zrandom.nextInt() & Short.MAX_VALUE) % this.operands[0] + 1);
    }

    protected short op_push() {
        this.zm.set_variable((short)0, this.operands[0]);
        return 0;
    }

    protected short op_pull() {
        this.zm.set_variable(this.operands[0], this.zm.get_variable((short)0));
        return 0;
    }

    protected void split_screen(int n) {
        this.zm.window[1].flush();
        this.zm.window[0].flush();
        int n2 = this.zm.window[0].getx();
        int n3 = this.zm.window[0].gety() + this.zm.window[1].getlines();
        if ((n3 -= n) < 0) {
            n3 = 0;
        }
        this.zm.window[0].moveto(0, n);
        this.zm.window[1].moveto(0, 0);
        this.zm.window[0].resize(this.zm.screen.getchars(), this.zm.screen.getlines() - n);
        this.zm.window[1].resize(this.zm.screen.getchars(), n);
        if (n3 >= this.zm.screen.getlines() - n) {
            n3 = this.zm.screen.getlines() - n - 1;
        }
        this.zm.window[0].movecursor(n2, n3);
    }

    protected short op_split_window() {
        this.split_screen(this.operands[0]);
        return 0;
    }

    protected short op_set_window() {
        this.zm.current_window.flush();
        this.zm.current_window = this.zm.window[this.operands[0]];
        if (this.operands[0] == 1) {
            this.zm.current_window.movecursor(0, 0);
        }
        return 0;
    }

    protected short op_output_stream() {
        this.zm.current_window.flush();
        if (this.operands[0] == 3) {
            this.zm.printmemory = this.operands[1] & 0xFFFF;
            this.zm.memory_image[this.zm.printmemory] = 0;
            this.zm.memory_image[this.zm.printmemory + 1] = 0;
        } else if (this.operands[0] == 2) {
            this.zm.header.set_transcripting(true);
        } else if (this.operands[0] == -2) {
            this.zm.header.set_transcripting(false);
        }
        if (this.operands[0] > 0) {
            this.zm.outputs[this.operands[0]] = true;
        } else {
            this.zm.outputs[-this.operands[0]] = false;
        }
        return 0;
    }

    protected short op_input_stream() {
        this.zm.inputstream = this.operands[0];
        return 0;
    }

    protected short op_sound_effect() {
        return 0;
    }

    protected void setupbs() {
        ZInstruction.branch[1] = true;
        ZInstruction.branch[2] = true;
        ZInstruction.branch[3] = true;
        ZInstruction.branch[4] = true;
        ZInstruction.branch[5] = true;
        ZInstruction.branch[6] = true;
        ZInstruction.branch[7] = true;
        ZInstruction.store[8] = true;
        ZInstruction.store[9] = true;
        ZInstruction.branch[10] = true;
        ZInstruction.store[15] = true;
        ZInstruction.store[16] = true;
        ZInstruction.store[17] = true;
        ZInstruction.store[18] = true;
        ZInstruction.store[19] = true;
        ZInstruction.store[20] = true;
        ZInstruction.store[21] = true;
        ZInstruction.store[22] = true;
        ZInstruction.store[23] = true;
        ZInstruction.store[24] = true;
        ZInstruction.branch[128] = true;
        ZInstruction.branch[129] = true;
        ZInstruction.store[129] = true;
        ZInstruction.branch[130] = true;
        ZInstruction.store[130] = true;
        ZInstruction.store[131] = true;
        ZInstruction.store[132] = true;
        ZInstruction.store[142] = true;
        ZInstruction.store[143] = true;
        ZInstruction.branch[181] = true;
        ZInstruction.branch[182] = true;
        ZInstruction.branch[189] = true;
        ZInstruction.branch[191] = true;
        ZInstruction.store[224] = true;
        ZInstruction.store[231] = true;
    }
}

