/*
 * Decompiled with CFR 0.152.
 */
package russotto.zplet.zmachine;

import java.util.EmptyStackException;
import java.util.Random;
import java.util.Stack;
import russotto.zplet.screenmodel.ZScreen;
import russotto.zplet.screenmodel.ZStatus;
import russotto.zplet.screenmodel.ZWindow;
import russotto.zplet.zmachine.ZDictionary;
import russotto.zplet.zmachine.ZHeader;
import russotto.zplet.zmachine.ZInstruction;
import russotto.zplet.zmachine.ZObjectTree;
import russotto.zplet.zmachine.state.ZState;

public abstract class ZMachine
extends Thread {
    public ZWindow current_window;
    public int pc;
    public ZWindow[] window;
    public ZHeader header;
    public ZScreen screen;
    public ZObjectTree objects;
    public ZDictionary zd;
    public ZState restart_state;
    protected ZStatus status_line;
    public byte[] memory_image;
    public Stack zstack;
    public Random zrandom;
    protected int globals;
    public short[] locals;
    protected int inputstream;
    protected boolean[] outputs;
    protected int printmemory;
    protected int alphabet;
    protected short build_ascii;
    protected short built_ascii;
    protected short abbrev_mode;
    protected short checksum;
    protected ZInstruction zi;
    protected boolean status_redirect;
    protected String status_location;
    protected final String A2 = "0123456789.,!?_#'\"/\\-:()";
    public static final int OP_LARGE = 0;
    public static final int OP_SMALL = 1;
    public static final int OP_VARIABLE = 2;
    public static final int OP_OMITTED = 3;

    public ZMachine(ZScreen zScreen, ZStatus zStatus, byte[] byArray) {
        this.screen = zScreen;
        this.status_line = zStatus;
        this.memory_image = byArray;
        this.locals = new short[0];
        this.zstack = new Stack();
        this.restart_state = new ZState(this);
        this.restart_state.save_current();
        this.zrandom = new Random();
        this.inputstream = 0;
        this.outputs = new boolean[5];
        this.outputs[1] = true;
        this.alphabet = 0;
    }

    public abstract void update_status_line();

    public byte get_input_byte(boolean bl) {
        int n;
        if (this.inputstream == 0) {
            this.screen.set_input_window(this.current_window);
            n = bl ? this.screen.read_buffered_code() : this.screen.read_code();
        } else {
            this.fatal("Stream " + Integer.toString(this.inputstream, 10) + " not supported.");
            n = 13;
        }
        return (byte)n;
    }

    public void print_ascii_string(String string) {
        int n = 0;
        while (n < string.length()) {
            this.print_ascii_char((short)string.charAt(n));
            ++n;
        }
    }

    public void print_ascii_char(short s) {
        if (this.status_redirect) {
            this.status_location = this.status_location + (char)s;
        } else if (this.outputs[3]) {
            int n = this.memory_image[this.printmemory] << 8 & 0xFF00 | this.memory_image[this.printmemory + 1] & 0xFF;
            this.memory_image[this.printmemory + n + 2] = s > 255 ? 63 : (s == 10 ? 13 : (byte)s);
            this.memory_image[this.printmemory] = (byte)(++n >>> 8);
            this.memory_image[this.printmemory + 1] = (byte)(n & 0xFF);
        } else {
            if (this.outputs[1]) {
                if (s == 13 || s == 10) {
                    this.current_window.newline();
                } else {
                    this.current_window.printzascii(s);
                }
            }
            this.outputs[2] = this.header.transcripting();
            if (this.outputs[2] && this.current_window.transcripting()) {
                if (s == 13 || s == 10) {
                    System.out.println();
                } else {
                    System.out.print((char)s);
                }
            }
        }
    }

    public abstract int string_address(short var1);

    public abstract int routine_address(short var1);

    public short[] encode_word(int n, int n2, int n3) {
        short[] sArray = new short[n3];
        int[] nArray = new int[n3 * 3];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            byte by = this.memory_image[n + n5];
            if (by >= 97 && by <= 122) {
                nArray[n4] = by - 97 + 6;
                if (++n4 == n3 * 3) {
                    break;
                }
            } else if (by >= 65 && by <= 90) {
                System.err.println("Tried to encode uppercase dictionary word");
                nArray[n4] = by - 65 + 6;
                if (++n4 == n3 * 3) {
                    break;
                }
            } else {
                int n6 = "0123456789.,!?_#'\"/\\-:()".indexOf(by);
                if (n6 != -1) {
                    nArray[n4] = 5;
                    if (++n4 == n3 * 3) break;
                    nArray[n4] = n6 + 8;
                    if (++n4 == n3 * 3) {
                        break;
                    }
                } else {
                    nArray[n4] = 5;
                    if (++n4 == n3 * 3) break;
                    nArray[n4] = 6;
                    if (++n4 == n3 * 3) break;
                    nArray[n4] = by >> 5;
                    if (++n4 == n3 * 3) break;
                    nArray[n4] = by & 0x1F;
                    if (++n4 == n3 * 3) break;
                }
            }
            ++n5;
        }
        while (n4 < n3 * 3) {
            nArray[n4++] = 5;
        }
        n4 = 0;
        n5 = 0;
        while (n5 < n3) {
            sArray[n5] = (short)(nArray[n4++] << 10);
            int n7 = n5;
            sArray[n7] = (short)(sArray[n7] | (short)(nArray[n4++] << 5));
            int n8 = n5++;
            sArray[n8] = (short)(sArray[n8] | (short)nArray[n4++]);
        }
        int n9 = n3 - 1;
        sArray[n9] = (short)(sArray[n9] | Short.MIN_VALUE);
        return sArray;
    }

    protected short alphabet_lookup(byte by) {
        switch (this.alphabet) {
            case 0: {
                return (short)(97 + by - 6);
            }
            case 1: {
                return (short)(65 + by - 6);
            }
            case 2: {
                if (by == 7) {
                    return 13;
                }
                return (short)"0123456789.,!?_#'\"/\\-:()".charAt(by - 8);
            }
        }
        this.fatal("Bad Alphabet");
        return -1;
    }

    void print_abbrev(int n) {
        this.abbrev_mode = (short)-1;
        int n2 = this.header.abbrev_table() + 2 * n;
        int n3 = (this.memory_image[n2] << 8 & 0xFF00 | this.memory_image[n2 + 1] & 0xFF) * 2;
        this.print_string(n3);
    }

    public void print_zchar(byte by) {
        if (this.build_ascii > 0) {
            this.built_ascii = (short)(this.built_ascii << 5 | by);
            this.build_ascii = (short)(this.build_ascii + 1);
            if (this.build_ascii == 3) {
                this.print_ascii_char(this.built_ascii);
                this.build_ascii = 0;
                this.built_ascii = 0;
            }
            this.alphabet = 0;
        } else if (this.abbrev_mode > 0) {
            this.print_abbrev(32 * (this.abbrev_mode - 1) + by);
            this.abbrev_mode = 0;
            this.build_ascii = 0;
            this.alphabet = 0;
        } else {
            switch (by) {
                case 0: {
                    this.print_ascii_char((short)32);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    if (this.abbrev_mode != 0) {
                        this.fatal("Abbreviation in abbreviation");
                    }
                    this.abbrev_mode = by;
                    this.alphabet = 0;
                    break;
                }
                case 4: {
                    this.alphabet = (this.alphabet + 1) % 3;
                    break;
                }
                case 5: {
                    this.alphabet = (this.alphabet + 2) % 3;
                    break;
                }
                case 6: {
                    if (this.alphabet == 2) {
                        this.build_ascii = 1;
                        this.alphabet = 0;
                        break;
                    }
                }
                default: {
                    this.print_ascii_char(this.alphabet_lookup(by));
                    this.alphabet = 0;
                }
            }
        }
    }

    public int print_string(int n) {
        int n2;
        int n3 = 0;
        this.build_ascii = 0;
        this.alphabet = 0;
        this.abbrev_mode = 0;
        byte[] byArray = new byte[3];
        do {
            n2 = this.memory_image[n++] << 8 & 0xFF00 | this.memory_image[n++] & 0xFF;
            byArray[0] = (byte)(n2 >> 10 & 0x1F);
            byArray[1] = (byte)(n2 >> 5 & 0x1F);
            byArray[2] = (byte)(n2 & 0x1F);
            int n4 = 0;
            while (n4 < 3) {
                this.print_zchar(byArray[n4]);
                ++n4;
            }
            n3 += 2;
        } while ((n2 & 0x8000) == 0);
        return n3;
    }

    public void start() {
        this.screen.clear();
        this.restart();
        this.header.set_transcripting(false);
        super.start();
    }

    public void run() {
        try {
            while (true) {
                this.zi.decode_instruction();
                this.zi.execute();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.err.print("pc = ");
            System.err.println(Integer.toString(this.pc, 16));
            throw arrayIndexOutOfBoundsException;
        }
        catch (ClassCastException classCastException) {
            System.err.print("pc = ");
            System.err.println(Integer.toString(this.pc, 16));
            throw classCastException;
        }
    }

    void calculate_checksum() {
        int n = this.header.file_length();
        this.checksum = 0;
        if (n <= this.memory_image.length) {
            int n2 = 64;
            while (n2 < n) {
                this.checksum = (short)(this.checksum + (this.memory_image[n2] & 0xFF));
                ++n2;
            }
        }
    }

    public void restart() {
        this.restart_state.header.set_transcripting(this.header.transcripting());
        this.restart_state.restore_saved();
        this.set_header_flags();
        this.pc = this.header.initial_pc();
        this.calculate_checksum();
    }

    public void restore(ZState zState) {
        zState.header.set_transcripting(this.header.transcripting());
        this.restart();
        zState.restore_saved();
    }

    public void set_header_flags() {
        this.header.set_revision(0, 2);
    }

    public void fatal(String string) {
        System.err.println(string + " @ $" + Integer.toString(this.pc, 16));
        System.exit(-1);
    }

    public short get_variable(short s) {
        short s2;
        if ((s = (short)(s & 0xFF)) == 0) {
            try {
                s2 = (short)((Integer)this.zstack.pop() & 0xFFFF);
            }
            catch (EmptyStackException emptyStackException) {
                this.fatal("Empty Stack");
                s2 = -1;
            }
        } else {
            s2 = s >= 16 ? (short)(this.memory_image[this.globals + (s - 16 << 1)] << 8 & 0xFF00 | this.memory_image[this.globals + (s - 16 << 1) + 1] & 0xFF) : this.locals[s - 1];
        }
        return s2;
    }

    public void set_variable(short s, short s2) {
        if ((s = (short)(s & 0xFF)) == 0) {
            this.zstack.push(new Integer(s2));
        } else if (s >= 16) {
            this.memory_image[this.globals + (s - 16 << 1)] = (byte)(s2 >>> 8);
            this.memory_image[this.globals + (s - 16 << 1) + 1] = (byte)(s2 & 0xFF);
        } else {
            this.locals[s - 1] = s2;
        }
    }

    public byte get_code_byte() {
        return this.memory_image[this.pc++];
    }

    public short get_operand(int n) {
        switch (n) {
            case 1: {
                return (short)(this.get_code_byte() & 0xFF);
            }
            case 0: {
                return (short)(this.get_code_byte() << 8 & 0xFF00 | this.get_code_byte() & 0xFF);
            }
            case 2: {
                return this.get_variable(this.get_code_byte());
            }
        }
        return -1;
    }
}

