/*
 * Decompiled with CFR 0.152.
 */
package russotto.zplet.zmachine;

import russotto.zplet.zmachine.ZMachine;

public abstract class ZObjectTree {
    protected ZMachine zm;
    protected int object_table;
    protected int object_tree;

    public ZObjectTree(ZMachine zMachine) {
        this.zm = zMachine;
        this.object_table = zMachine.header.object_table();
        this.object_tree = this.object_table + this.num_properties() * 2;
    }

    public short default_property(short s) {
        s = (short)(s - 1);
        short s2 = (short)(this.zm.memory_image[this.object_table + s * 2] << 8 & 0xFF00 | this.zm.memory_image[this.object_table + s * 2 + 1] & 0xFF);
        return s2;
    }

    protected abstract int num_properties();

    protected abstract int ptableoffset();

    protected abstract int getentryloc(short var1);

    public boolean attribute(short s, short s2) {
        int n;
        int n2;
        int n3 = this.getentryloc(s);
        return (this.zm.memory_image[n3 + (n2 = s2 >> 3)] & (n = 1 << 7 - (s2 & 7))) != 0;
    }

    public void set_attribute(short s, short s2) {
        int n = this.getentryloc(s);
        int n2 = s2 >> 3;
        int n3 = 1 << 7 - (s2 & 7);
        int n4 = n + n2;
        this.zm.memory_image[n4] = (byte)(this.zm.memory_image[n4] | (byte)n3);
    }

    public void clear_attribute(short s, short s2) {
        int n = this.getentryloc(s);
        int n2 = s2 >> 3;
        int n3 = 1 << 7 - (s2 & 7);
        int n4 = n + n2;
        this.zm.memory_image[n4] = (byte)(this.zm.memory_image[n4] & (byte)(n3 ^ 0xFF));
    }

    public abstract short parent(short var1);

    public abstract short child(short var1);

    public abstract short sibling(short var1);

    public abstract void set_parent(short var1, short var2);

    public abstract void set_sibling(short var1, short var2);

    public abstract void set_child(short var1, short var2);

    public int property_table_addr(short s) {
        int n = this.getentryloc(s);
        return this.zm.memory_image[n + this.ptableoffset()] << 8 & 0xFF00 | this.zm.memory_image[n + this.ptableoffset() + 1] & 0xFF;
    }

    public int short_name_addr(short s) {
        return this.property_table_addr(s) + 1;
    }

    public abstract int prop_entry_address(short var1, short var2);

    public abstract short next_prop(short var1, short var2);

    public abstract short prop_address(short var1, short var2);

    public abstract short prop_len(short var1);

    public short prop(short s, short s2) {
        int n = this.prop_entry_address(s, s2);
        if (n == 0) {
            return this.default_property(s2);
        }
        int n2 = (this.zm.memory_image[n] >>> 5) + 1;
        if (n2 == 1) {
            return (short)(this.zm.memory_image[n + 1] & 0xFF);
        }
        return (short)(this.zm.memory_image[n + 1] << 8 & 0xFF00 | this.zm.memory_image[n + 2] & 0xFF);
    }

    public void put_prop(short s, short s2, short s3) {
        int n = this.prop_entry_address(s, s2);
        if (n == 0) {
            this.zm.fatal("Tried to set nonexistent property");
        } else {
            int n2 = (this.zm.memory_image[n] >>> 5) + 1;
            if (n2 == 1) {
                this.zm.memory_image[n + 1] = (byte)(s3 & 0xFF);
            } else {
                this.zm.memory_image[n + 1] = (byte)(s3 >>> 8);
                this.zm.memory_image[n + 2] = (byte)(s3 & 0xFF);
            }
        }
    }
}

