/*
 * Decompiled with CFR 0.152.
 */
package russotto.zplet.zmachine.zmachine5;

import russotto.zplet.zmachine.ZHeader;

class ZHeader5
extends ZHeader {
    static final int INTERP_NUMBER = 30;
    static final int INTERP_VERSION = 31;
    static final int SCREEN_HEIGHT_LINES = 32;
    static final int SCREEN_WIDTH_CHARACTERS = 33;
    static final int SCREEN_WIDTH_UNITS = 34;
    static final int SCREEN_HEIGHT_UNITS = 36;
    static final int FONT_HEIGHT_UNITS = 38;
    static final int FONT_WIDTH_UNITS = 39;
    static final int DEFAULT_BACKGROUND_COLOR = 44;
    static final int DEFAULT_FOREGROUND_COLOR = 45;
    static final int FILE_LENGTH_FACTOR = 4;
    static final int INTERP_DEC = 1;
    static final int INTERP_APPLEIIE = 2;
    static final int INTERP_MAC = 3;
    static final int INTERP_AMIGA = 4;
    static final int INTERP_ATARIST = 5;
    static final int INTERP_MSDOS = 6;
    static final int INTERP_C128 = 7;
    static final int INTERP_C64 = 8;
    static final int INTERP_APPLEIIC = 9;
    static final int INTERP_APPLEIIGS = 10;
    static final int INTERP_COCO = 11;

    public ZHeader5(byte[] byArray) {
        this.memory_image = byArray;
    }

    public void set_colors_available(boolean bl) {
        this.memory_image[1] = bl ? (byte)(this.memory_image[1] | 1) : (byte)(this.memory_image[1] & 0xFE);
    }

    public void set_bold_available(boolean bl) {
        this.memory_image[1] = bl ? (byte)(this.memory_image[1] | 4) : (byte)(this.memory_image[1] & 0xFB);
    }

    public void set_italic_available(boolean bl) {
        this.memory_image[1] = bl ? (byte)(this.memory_image[1] | 8) : (byte)(this.memory_image[1] & 0xF7);
    }

    public void set_fixed_font_available(boolean bl) {
        this.memory_image[1] = bl ? (byte)(this.memory_image[1] | 0x10) : (byte)(this.memory_image[1] & 0xEF);
    }

    public void set_timed_input_available(boolean bl) {
        this.memory_image[1] = bl ? (byte)(this.memory_image[1] | 0x80) : (byte)(this.memory_image[1] & 0x7F);
    }

    public boolean graphics_font_wanted() {
        return (this.memory_image[17] & 8) != 0;
    }

    public void set_graphics_font_available(boolean bl) {
        if (!bl) {
            this.memory_image[17] = (byte)(this.memory_image[17] & 0xF7);
        }
    }

    public boolean undo_wanted() {
        return (this.memory_image[17] & 0x10) != 0;
    }

    void set_undo_available(boolean bl) {
        if (!bl) {
            this.memory_image[17] = (byte)(this.memory_image[17] & 0xEF);
        }
    }

    public boolean mouse_wanted() {
        return (this.memory_image[17] & 0x20) != 0;
    }

    public void set_mouse_available(boolean bl) {
        if (!bl) {
            this.memory_image[17] = (byte)(this.memory_image[17] & 0xDF);
        }
    }

    public boolean colors_wanted() {
        return (this.memory_image[17] & 0x40) != 0;
    }

    public boolean sound_wanted() {
        return (this.memory_image[17] & 0x80) != 0;
    }

    public void set_sound_available(boolean bl) {
        if (!bl) {
            this.memory_image[17] = (byte)(this.memory_image[17] & 0x7F);
        }
    }

    public void set_interpreter_number(int n) {
        this.memory_image[30] = (byte)n;
    }

    public void set_interpreter_version(int n) {
        this.memory_image[31] = (byte)n;
    }

    public void set_screen_height_lines(int n) {
        this.memory_image[32] = (byte)n;
    }

    public void set_screen_width_characters(int n) {
        this.memory_image[33] = (byte)n;
    }

    public void set_screen_height_units(int n) {
        this.memory_image[36] = (byte)(n >> 8);
        this.memory_image[37] = (byte)(n & 0xFF);
    }

    public void set_screen_width_units(int n) {
        this.memory_image[34] = (byte)(n >> 8);
        this.memory_image[35] = (byte)(n & 0xFF);
    }

    public void set_font_height_units(int n) {
        this.memory_image[38] = (byte)n;
    }

    public void set_font_width_units(int n) {
        this.memory_image[39] = (byte)n;
    }

    public int default_background_color() {
        return this.memory_image[44];
    }

    public int default_foreground_color() {
        return this.memory_image[45];
    }

    public void set_default_background_color(int n) {
        this.memory_image[44] = (byte)n;
    }

    public void set_default_foreground_color(int n) {
        this.memory_image[45] = (byte)n;
    }

    public int file_length() {
        int n = (this.memory_image[26] & 0xFF) << 8 | this.memory_image[27] & 0xFF;
        return n * 4;
    }
}

