/*
 * Decompiled with CFR 0.152.
 */
package russotto.zplet.zmachine.zmachine5;

import russotto.zplet.zmachine.ZFrameBound;
import russotto.zplet.zmachine.ZInstruction;
import russotto.zplet.zmachine.ZMachine;
import russotto.zplet.zmachine.state.ZState;
import russotto.zplet.zmachine.zmachine5.ZDictionary5;
import russotto.zplet.zmachine.zmachine5.ZHeader5;
import russotto.zplet.zmachine.zmachine5.ZMachine5;

public class ZInstruction5
extends ZInstruction {
    static final int OP_CALL_2S = 25;
    static final int OP_CALL_2N = 26;
    static final int OP_SET_COLOUR = 27;
    static final int OP_THROW = 28;
    static final int OP_CALL_1S = 136;
    static final int OP_CALL_1N = 143;
    static final int OP_OLD_SAVE = 181;
    static final int OP_OLD_RESTORE = 182;
    static final int OP_CATCH = 185;
    static final int OP_OLD_SHOW_STATUS = 188;
    static final int OP_VERIFY = 189;
    static final int OP_EXTENDED = 190;
    static final int OP_PIRACY = 191;
    static final int OP_CALL_VS = 224;
    static final int OP_AREAD = 228;
    static final int OP_CALL_VS2 = 236;
    static final int OP_ERASE_WINDOW = 237;
    static final int OP_ERASE_LINE = 238;
    static final int OP_SET_CURSOR = 239;
    static final int OP_GET_CURSOR = 240;
    static final int OP_SET_TEXT_STYLE = 241;
    static final int OP_BUFFER_MODE = 242;
    static final int OP_READ_CHAR = 246;
    static final int OP_SCAN_TABLE = 247;
    static final int OP_NOT = 248;
    public static final int OP_CALL_VN = 249;
    static final int OP_CALL_VN2 = 250;
    static final int OP_TOKENISE = 251;
    static final int OP_ENCODE_TEXT = 252;
    static final int OP_COPY_TABLE = 253;
    static final int OP_PRINT_TABLE = 254;
    static final int OP_CHECK_ARG_COUNT = 255;
    static final int OP_SAVE = 256;
    static final int OP_RESTORE = 257;
    static final int OP_LOG_SHIFT = 258;
    static final int OP_ART_SHIFT = 259;
    static final int OP_SET_FONT = 260;
    static final int OP_SAVE_UNDO = 265;
    static final int OP_RESTORE_UNDO = 266;
    static final int SCREEN_UNSPLIT = -1;
    static final int SCREEN_NOUNSPLIT = -2;
    protected short call_opnum;
    protected boolean has_returned = false;
    static boolean[] store5 = null;
    static boolean[] branch5 = null;

    ZInstruction5(ZMachine zMachine) {
        this.zm = zMachine;
        if (store5 == null) {
            store5 = new boolean[285];
            branch5 = new boolean[285];
            this.setupbs();
        }
        this.operands = new short[8];
    }

    public void decode_instruction() {
        this.has_returned = false;
        super.decode_instruction();
    }

    public void execute() {
        short s;
        switch (this.opnum) {
            case 1: {
                s = this.op_je();
                break;
            }
            case 2: {
                s = this.op_jl();
                break;
            }
            case 3: {
                s = this.op_jg();
                break;
            }
            case 4: {
                s = this.op_dec_chk();
                break;
            }
            case 5: {
                s = this.op_inc_chk();
                break;
            }
            case 6: {
                s = this.op_jin();
                break;
            }
            case 7: {
                s = this.op_test();
                break;
            }
            case 8: {
                s = this.op_or();
                break;
            }
            case 9: {
                s = this.op_and();
                break;
            }
            case 10: {
                s = this.op_test_attr();
                break;
            }
            case 11: {
                s = this.op_set_attr();
                break;
            }
            case 12: {
                s = this.op_clear_attr();
                break;
            }
            case 13: {
                s = this.op_store();
                break;
            }
            case 14: {
                s = this.op_insert_obj();
                break;
            }
            case 15: {
                s = this.op_loadw();
                break;
            }
            case 16: {
                s = this.op_loadb();
                break;
            }
            case 17: {
                s = this.op_get_prop();
                break;
            }
            case 18: {
                s = this.op_get_prop_addr();
                break;
            }
            case 19: {
                s = this.op_get_next_prop();
                break;
            }
            case 20: {
                s = this.op_add();
                break;
            }
            case 21: {
                s = this.op_sub();
                break;
            }
            case 22: {
                s = this.op_mul();
                break;
            }
            case 23: {
                s = this.op_div();
                break;
            }
            case 24: {
                s = this.op_mod();
                break;
            }
            case 25: {
                s = this.op_call_2s();
                break;
            }
            case 26: {
                s = this.op_call_2n();
                break;
            }
            case 27: {
                s = this.op_set_colour();
                break;
            }
            case 28: {
                s = this.op_throw();
                break;
            }
            case 128: {
                s = this.op_jz();
                break;
            }
            case 129: {
                s = this.op_get_sibling();
                break;
            }
            case 130: {
                s = this.op_get_child();
                break;
            }
            case 131: {
                s = this.op_get_parent();
                break;
            }
            case 132: {
                s = this.op_get_prop_len();
                break;
            }
            case 133: {
                s = this.op_inc();
                break;
            }
            case 134: {
                s = this.op_dec();
                break;
            }
            case 135: {
                s = this.op_print_addr();
                break;
            }
            case 136: {
                s = this.op_call_1s();
                break;
            }
            case 137: {
                s = this.op_remove_obj();
                break;
            }
            case 138: {
                s = this.op_print_obj();
                break;
            }
            case 139: {
                s = this.op_ret();
                break;
            }
            case 140: {
                s = this.op_jump();
                break;
            }
            case 141: {
                s = this.op_print_paddr();
                break;
            }
            case 142: {
                s = this.op_load();
                break;
            }
            case 143: {
                s = this.op_call_1n();
                break;
            }
            case 176: {
                s = this.op_rtrue();
                break;
            }
            case 177: {
                s = this.op_rfalse();
                break;
            }
            case 178: {
                s = this.op_print();
                break;
            }
            case 179: {
                s = this.op_print_ret();
                break;
            }
            case 180: {
                s = this.op_nop();
                break;
            }
            case 181: {
                s = this.op_illegal();
                break;
            }
            case 182: {
                s = this.op_illegal();
                break;
            }
            case 183: {
                s = this.op_restart();
                break;
            }
            case 184: {
                s = this.op_ret_popped();
                break;
            }
            case 185: {
                s = this.op_catch();
                break;
            }
            case 186: {
                s = this.op_quit();
                break;
            }
            case 187: {
                s = this.op_new_line();
                break;
            }
            case 188: {
                s = this.op_nop();
                break;
            }
            case 189: {
                s = this.op_verify();
                break;
            }
            case 190: {
                s = this.op_extended();
                break;
            }
            case 191: {
                s = this.op_piracy();
                break;
            }
            case 224: {
                s = this.op_call_vs();
                break;
            }
            case 225: {
                s = this.op_storew();
                break;
            }
            case 226: {
                s = this.op_storeb();
                break;
            }
            case 227: {
                s = this.op_put_prop();
                break;
            }
            case 228: {
                s = this.op_aread();
                break;
            }
            case 229: {
                s = this.op_print_char();
                break;
            }
            case 230: {
                s = this.op_print_num();
                break;
            }
            case 231: {
                s = this.op_random();
                break;
            }
            case 232: {
                s = this.op_push();
                break;
            }
            case 233: {
                s = this.op_pull();
                break;
            }
            case 234: {
                s = this.op_split_window();
                break;
            }
            case 235: {
                s = this.op_set_window();
                break;
            }
            case 236: {
                s = this.op_call_vs2();
                break;
            }
            case 237: {
                s = this.op_erase_window();
                break;
            }
            case 238: {
                s = this.op_erase_line();
                break;
            }
            case 239: {
                s = this.op_set_cursor();
                break;
            }
            case 240: {
                s = this.op_get_cursor();
                break;
            }
            case 241: {
                s = this.op_set_text_style();
                break;
            }
            case 242: {
                s = this.op_buffer_mode();
                break;
            }
            case 243: {
                s = this.op_output_stream();
                break;
            }
            case 244: {
                s = this.op_input_stream();
                break;
            }
            case 245: {
                s = this.op_sound_effect();
                break;
            }
            case 246: {
                s = this.op_read_char();
                break;
            }
            case 247: {
                s = this.op_scan_table();
                break;
            }
            case 248: {
                s = this.op_not();
                break;
            }
            case 249: {
                s = this.op_call_vn();
                break;
            }
            case 250: {
                s = this.op_call_vn2();
                break;
            }
            case 251: {
                s = this.op_tokenise();
                break;
            }
            case 252: {
                s = this.op_encode_text();
                break;
            }
            case 253: {
                s = this.op_copy_table();
                break;
            }
            case 254: {
                s = this.op_print_table();
                break;
            }
            case 255: {
                s = this.op_check_arg_count();
                break;
            }
            case 256: {
                s = this.op_save();
                break;
            }
            case 257: {
                s = this.op_restore();
                break;
            }
            case 258: {
                s = this.op_log_shift();
                break;
            }
            case 259: {
                s = this.op_art_shift();
                break;
            }
            case 260: {
                s = this.op_set_font();
                break;
            }
            case 265: {
                s = this.op_save_undo();
                break;
            }
            case 266: {
                s = this.op_restore_undo();
                break;
            }
            default: {
                s = this.op_illegal();
            }
        }
        if (!this.iscall() && this.isstore()) {
            this.zm.set_variable(this.storevar, s);
        }
        if (this.isbranch() && s == 0 != this.branchtype) {
            switch (this.branchoffset) {
                case 0: {
                    this.z_ret();
                    if (!this.isstore()) break;
                    this.zm.set_variable(this.storevar, (short)0);
                    break;
                }
                case 1: {
                    this.z_ret();
                    if (!this.isstore()) break;
                    this.zm.set_variable(this.storevar, (short)1);
                    break;
                }
                default: {
                    this.zm.pc += this.branchoffset - 2;
                }
            }
        }
    }

    protected boolean isbranch() {
        return branch5[this.opnum];
    }

    protected boolean isstore() {
        if (this.has_returned) {
            return store5[this.call_opnum];
        }
        return store5[this.opnum];
    }

    protected boolean iscall() {
        switch (this.opnum) {
            case 25: 
            case 26: 
            case 136: 
            case 143: 
            case 224: 
            case 236: 
            case 249: 
            case 250: {
                return true;
            }
        }
        return false;
    }

    protected short z_call() {
        if (this.operands[0] == 0) {
            if (this.isstore()) {
                this.zm.set_variable(this.storevar, (short)0);
            }
        } else {
            this.zm.zstack.push(new ZFrameBound(this.isstore()));
            if (this.isstore()) {
                this.zm.zstack.push(new Integer(this.storevar));
            }
            this.zm.zstack.push(new Integer(this.opnum));
            this.zm.zstack.push(new Integer(this.zm.pc));
            this.zm.zstack.push(new Integer(((ZMachine5)this.zm).argcount));
            this.zm.zstack.push(this.zm.locals);
            this.zm.pc = this.zm.routine_address(this.operands[0]);
            int n = this.zm.get_code_byte();
            ((ZMachine5)this.zm).argcount = (short)(this.count - 1);
            this.zm.locals = new short[n];
            int n2 = 0;
            while (n2 < n) {
                this.zm.locals[n2] = n2 < this.count - 1 ? this.operands[n2 + 1] : (short)0;
                ++n2;
            }
        }
        return 0;
    }

    protected void z_ret() {
        Object e;
        while (!((e = this.zm.zstack.pop()) instanceof short[])) {
        }
        this.zm.locals = (short[])e;
        ((ZMachine5)this.zm).argcount = (short)((Integer)this.zm.zstack.pop()).intValue();
        this.zm.pc = (Integer)this.zm.zstack.pop();
        this.call_opnum = (short)((Integer)this.zm.zstack.pop()).intValue();
        this.has_returned = true;
        if (this.isstore()) {
            this.storevar = (short)((Integer)this.zm.zstack.pop()).intValue();
        }
        this.zm.zstack.pop();
    }

    protected short op_call_2s() {
        this.z_call();
        return 0;
    }

    protected short op_call_2n() {
        this.z_call();
        return 0;
    }

    protected short op_set_colour() {
        int n = this.operands[0];
        int n2 = this.operands[1];
        if (n == 1) {
            n = ((ZHeader5)this.zm.header).default_foreground_color();
        }
        if (n2 == 1) {
            n2 = ((ZHeader5)this.zm.header).default_background_color();
        }
        this.zm.current_window.set_color(n, n2);
        return 0;
    }

    protected short op_throw() {
        return 0;
    }

    protected short op_call_1s() {
        this.z_call();
        return 0;
    }

    protected short op_call_1n() {
        this.z_call();
        return 0;
    }

    protected short op_catch() {
        return 0;
    }

    protected short op_call_vs() {
        this.z_call();
        return 0;
    }

    protected short op_aread() {
        int n = this.operands[0] & 0xFFFF;
        this.zm.current_window.flush();
        this.zm.current_window.reset_line_count();
        int n2 = this.zm.memory_image[n] & 0xFF;
        if (n2 < 3) {
            this.zm.fatal("Text Buffer < 3 bytes");
        }
        int n3 = 2;
        byte by = this.zm.get_input_byte(true);
        while (n2 != 0 && by != 13 && by != 10) {
            if (by >= 65 && by <= 90) {
                by = (byte)(by - 65 + 97);
            }
            this.zm.memory_image[n + n3] = by;
            ++n3;
            --n2;
            by = this.zm.get_input_byte(true);
        }
        this.zm.memory_image[n + 1] = (byte)(n3 - 2);
        if (this.operands[1] != 0) {
            this.zm.zd.tokenise(n + 2, n3 - 2, this.operands[1] & 0xFFFF);
        }
        return (short)(by & 0xFF);
    }

    protected short op_call_vs2() {
        this.z_call();
        return 0;
    }

    protected short op_erase_window() {
        if (this.operands[0] == -1) {
            this.split_screen(0);
            this.zm.screen.clear();
            this.zm.window[0].movecursor(0, 0);
            this.zm.window[0].reset_line_count();
        } else if (this.operands[0] == -2) {
            this.zm.screen.clear();
            this.zm.window[0].movecursor(0, 0);
            this.zm.window[0].reset_line_count();
            this.zm.window[1].movecursor(0, 0);
            this.zm.window[1].reset_line_count();
        } else {
            this.zm.window[this.operands[0]].clear();
            this.zm.window[this.operands[0]].movecursor(0, 0);
            this.zm.window[this.operands[0]].reset_line_count();
        }
        return 0;
    }

    protected short op_erase_line() {
        this.zm.current_window.erase_line(this.operands[0]);
        return 0;
    }

    protected short op_set_cursor() {
        int n = this.operands[1] & 0xFFFF;
        int n2 = this.operands[0] & 0xFFFF;
        if (this.zm.current_window == this.zm.window[1]) {
            this.zm.current_window.movecursor(n - 1, n2 - 1);
        }
        return 0;
    }

    protected short op_get_cursor() {
        int n = this.operands[0] & 0xFFFF;
        this.zm.current_window.flush();
        int n2 = this.zm.current_window.getx() + 1;
        int n3 = this.zm.current_window.gety() + 1;
        this.zm.memory_image[n] = (byte)(n3 >> 8 & 0xFF);
        this.zm.memory_image[n + 1] = (byte)(n3 & 0xFF);
        this.zm.memory_image[n + 2] = (byte)(n2 >> 8 & 0xFF);
        this.zm.memory_image[n + 3] = (byte)(n2 & 0xFF);
        return 0;
    }

    protected short op_set_text_style() {
        this.zm.current_window.set_text_style(this.operands[0] & 0xFFFF);
        return 0;
    }

    protected short op_buffer_mode() {
        this.zm.window[0].setwrapmode(this.operands[0] != 0);
        return 0;
    }

    protected short op_read_char() {
        this.zm.current_window.flush();
        this.zm.current_window.reset_line_count();
        short s = (short)(this.zm.get_input_byte(false) & 0xFF);
        return s;
    }

    protected short op_scan_table() {
        int n = 2;
        int n2 = this.operands[1] & 0xFFFF;
        int n3 = this.operands[2] & 0xFFFF;
        boolean bl = true;
        if (this.count == 4) {
            n = this.operands[3] & 0x7F;
            boolean bl2 = bl = (this.operands[3] & 0x80) == 128;
        }
        if (bl) {
            int n4 = n2 + (n3 << 1);
            while (n2 < n4) {
                if ((this.zm.memory_image[n2] & 0xFF) == (this.operands[0] >> 8 & 0xFF) && (this.zm.memory_image[n2 + 1] & 0xFF) == (this.operands[0] & 0xFF)) {
                    return (short)n2;
                }
                n2 += n;
            }
        } else {
            int n5 = n2 + n3;
            while (n2 < n5) {
                if ((this.zm.memory_image[n2] & 0xFF) == (this.operands[0] & 0xFFFF)) {
                    return (short)n2;
                }
                n2 += n;
            }
        }
        return 0;
    }

    protected short op_call_vn() {
        this.z_call();
        return 0;
    }

    protected short op_call_vn2() {
        this.z_call();
        return 0;
    }

    protected short op_tokenise() {
        boolean bl;
        short s = this.count < 3 ? (short)0 : this.operands[2];
        boolean bl2 = bl = this.count < 3 || this.operands[3] == 0;
        if (s != 0) {
            System.err.println("tokenise opcode encountered (userdict)");
        }
        int n = this.operands[0] & 0xFFFF;
        byte by = this.zm.memory_image[n + 1];
        ((ZDictionary5)this.zm.zd).tokenise(n + 2, by, this.operands[1] & 0xFFFF, bl);
        return 0;
    }

    protected short op_encode_text() {
        int n = this.operands[0] & 65535 + this.operands[2];
        int n2 = this.operands[3] & 0xFFFF;
        short[] sArray = this.zm.encode_word(n, this.operands[1], 6);
        int n3 = 0;
        while (n3 < 3) {
            this.zm.memory_image[n2 + n3 + n3] = (byte)(sArray[n3] >> 8 & 0xFF);
            this.zm.memory_image[n2 + n3 + n3 + 1] = (byte)(sArray[n3] & 0xFF);
            ++n3;
        }
        return 0;
    }

    protected short op_copy_table() {
        int n = this.operands[0] & 0xFFFF;
        int n2 = this.operands[1] & 0xFFFF;
        int n3 = this.operands[2];
        if (n2 == 0) {
            if (n3 < 0) {
                n3 = -n3;
            }
            int n4 = n + n3 - 1;
            while (n4 >= n) {
                this.zm.memory_image[n4] = 0;
                --n4;
            }
        } else if (n3 > 0) {
            System.arraycopy(this.zm.memory_image, n, this.zm.memory_image, n2, n3);
        } else {
            n3 = -n3;
            int n5 = 0;
            while (n5 < n3) {
                this.zm.memory_image[n2 + n5] = this.zm.memory_image[n + n5];
                ++n5;
            }
        }
        return 0;
    }

    protected short op_print_table() {
        int n = this.operands[0] & 0xFFFF;
        int n2 = this.operands[1] & 0xFFFF;
        int n3 = 1;
        int n4 = 0;
        if (this.count > 2) {
            n3 = this.operands[2] & 0xFFFF;
        }
        if (this.count > 3) {
            n4 = this.operands[3] & 0xFFFF;
        }
        this.zm.current_window.flush();
        int n5 = this.zm.current_window.getx();
        int n6 = this.zm.current_window.gety();
        int n7 = 0;
        while (n7 < n3) {
            this.zm.current_window.movecursor(n5, n6 + n7);
            int n8 = 0;
            while (n8 < n2) {
                this.zm.print_ascii_char(this.zm.memory_image[n++]);
                ++n8;
            }
            n += n4;
            ++n7;
        }
        return 0;
    }

    protected short op_check_arg_count() {
        if ((this.operands[0] & 0xFFFF) - 1 < ((ZMachine5)this.zm).argcount) {
            return 1;
        }
        return 0;
    }

    protected short op_restore() {
        ZState zState = new ZState(this.zm);
        if (zState.restore_from_disk(this.zm.screen.getFrame())) {
            this.zm.restore(zState);
            this.storevar = this.zm.get_code_byte();
            return 2;
        }
        return 0;
    }

    protected short op_log_shift() {
        if (this.operands[1] >= 0) {
            return (short)((this.operands[0] & 0xFFFF) << this.operands[1]);
        }
        return (short)((this.operands[0] & 0xFFFF) >> -this.operands[1]);
    }

    protected short op_art_shift() {
        if (this.operands[1] >= 0) {
            return (short)(this.operands[0] << this.operands[1]);
        }
        return (short)(this.operands[0] << -this.operands[1]);
    }

    protected short op_set_font() {
        return 0;
    }

    protected short op_save_undo() {
        this.zm.zstack.push(new Integer(this.storevar));
        short s = (short)((ZMachine5)this.zm).save_undo();
        if (s == 0) {
            this.zm.zstack.pop();
        }
        return s;
    }

    protected short op_restore_undo() {
        short s = (short)((ZMachine5)this.zm).restore_undo();
        if (s != 0) {
            this.storevar = (short)((Integer)this.zm.zstack.pop()).intValue();
        }
        return s;
    }

    protected void setupbs() {
        ZInstruction5.branch5[1] = true;
        ZInstruction5.branch5[2] = true;
        ZInstruction5.branch5[3] = true;
        ZInstruction5.branch5[4] = true;
        ZInstruction5.branch5[5] = true;
        ZInstruction5.branch5[6] = true;
        ZInstruction5.branch5[7] = true;
        ZInstruction5.store5[8] = true;
        ZInstruction5.store5[9] = true;
        ZInstruction5.branch5[10] = true;
        ZInstruction5.store5[15] = true;
        ZInstruction5.store5[16] = true;
        ZInstruction5.store5[17] = true;
        ZInstruction5.store5[18] = true;
        ZInstruction5.store5[19] = true;
        ZInstruction5.store5[20] = true;
        ZInstruction5.store5[21] = true;
        ZInstruction5.store5[22] = true;
        ZInstruction5.store5[23] = true;
        ZInstruction5.store5[24] = true;
        ZInstruction5.store5[25] = true;
        ZInstruction5.branch5[128] = true;
        ZInstruction5.branch5[129] = true;
        ZInstruction5.store5[129] = true;
        ZInstruction5.branch5[130] = true;
        ZInstruction5.store5[130] = true;
        ZInstruction5.store5[131] = true;
        ZInstruction5.store5[132] = true;
        ZInstruction5.store5[136] = true;
        ZInstruction5.store5[142] = true;
        ZInstruction5.store5[185] = true;
        ZInstruction5.branch5[189] = true;
        ZInstruction5.branch5[191] = true;
        ZInstruction5.store5[224] = true;
        ZInstruction5.store5[228] = true;
        ZInstruction5.store5[231] = true;
        ZInstruction5.store5[236] = true;
        ZInstruction5.store5[246] = true;
        ZInstruction5.store5[247] = true;
        ZInstruction5.branch5[247] = true;
        ZInstruction5.store5[248] = true;
        ZInstruction5.branch5[255] = true;
        ZInstruction5.store5[256] = true;
        ZInstruction5.store5[257] = true;
        ZInstruction5.store5[258] = true;
        ZInstruction5.store5[259] = true;
        ZInstruction5.store5[260] = true;
        ZInstruction5.store5[265] = true;
        ZInstruction5.store5[266] = true;
    }
}

