	.xlist
; I/F Types
SPC	equ	0	; Use Generic SCSI Handler
FM	equ	1	; Use FM-R/TOWNS SCSI BIOS
PC9801	equ	2	; Use PC9801-55L SCSI BIOS
ASPI	equ	3	; Use ASPI

; For MASM 5.1 or 6.0 or Other Assembler
  ifdef @Version
    if @Version ge 600
	OPTION M510
     endif
   endif

pushall	macro
    if @Cpu and 00000010y
	pusha
    else
	push	ax
	push	cx
	push	dx
	push	bx
	push	bx
	push	sp
	push	bp
	push	si
	push	di
    endif
	endm
;
popall	macro
    if @Cpu and 00000010y
	popa
    else
	pop	di
	pop	si
	pop	bp
	pop	sp
	pop	bx
	pop	dx
	pop	cx
	pop	ax
    endif
	endm

;
tfrp	macro	dir,byte
    if  IF_TYPE eq PC9801
	mov	bx,dir
   endif
    if  IF_TYPE eq ASPI
	mov	bx,(dir and 00ffh)
   endif
	mov	cx,byte
	endm

; Request Header Definitions
ReqHead	struc
CmdLen	db	?	; Request Header Byte
Unit	db	?	; Unit Number
Cmd	db	?	; Request Command
Stat	dw	?	; Execute Status
	db	8 dup(?)
ReqHead	ends

; Read & Seek Request
ReqRead	struc
	db	13 dup(?) ; Request Header
AdrMode	db	?	 ; Addressing Mode (00H = HSG, 01H = MSF)
BufAdr	dw	2 dup(?) ; Buffer Address
TfrCnt	dw	?	 ; Transfer Sector Count
BlkAdr	dw	2 dup(?) ; Block Address ________________________
RedMode	db	?	 ; Raw/Cooked Mode                       | Use Only Read
IlvSize	db	?	 ; Interleave Size (Not use this driver)
IlvSkip	db	?	 ; Interleave Skip (Not use this driver)
ReqRead	ends

; IOCTL Request
ReqIOCTL struc
	db	13 dup(?) ; Request Header
MedTyp	db	?	; Media type (Not use)
IOCParm	dd	?	; IOCTL Parameter Address
IOCCnt	dw	?	; IOCTL Count
IOCStrt	dw	?	; IOCTL Start
IOCVid	dd	?	; Volume ID
ReqIOCTL ends
	.list
