/* accton.c */

/* Copyright (C) 1993 Free Software Foundation, Inc.

This file contains the code for GNU accton.

The GNU Accounting Utilities are free software; you can redistribute
them and/or modify them under the terms of the GNU General Public
License as published by the Free Software Foundation; either version
2, or (at your option) any later version.

The GNU Accounting Utilities are distributed in the hope that they will
be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with the GNU Accounting Utilities; see the file COPYING.  If
not, write to the Free Software Foundation, 675 Mass Ave, Cambridge,
MA 02139, USA.  */

#include "config.h"

#include <stdio.h>
#include <sys/types.h>
#include <errno.h>		/* edd */
#include <unistd.h>		/* edd */

#include "common.h"

void
main (int argc, char *argv[])
{
  char *acct_file = NULL;

  if (argc > 2)
    {
      fprintf (stderr, "Usage: %s [ file ]\n", *argv);
      exit (1);
    }
  
  argv++;

  if (argc == 2)
    acct_file = *argv;

  if (acct (acct_file) == -1)
    {
      int err = errno;
      perror ("accton");
      exit (err);
    }
  exit(0);
}

