# NOTE: Derived from .././blib/lib/Tk/Menu.pm.  Changes made here will be lost.
package Tk::Menu;

sub ClassInit
{
 my ($class,$mw) = @_;
 # Must set focus when mouse enters a menu, in order to allow
 # mixed-mode processing using both the mouse and the keyboard.
 $mw->bind($class,"<Enter>", 'Enter');
 $mw->bind($class,"<Leave>", ['Leave',Ev(X),Ev(Y),Ev('s')]);
 $mw->bind($class,"<Motion>", ['Motion',Ev('y'),Ev('s')]);
 $mw->bind($class,"<ButtonPress>",'ButtonDown');
 $mw->bind($class,"<ButtonRelease>",'Invoke');
 $mw->bind($class,"<space>",'Invoke');
 $mw->bind($class,"<Return>",'Invoke');
 $mw->bind($class,"<Escape>",'Escape');
 $mw->bind($class,"<Left>",['LeftRight',"left"]);
 $mw->bind($class,"<Right>",['LeftRight',"right"]);
 $mw->bind($class,"<Up>",['NextEntry',-1]);
 $mw->bind($class,"<Down>",['NextEntry',1]);
 $mw->bind($class,"<KeyPress>", ['TraverseWithinMenu',Ev(A)]);
 return $class;
}

# Unpost --
# This procedure unposts a given menu, plus all of its ancestors up
# to (and including) a menubutton, if any. It also restores various
# values to what they were before the menu was posted, and releases
# a grab if there's a menubutton involved. Special notes:
# 1. It's important to unpost all menus before releasing the grab, so
# that any Enter-Leave events (e.g. from menu back to main
# application) have mode NotifyGrab.
# 2. Be sure to enclose various groups of commands in "catch" so that
# the procedure will complete even if the menubutton or the menu
# or the grab window has been deleted.
#
# Arguments:
# menu - Name of a menu to unpost. Ignored if there
# is a posted menubutton.
1;
