# NOTE: Derived from .././blib/lib/Tk/Menu.pm.  Changes made here will be lost.
package Tk::Menu;

sub Unpost
{
 my $menu = shift;
 my $mb = $Tk::postedMb;

 # Restore focus right away (otherwise X will take focus away when
 # the menu is unmapped and under some window managers (e.g. olvwm)
 # we'll lose the focus completely).

 eval { $Tk::focus->focus() } if (defined $Tk::focus);
 undef $Tk::focus;

 # Unpost menu(s) and restore some stuff that's dependent on
 # what was posted.
 eval
  {
   if (defined $mb)
     {
      $menu = $mb->cget("-menu");
      $menu->unpost();
      $Tk::postedMb = undef;
      $mb->configure("-cursor",$Tk::cursor);
      $mb->configure("-relief",$Tk::relief)
     }
    elsif (defined $Tk::popup)
     {
      $Tk::popup->unpost();
      undef $Tk::popup;
     }
    elsif (defined $menu && ref $menu && $menu->overrideredirect)
     {
      # We're in a cascaded sub-menu from a torn-off menu or popup.
      # Unpost all the menus up to the toplevel one (but not
      # including the top-level torn-off one) and deactivate the
      # top-level torn off menu if there is one.
      while (1)
       {
        $parent = $menu->parent;
        last if (!$parent->IsMenu || !$parent->ismapped);
        $parent->postcascade("none");
        last if (!$parent->overrideredirect);
        $menu = $parent
       }
      $menu->unpost()
     }
  };
 warn "$@" if ($@);
 # Release grab, if any.
 if (defined $menu && ref $menu)
  {
   my $grab = $menu->grabCurrent;
   $grab->grabRelease if (defined $grab);
  }
}

1;
