# NOTE: Derived from .././blib/lib/Tk/Text.pm.  Changes made here will be lost.
package Tk::Text;

sub ResetAnchor
{
 my $w = shift;
 my $index = shift;
 if (!defined $w->tag("ranges","sel"))
  {
   $w->mark("set","anchor",$index);
   return;
  }
 my $a = $w->index($index);
 my $b = $w->index("sel.first");
 my $c = $w->index("sel.last");
 if ($w->compare($a,"<",$b))
  {
   $w->mark("set","anchor","sel.last");
   return;
  }
 if ($w->compare($a,">",$c))
  {
   $w->mark("set","anchor","sel.first");
   return;
  }
 my ($lineA,$chA) = split(/\./,$a);
 my ($lineB,$chB) = split(/\./,$b);
 my ($lineC,$chC) = split(/\./,$c);
 if ($lineB < $lineC+2)
  {
   $total = length($w->get($b,$c));
   if ($total <= 2)
    {
     return;
    }
   if (length($w->get($b,$a)) < $total/2)
    {
     $w->mark("set","anchor","sel.last")
    }
   else
    {
     $w->mark("set","anchor","sel.first")
    }
   return;
  }
 if ($lineA-$lineB < $lineC-$lineA)
  {
   $w->mark("set","anchor","sel.last")
  }
 else
  {
   $w->mark("set","anchor","sel.first")
  }
}
# Insert --
# Insert a string into a text at the point of the insertion cursor.
# If there is a selection in the text, and it covers the point of the
# insertion cursor, then delete the selection before inserting.
#
# Arguments:
# w - The text window in which to insert the string
# s - The string to insert (usually just a single character)
1;
