// -*- C++ -*-
/* This file is part of
* ======================================================
* 
*           LyX, the High Level Word Processor
* 	 
*	    Copyright (C) 1995 Matthias Ettrich
*
*======================================================*/


#include "forms.h"

#ifndef FD_form_main_h_
#define FD_form_main_h_

/**** Callback routines ****/

extern void WorkAreaCB(FL_OBJECT *, long);
extern void ScrollCB(FL_OBJECT *, long);
extern void ShowFileMenu(FL_OBJECT *, long);
extern void ShowEditMenu(FL_OBJECT *, long);
extern void ShowLayoutMenu(FL_OBJECT *, long);
extern void ShowInsertMenu(FL_OBJECT *, long);
extern void ShowOptionsMenu(FL_OBJECT *, long);
extern void ShowMathMenu(FL_OBJECT *, long);
extern void ShowBufferMenu(FL_OBJECT *, long);
extern void ShowHelpMenu(FL_OBJECT *, long);
extern void CursorToggleCB(FL_OBJECT *, long);
extern void AutosaveTimerCB(FL_OBJECT *, long);
extern void UpdateTimerCB(FL_OBJECT *, long);

extern void TimerCB(FL_OBJECT *, long);

extern void ParagraphOKCB(FL_OBJECT *, long);
extern void ParagraphApplyCB(FL_OBJECT *, long);
extern void ParagraphCancelCB(FL_OBJECT *, long);

extern void CharacterOKCB(FL_OBJECT *, long);
extern void CharacterApplyCB(FL_OBJECT *, long);
extern void CharacterCancelCB(FL_OBJECT *, long);

extern void DocumentOKCB(FL_OBJECT *, long);
extern void DocumentApplyCB(FL_OBJECT *, long);
extern void DocumentCancelCB(FL_OBJECT *, long);
extern void ChoiceClassCB(FL_OBJECT *, long);

extern void QuotesOKCB(FL_OBJECT *, long);
extern void QuotesApplyCB(FL_OBJECT *, long);
extern void QuotesCancelCB(FL_OBJECT *, long);

extern void PreambleApplyCB(FL_OBJECT *, long);
extern void PreambleCancelCB(FL_OBJECT *, long);
extern void PreambleOKCB(FL_OBJECT *, long);

extern void PrintApplyCB(FL_OBJECT *, long);
extern void PrintCancelCB(FL_OBJECT *, long);
extern void PrintOKCB(FL_OBJECT *, long);

extern void FigureOKCB(FL_OBJECT *, long);
extern void FigureApplyCB(FL_OBJECT *, long);
extern void FigureCancelCB(FL_OBJECT *, long);

extern void ScreenOKCB(FL_OBJECT *, long);
extern void ScreenApplyCB(FL_OBJECT *, long);
extern void ScreenCancelCB(FL_OBJECT *, long);

extern void UpCB(FL_OBJECT *, long);
extern void DownCB(FL_OBJECT *, long);

extern void TocSelectCB(FL_OBJECT *, long);
extern void TocCancelCB(FL_OBJECT *, long);
extern void TocUpdateCB(FL_OBJECT *, long);

extern void RefSelectCB(FL_OBJECT *, long);
extern void RefUpdateCB(FL_OBJECT *, long);
extern void RefHideCB(FL_OBJECT *, long);

extern void EmphCB(FL_OBJECT *ob, long data);
extern void NounCB(FL_OBJECT *ob, long data);
extern void TexCB(FL_OBJECT *ob, long data);
extern void FormulaCB(FL_OBJECT *ob, long data);
extern void DepthCB(FL_OBJECT *ob, long data);
extern void FootCB(FL_OBJECT *, long);
extern void MarginCB(FL_OBJECT *, long);
extern void FigureCB(FL_OBJECT *, long);
extern void TableCB(FL_OBJECT *, long);
extern void CutCB(FL_OBJECT *, long);
extern void PasteCB(FL_OBJECT *, long);
extern void MeltCB(FL_OBJECT *, long);
extern void FreeCB(FL_OBJECT *, long);
extern void FontSizeCB(FL_OBJECT *ob, long data);
extern void BoldCB(FL_OBJECT *ob, long data);
extern void UnderlineCB(FL_OBJECT *ob, long data);
extern void CodeCB(FL_OBJECT *ob, long data);
extern void SansCB(FL_OBJECT *ob, long data);
extern void RomanCB(FL_OBJECT *ob, long data);
extern void StyleResetCB(FL_OBJECT *ob, long data);
extern void FontStateShowCB(FL_OBJECT *ob, long data);





/**** Forms and Objects ****/

typedef struct {
	FL_FORM *form_main;
	FL_OBJECT *work_area;
	FL_OBJECT *figinset_canvas;
	FL_OBJECT *scrollbar;
	FL_OBJECT *menubar_grp;
	FL_OBJECT *menu_file;
	FL_OBJECT *menu_edit;
	FL_OBJECT *menu_layout;
	FL_OBJECT *menu_insert;
	FL_OBJECT *menu_math;
        FL_OBJECT *menu_options;
	FL_OBJECT *menu_buffer;
	FL_OBJECT *menu_help;
	FL_OBJECT *toolbar_grp;
	FL_OBJECT *timer_autosave;
	FL_OBJECT *timer_cursor;
	FL_OBJECT *timer_update;
	FL_OBJECT *button_down;
	FL_OBJECT *button_up;
	void *vdata;
	long ldata;
} FD_form_main;

extern FD_form_main * create_form_form_main(void);
typedef struct {
	FL_FORM *form_title;
	FL_OBJECT *timer_title;
	void *vdata;
	long ldata;
} FD_form_title;

extern FD_form_title * create_form_form_title(void);


typedef struct {
	FL_FORM *form_figure;
	FL_OBJECT *group_radio_fugre;
	FL_OBJECT *radio_postscript;
	FL_OBJECT *radio_inline;
	FL_OBJECT *radio_latex;
	void *vdata;
	long ldata;
} FD_form_figure;

extern FD_form_figure * create_form_form_figure(void);
typedef struct {
	FL_FORM *form_screen;
	FL_OBJECT *input_roman;
	FL_OBJECT *input_sans;
	FL_OBJECT *input_typewriter;
	FL_OBJECT *input_font_norm;
	FL_OBJECT *intinput_size;
	FL_OBJECT *intinput_tiny;
	FL_OBJECT *intinput_small;
	FL_OBJECT *intinput_normal;
	FL_OBJECT *intinput_large;
	FL_OBJECT *intinput_larger;
	FL_OBJECT *intinput_largest;
	FL_OBJECT *intinput_huge;
	FL_OBJECT *intinput_giant;
	void *vdata;
	long ldata;
} FD_form_screen;

extern FD_form_screen * create_form_form_screen(void);

typedef struct {
	FL_FORM *form_toc;
	FL_OBJECT *browser_toc;
	void *vdata;
	long ldata;
} FD_form_toc;

extern FD_form_toc * create_form_form_toc(void);


typedef struct {
	FL_FORM *form_ref;
	FL_OBJECT *radio_ref;
	FL_OBJECT *radio_pageref;
	FL_OBJECT *browser_ref;
	void *vdata;
	long ldata;
} FD_form_ref;

extern FD_form_ref * create_form_form_ref(void);

#endif /* FD_form_main_h_ */

