/*
 *  This file is part of
 * ==================================================
 *
 *       LyX, the High Level Word Processor
 *
 *       Copyright (C) 1995, 1996  Matthias Ettrich
 *       and the LyX Team.
 *
 * ==================================================
 */

/* This file contains all the menu and submenu declarations.
   The call backs are in lyx_cb.C */

/*
 * REMEMBER:
 * XFORMS can handle 10 (more with the new xforms, but not unlimited)
 * popups at the same time
 * so when you are finished looking at a pup free it (fl_freepup)
 */

#include "config.h"

#include "forms.h"

#include "lyx.h"
#include "lyx_cb.h"
#include "file.h"
#include "version.h"
#include "buffer.h"
#include "lyxfont.h"
#include "lastfiles.h"
#include "keybind.h"
#include "spellchecker.h"

extern FD_form_screen *fd_form_screen;
extern void ResizeCurrentBufferPseudoExpose();

extern void GotoError();
extern void GotoNote();
extern void OpenStuff();
extern void ToggleFloat();
extern void HyphenationPoint();
extern void HFill();
extern void Newline();
extern void ProtectedBlank();
extern void LoadLyXFile(const char*);
extern char GetCurrentTextClass();

extern int RunLaTeX();
extern int RunLinuxDoc(int, const char *);
extern void MenuWrite(Buffer*);
extern void MenuWriteAs();
extern void MenuRunLaTeX();
extern void MenuPrint();
extern void MenuMakeLaTeX();
extern void MenuMakeLinuxDoc();
extern void MenuOpen();
extern void MenuNew();
extern void MenuQuit();
extern void InsertAsciiFile(char);

extern void CloseBuffer(); 
extern void MenuPreview();
extern void MenuPreviewPS();
extern void MenuLayoutCharacter();
extern void MenuLayoutParagraph();
extern void MenuLayoutDocument();
extern void MenuLayoutQuotes();
extern void MenuLayoutPreamble();
extern void MenuDocu();
extern void ShowCredits();
extern void show_symbols_form(void);
extern void Update(signed char f);
extern void SmallUpdate(signed char f);
extern void MenuInsertLabel();
extern void MenuInsertRef();
extern void InsertLaTeXTable(const char* table);
extern void BeforeChange();

extern void ProhibitInput();
extern void AllowInput();

extern FD_form_main *fd_form_main;


void ShowFileMenu(FL_OBJECT *ob, long)
{

  // to the pseudo-menu-button:
  // ok, ok this is a hack. It would be better to use the menus of the xforms 0.8 library.
  // but then all popups have to be defined all the time, code rewriting would be necessary
  // and contex-depending menues (i.e. the linux-doc-sgml stuff) are a bit more
  // complicated. But of course it would be more proper (and little faster). So if anybody likes
  // to do the cleanup, just do it. Matthias

  // set the pseudo menu-button
  fl_set_object_boxtype(ob, FL_UP_BOX);
  fl_set_button(ob, 0);
  fl_redraw_object(ob);

  // Is textclass LinuxDoc?
  bool LinuxDoc = StringEqual(lyxstyle.NameOfClass(GetCurrentTextClass()),
			      "linuxdoc");
    
   int FileMenu = fl_defpup(FL_ObjWin(ob), 
   "New..."
   "|Open...%l"
   "|Close"
   "|Save"
   "|Save As...%l"
   "|Run LaTeX"    
   "|View (xdvi)"
   "|View (ghostview)"
   "|Print...");

   fl_setpup_shortcut(FileMenu, 1, "Nn#n#N");
   fl_setpup_shortcut(FileMenu, 2, "Oo#o#O");
   fl_setpup_shortcut(FileMenu, 3, "Cc#c#C");
   fl_setpup_shortcut(FileMenu, 4, "Ss#s#S");
   fl_setpup_shortcut(FileMenu, 5, "Aa#a#A");
   fl_setpup_shortcut(FileMenu, 6, "Rr#r#R");
   fl_setpup_shortcut(FileMenu, 7, "xX#x#X");
   fl_setpup_shortcut(FileMenu, 8, "gG#g#G");
   fl_setpup_shortcut(FileMenu, 9, "Pp#p#P");

   // Either "Make LaTeX" or "Make LinuxDoc" according to textclass
   if (!LinuxDoc) {
	fl_addtopup(FileMenu,"|Make (nice) LaTeX File%l");
	fl_setpup_shortcut(FileMenu, 10,"Mm#m#M");
   } else {
	fl_addtopup(FileMenu,"|Make LinuxDoc File%l");
	fl_setpup_shortcut(FileMenu, 10,"Ll#l#L");
   }   
   
   fl_addtopup(FileMenu,"|Quit%l");
   fl_setpup_shortcut(FileMenu, 11,"Qq#q#Q");

   lastfiles->MakeMenu(FileMenu);
   fl_setpup_shortcut(FileMenu, 12,"1#1#1");
   fl_setpup_shortcut(FileMenu, 13,"2#2#2");   
   fl_setpup_shortcut(FileMenu, 14,"3#3#3");
   fl_setpup_shortcut(FileMenu, 15,"4#4#4");

   fl_setpup_position(
		      fd_form_main->form_main->x + ob->x,
		      fd_form_main->form_main->y + ob->y + ob->h + 10);   
   int choice=fl_dopup(FileMenu);
   XFlush(fl_display);

   // set the pseudo menu-button back
   fl_set_object_boxtype(ob, FL_FLAT_BOX);
   fl_redraw_object(ob);

   switch (choice) {
   case 1: MenuNew(); break;
   case 2: MenuOpen(); break;
   case 3: CloseBuffer(); break;
   case 4: MenuWrite(bufferlist.current()); break;
   case 5: MenuWriteAs(); break;
   case 6: MenuRunLaTeX(); break;
   case 7: MenuPreview(); break;
   case 8: MenuPreviewPS(); break;
   case 9: MenuPrint(); break;
   case 10: if (!LinuxDoc)
   		MenuMakeLaTeX();
   	    else
  		MenuMakeLinuxDoc(); 
  	    break;
   case 11: MenuQuit(); break;
   // Lastfiles:
   case 12:
   case 13:
   case 14:
   case 15: LoadLyXFile(lastfiles->GetFileName(choice-11));
            ResizeCurrentBufferPseudoExpose(); 
            break;
   }

   fl_freepup(FileMenu);
   AllowInput();
}


extern void MenuLoadAutoSave();
extern void AutoSave();
extern void MenuUndo();
extern void MenuRedo();
extern void MenuSearch();
extern void MenuKeymap();
extern void MenuShowTableOfContents();
extern void MenuPasteSelection(char at);
extern void AllFloats(char flag, char figmar);

void ShowEditMenu(FL_OBJECT *ob, long data)
{
   
  // set the pseudo menu-button
  if (!data){
    fl_set_object_boxtype(ob, FL_UP_BOX);
    fl_set_button(ob, 0);
    fl_redraw_object(ob);
  }

   // Floats submenu
   int SubEditFloats=fl_defpup(FL_ObjWin(ob),
   "Floats%t"
   "|Open/Close%x21"
   "|Melt%x22"
   "|Open All Footnotes/Margin Notes%x23"
   "|Close All Footnotes/Margin Notes%x24"
   "|Open All Figures/Tables%x25"
   "|Close All Figures/Tables%x26"
			       );
   fl_setpup_shortcut(SubEditFloats, 21, "Oo#o#O");
   fl_setpup_shortcut(SubEditFloats, 22, "Mm#m#M");
   fl_setpup_shortcut(SubEditFloats, 23, "Aa#a#A");
   fl_setpup_shortcut(SubEditFloats, 24, "Cc#c#C");
   fl_setpup_shortcut(SubEditFloats, 25, "Ff#f#F");
   fl_setpup_shortcut(SubEditFloats, 26, "Tt#t#T");

   // Table submenu
   int SubEditTable = fl_newpup(FL_ObjWin(ob));
   if (bufferlist.current()->text && 
       bufferlist.current()->text->cursor.par->table){

     fl_addtopup(SubEditTable, "Table%t");

     if (bufferlist.current()->text->cursor.par->table->
	 IsMultiColumn(bufferlist.current()->text->
		       NumberOfCell(bufferlist.current()->text->cursor.par, 
				    bufferlist.current()->text->cursor.pos)))
       fl_addtopup(SubEditTable, "|Multicolumn%B%x44%l");
     else
       fl_addtopup(SubEditTable, "|Multicolumn%b%x44%l");
     fl_setpup_shortcut(SubEditTable, 44, "Mm#m#M");
     
     if (bufferlist.current()->text->cursor.par->table->
	 TopLine(bufferlist.current()->text->
		 NumberOfCell(bufferlist.current()->text->cursor.par, 
			      bufferlist.current()->text->cursor.pos)))
       fl_addtopup(SubEditTable, "|Line Top%B%x36");
     else
       fl_addtopup(SubEditTable, "|Line Top%b%x36");
     fl_setpup_shortcut(SubEditTable, 36, "Tt#t#T");
     
     if (bufferlist.current()->text->cursor.par->table->
	 BottomLine(bufferlist.current()->text->
		 NumberOfCell(bufferlist.current()->text->cursor.par, 
			      bufferlist.current()->text->cursor.pos)))
       fl_addtopup(SubEditTable, "|Line Bottom%B%x37");
     else
       fl_addtopup(SubEditTable, "|Line Bottom%b%x37");
     fl_setpup_shortcut(SubEditTable, 37, "Bb#b#B");

     if (bufferlist.current()->text->cursor.par->table->
	 LeftLine(bufferlist.current()->text->
		 NumberOfCell(bufferlist.current()->text->cursor.par, 
			      bufferlist.current()->text->cursor.pos)))
       fl_addtopup(SubEditTable, "|Line Left%B%x38");
     else
       fl_addtopup(SubEditTable, "|Line Left%b%x38");
     fl_setpup_shortcut(SubEditTable, 38, "Ll#l#L");

     if (bufferlist.current()->text->cursor.par->table->
	 RightLine(bufferlist.current()->text->
		 NumberOfCell(bufferlist.current()->text->cursor.par, 
			      bufferlist.current()->text->cursor.pos)))
       fl_addtopup(SubEditTable, "|Line Right%B%x39%l");
     else
       fl_addtopup(SubEditTable, "|Line Right%b%x39%l");
     fl_setpup_shortcut(SubEditTable, 39, "Rr#r#R");

     int align = bufferlist.current()->text->cursor.par->table->
       GetAlignment(bufferlist.current()->text->
		    NumberOfCell(bufferlist.current()->text->cursor.par, 
				 bufferlist.current()->text->cursor.pos));
     if (align == LYX_ALIGN_LEFT)
       fl_addtopup(SubEditTable, "|Align Left%R%x40");
     else
       fl_addtopup(SubEditTable, "|Align Left%r%x40");
     fl_setpup_shortcut(SubEditTable, 40, "Aa#a#A");

     if (align == LYX_ALIGN_RIGHT)
       fl_addtopup(SubEditTable, "|Align Right%R%x41");
     else
       fl_addtopup(SubEditTable, "|Align Right%r%x41");
     fl_setpup_shortcut(SubEditTable, 41, "tT#t#T");

     if (align == LYX_ALIGN_CENTER)
       fl_addtopup(SubEditTable, "|Align Center%R%x42%l");
     else
       fl_addtopup(SubEditTable, "|Align Center%r%x42%l");
     fl_setpup_shortcut(SubEditTable, 42, "Cc#c#C");

     fl_addtopup(SubEditTable, "|Append Row%x32");
     fl_setpup_shortcut(SubEditTable, 32, "wW#w#W");
     fl_addtopup(SubEditTable, "|Append Column%x33%l");
     fl_setpup_shortcut(SubEditTable, 33, "nN#n#N");
     fl_addtopup(SubEditTable, "|Delete Row%x34");
     fl_setpup_shortcut(SubEditTable, 34, "oO#o#O");
     fl_addtopup(SubEditTable, "|Delete Column%x35%l");
     fl_setpup_shortcut(SubEditTable, 35, "uU#u#U");
     fl_addtopup(SubEditTable, "|Delete Table%x43");
     fl_setpup_shortcut(SubEditTable, 43, "Dd#d#D");
   }
   else {
     fl_addtopup(SubEditTable, "Table%t");
     fl_addtopup(SubEditTable, "|Insert table%x31");
     fl_setpup_shortcut(SubEditTable, 31, "Ii#i#I");
   }

   int EditMenu=fl_defpup(FL_ObjWin(ob),
   "Undo"
   "|Redo %l"
   "|Cut"
   "|Copy"
   "|Paste%l"
   "|Find & Replace..."
   "|Go to Error"
   "|Go to Note"
   "|Floats%m"
   "|Table%m"
   "|Spellchecker...."
   "|Table of Contents...%l"
   "|Paste Primary Selection as Lines"
   "|Paste Primary Selection as Paragraphs",
   SubEditFloats, SubEditTable);

   fl_setpup_shortcut(EditMenu, 1, "Uu#u#U");
   fl_setpup_shortcut(EditMenu, 2, "Rr#r#R");
   fl_setpup_shortcut(EditMenu, 3, "Cc#c#C");
   fl_setpup_shortcut(EditMenu, 4, "oO#o#O");
   fl_setpup_shortcut(EditMenu, 5, "Pp#p#P");
   fl_setpup_shortcut(EditMenu, 6, "Ff#f#F");
   fl_setpup_shortcut(EditMenu, 7, "Ee#e#E");
   fl_setpup_shortcut(EditMenu, 8, "Nn#n#N");
   fl_setpup_shortcut(EditMenu, 9, "aA#a#A");
   fl_setpup_shortcut(EditMenu, 10, "bB#b#B");
   fl_setpup_shortcut(EditMenu, 11, "Ss#s#S");
   fl_setpup_shortcut(EditMenu, 12, "Tt#t#T");
   fl_setpup_shortcut(EditMenu, 13, "Ll#l#L");
   fl_setpup_shortcut(EditMenu, 14, "gG#g#G");
      
   int choice;
   
   if (data == 99)  { // sorry a hack (Matthias)
     choice = fl_dopup(SubEditTable);
   }
   else if (data == 98) {
     choice = fl_dopup(SubEditFloats);
   }
   else {
     fl_setpup_position(fd_form_main->form_main->x + ob->x,
			fd_form_main->form_main->y + ob->y + ob->h + 10);   
     choice = fl_dopup(EditMenu);
   }
   XFlush(fl_display);
   
   // set the pseudo menu-button back
   if (!data){
     fl_set_object_boxtype(ob, FL_FLAT_BOX);
     fl_redraw_object(ob);
   }

   switch (choice) {
   case 1: MenuUndo(); break; 
   case 2: MenuRedo(); break;
   case 3: CutCB(); break;
   case 4: CopyCB(); break;
   case 5: PasteCB(); break;
   case 6: MenuSearch(); break;
   case 7: GotoError(); break;
   case 8: GotoNote(); break;
   case 9: // floats
      break;
   case 10:// table 
     break;
   case 11: ShowSpellChecker(); break;
   case 12: MenuShowTableOfContents(); break;
   case 13: MenuPasteSelection(0); break;
   case 14: MenuPasteSelection(1); break;

      // floats sub-menu
   case 21: ToggleFloat(); break;
   case 22: MeltCB(ob, data); break;
   case 23: AllFloats(1, 0); break;
   case 24: AllFloats(0, 0); break;
   case 25: AllFloats(1, 1); break;
   case 26: AllFloats(0, 1); break;

   case 31: TableCB(ob, data); break;
     // this is really temporary. We need new function in keybind.C
     // These should set the minibuffer, too.
   case 32: case 33: case 34:
   case 35: case 36: case 37:
   case 38: case 39: case 40: 
   case 41: case 42: case 43:
   case 44: 
     
     if (bufferlist.current()->text){
       bufferlist.current()->screen->HideCursor();
       if (!bufferlist.current()->text->selection){
	 BeforeChange(); 
	 Update(-2);
       }
       bufferlist.current()->text->TableFeatures( choice - 32);
       Update(1);
     }
     break;
   }
   
   fl_freepup(EditMenu);
   fl_freepup(SubEditFloats);
   fl_freepup(SubEditTable);
}


void ShowLayoutMenu(FL_OBJECT *ob, long data)
{
  // set the pseudo menu-button
  fl_set_object_boxtype(ob, FL_UP_BOX);
  fl_set_button(ob, 0);
  fl_redraw_object(ob);
   
   int LayoutMenu = fl_newpup(FL_ObjWin(ob));
   fl_addtopup(LayoutMenu, "Character...");
   fl_setpup_shortcut(LayoutMenu, 1, "Cc#c#C");
   fl_addtopup(LayoutMenu,    "|Paragraph...");
   fl_setpup_shortcut(LayoutMenu, 2, "Pp#p#P");
   fl_addtopup(LayoutMenu,    "|Document...");
   fl_setpup_shortcut(LayoutMenu, 3, "Dd#d#D");
   fl_addtopup(LayoutMenu,    "|Quotes...%l");
   fl_setpup_shortcut(LayoutMenu, 4, "Qq#q#Q");
   if (bufferlist.current()->text && 
       bufferlist.current()->text->real_current_font.shape == LYX_ITALIC_SHAPE)
     fl_addtopup(LayoutMenu,    "|Emphasize Style%B");
   else
     fl_addtopup(LayoutMenu,    "|Emphasize Style%b");
   fl_setpup_shortcut(LayoutMenu, 5, "Ee#e#E");
   if (bufferlist.current()->text && 
       bufferlist.current()->text->real_current_font.shape == LYX_SMALLCAPS_SHAPE)
     fl_addtopup(LayoutMenu,    "|Noun Style%B");
   else
     fl_addtopup(LayoutMenu,    "|Noun Style%b");
   fl_setpup_shortcut(LayoutMenu, 6, "Nn#n#N");
   if (bufferlist.current()->text && 
       bufferlist.current()->text->real_current_font.series == LYX_BOLD_SERIES)
     fl_addtopup(LayoutMenu,    "|Bold Style%B");
   else
     fl_addtopup(LayoutMenu,    "|Bold Style%b");
   fl_setpup_shortcut(LayoutMenu, 7, "Bb#b#B");
   if (bufferlist.current()->text && 
       bufferlist.current()->text->real_current_font.latex == LYX_LATEX)
     fl_addtopup(LayoutMenu,    "|TeX Style%B");
   else
     fl_addtopup(LayoutMenu,    "|TeX Style%b");
   fl_setpup_shortcut(LayoutMenu, 8, "Tt#t#T");
   fl_addtopup(LayoutMenu,    "|Change Environment Depth");
   fl_setpup_shortcut(LayoutMenu, 9, "vV#v#V");
   fl_addtopup(LayoutMenu,    "|LaTeX Preamble...");
   fl_setpup_shortcut(LayoutMenu, 10, "Ll#l#L");
   
   fl_setpup_position(
		      fd_form_main->form_main->x + ob->x,
		      fd_form_main->form_main->y + ob->y + ob->h + 10);
   int choice = fl_dopup(LayoutMenu);
   XFlush(fl_display);

   // set the pseudo menu-button back
   fl_set_object_boxtype(ob, FL_FLAT_BOX);
   fl_redraw_object(ob);

   switch (choice) {
   case 1: MenuLayoutCharacter(); break;
   case 2: MenuLayoutParagraph(); break;
   case 3: MenuLayoutDocument(); break;
   case 4: MenuLayoutQuotes(); break;
   case 5: EmphCB(ob, data); break;
   case 6: NounCB(ob, data); break;
   case 7: BoldCB(ob, data); break;
   case 8: TexCB(ob, data); break;
   case 9: DepthCB(NULL, 1); break;
   case 10: MenuLayoutPreamble(); break;
   }
   fl_freepup(LayoutMenu); 
}


void ShowInsertMenu(FL_OBJECT *ob, long data)
{
  // set the pseudo menu-button
  fl_set_object_boxtype(ob, FL_UP_BOX);
  fl_set_button(ob, 0);
  fl_redraw_object(ob);
 
   int InsertMenu;
   // Is textclass LinuxDoc?
   bool LinuxDoc = StringEqual(lyxstyle.NameOfClass(GetCurrentTextClass()),
                              "linuxdoc");

   int SubInsertAscii = fl_defpup(FL_ObjWin(ob),
   "Import ASCII file%t"
   "|As Lines%x41"
   "|As Paragraphs%x42");
   fl_setpup_shortcut(SubInsertAscii, 41, "Ll#l#L");
   fl_setpup_shortcut(SubInsertAscii, 42, "Pp#p#P");

   int SubInsertTableList=fl_defpup(FL_ObjWin(ob),
   "Lists & TOC%t"
   "|Table of Contents %x21"
   "|List of Figures %x22"
   "|List of Tables %x23");
   fl_setpup_shortcut(SubInsertTableList, 21, "Cc#c#C");
   fl_setpup_shortcut(SubInsertTableList, 22, "Ff#f#F");
   fl_setpup_shortcut(SubInsertTableList, 23, "Tt#t#T");

   int SubInsertSpecial=fl_defpup(FL_ObjWin(ob),
   "Special Character%t"
   "|HFill%x31"
   "|Hyphenation Point%x32"
   "|Protected Blank%x33"
   "|Linebreak%x34");
   fl_setpup_shortcut(SubInsertSpecial, 31, "Hh#h#H");
   fl_setpup_shortcut(SubInsertSpecial, 32, "Pp#p#P");
   fl_setpup_shortcut(SubInsertSpecial, 33, "Bb#b#B");
   fl_setpup_shortcut(SubInsertSpecial, 34, "Ll#l#L");

   InsertMenu = fl_defpup(FL_ObjWin(ob),
   "Figure..."
   "|Table..."
   "|Import ASCII File%m%l"
   "|Footnote"
   "|Margin Note"
   "|Figure Float"
   "|Table Float%l"
   "|Lists & TOC%m%l"
   "|Special Character%m%l"
   "|Note"
   "|Label..."
   "|Cross-Reference...",
   SubInsertAscii, SubInsertTableList, SubInsertSpecial);

   fl_setpup_shortcut(InsertMenu, 1, "gG#g#G");
   fl_setpup_shortcut(InsertMenu, 2, "bB#b#B");
   fl_setpup_shortcut(InsertMenu, 3, "Aa#a#A");
   fl_setpup_shortcut(InsertMenu, 4, "Ff#f#F");
   fl_setpup_shortcut(InsertMenu, 5, "Mm#m#M");
   fl_setpup_shortcut(InsertMenu, 6, "rR#r#R");
   fl_setpup_shortcut(InsertMenu, 7, "eE#e#E");
   fl_setpup_shortcut(InsertMenu, 8, "Tt#t#T");
   fl_setpup_shortcut(InsertMenu, 9, "Ss#s#S");
   fl_setpup_shortcut(InsertMenu, 10, "Nn#n#N");
   fl_setpup_shortcut(InsertMenu, 11, "Ll#l#L");
   fl_setpup_shortcut(InsertMenu, 12, "Cc#c#C");

   if (LinuxDoc) {
      /* for linuxdoc sgml */ 
      fl_addtopup(InsertMenu, "|URL");
      fl_setpup_shortcut(InsertMenu, 13, "Uu#u#U");
      fl_addtopup(InsertMenu, "|HTML URL");
      fl_setpup_shortcut(InsertMenu, 14, "Hh#h#H"); 
   }      

   fl_setpup_position(
		      fd_form_main->form_main->x + ob->x,
		      fd_form_main->form_main->y + ob->y + ob->h + 10);
   
   int choice = fl_dopup(InsertMenu);
   XFlush(fl_display);

   // set the pseudo menu-button back
   fl_set_object_boxtype(ob, FL_FLAT_BOX);
   fl_redraw_object(ob);

   if (bufferlist.current()->text){
      bufferlist.current()->screen->HideCursor();
      switch (choice) {
      case 1: FigureCB(ob, data); break;
      case 2: TableCB(ob, data); break;
      case 3: // Insert ASCII file submenu
        break;
      case 41: InsertAsciiFile(0); break;
      case 42: InsertAsciiFile(1); break;
      case 43: 
        break;
      case 4: FootCB(ob, data); break;
      case 5: MarginCB(ob, data); break;
      case 6:
	Update(-2);
	bufferlist.current()->text->InsertFootnoteEnvironment(LYX_FIG);
	Update(1);
	break;
      case 7:
	Update(-2);
	bufferlist.current()->text->InsertFootnoteEnvironment(LYX_TAB);
	Update(1);
	break;
      case 8: // Table/List submenu
	 break;
      case 21: InsertLaTeXTable("\\tableofcontents"); break;
      case 22: InsertLaTeXTable("\\listoffigures"); break;
      case 23: InsertLaTeXTable("\\listoftables"); break;
      case 9: // Special Character submenu
	 break;
      case 31: HFill(); break;
      case 32: HyphenationPoint(); break; 
      case 33: ProtectedBlank(); break; 
      case 34: Newline(); break; 

      case 10: NoteCB(); break;
      case 11: DispatchFunction(LFUN_INSERT_LABEL, NULL); break;
      case 12: MenuInsertRef(); break;
      case 13: UrlCB(); break;
      case 14: HtmlUrlCB(); break;
      }
   }
   fl_freepup(InsertMenu);
   fl_freepup(SubInsertAscii);
   fl_freepup(SubInsertTableList);
   fl_freepup(SubInsertSpecial);
}


void ShowMathMenu(FL_OBJECT *ob, long)
{
  extern void math_insert_symbol(const char* s);
   
  // set the pseudo menu-button
  fl_set_object_boxtype(ob, FL_UP_BOX);
  fl_set_button(ob, 0);
  fl_redraw_object(ob);

   int MathMenu = fl_defpup(FL_ObjWin(ob), 
   "Fraction"
   "|Square root"
   "|Exponent"
   "|Index"
   "|Sum"
   "|Integral%l"
   "|Math mode"
   "|Display%l"
   "|Math Panel...");

   fl_setpup_shortcut(MathMenu, 1, "Ff#f#F");
   fl_setpup_shortcut(MathMenu, 2, "Ss#s#S");
   fl_setpup_shortcut(MathMenu, 3, "Ee#e#E");
   fl_setpup_shortcut(MathMenu, 4, "Ii#i#I");
   fl_setpup_shortcut(MathMenu, 5, "uU#u#U");
   fl_setpup_shortcut(MathMenu, 6, "nN#n#N");
   fl_setpup_shortcut(MathMenu, 7, "Mm#m#M");
   fl_setpup_shortcut(MathMenu, 8, "Dd#d#D");
   fl_setpup_shortcut(MathMenu, 9, "Pp#p#P");

   fl_setpup_position(
		      fd_form_main->form_main->x + ob->x,
		      fd_form_main->form_main->y + ob->y + ob->h + 10);   
   int choice = fl_dopup(MathMenu);  
   XFlush(fl_display);

   // set the pseudo menu-button back
   fl_set_object_boxtype(ob, FL_FLAT_BOX);
   fl_redraw_object(ob);

   InsetFormulaLatex *new_inset = NULL;
   if (bufferlist.current()->text)  {
      switch (choice) {
      case 1: /* frac */
	 math_insert_symbol("frac");
	 break;
      case 2: /* sqrt */
	 math_insert_symbol("sqrt");
	 break;
      case 3: /* Exponent  */ 
	 math_insert_symbol("^");
	 break;
      case 4: /* Index  */
	 math_insert_symbol("_");
	 break;
      case 5: /* sum */ 
	 math_insert_symbol("sum");
	 break;
      case 6: /* int */
	 math_insert_symbol("int");
	 break;
       case 7:
	 DispatchFunction(LFUN_MATH_MODE, NULL, NULL);
	 break;
       case 8:
	 DispatchFunction(LFUN_MATH_DISPLAY, NULL, NULL);
	 break;
      case 9: /* Symbols */
	 show_symbols_form();
	 break;
      }
      Update(0);
   } 
   fl_freepup(MathMenu);
}

   
extern void LaTeXOptions();


void ScreenOptions(){
		// this is not very nice....
		fl_set_input(fd_form_screen->input_roman, roman_font_name);
		fl_set_input(fd_form_screen->input_sans, sans_font_name);
		fl_set_input(fd_form_screen->input_typewriter, typewriter_font_name);
		fl_set_input(fd_form_screen->input_font_norm, font_norm);
		char *tmpstring = new char[50];
		sprintf(tmpstring,"%d", lyxrc.default_zoom);
		fl_set_input(fd_form_screen->intinput_size, tmpstring);
		sprintf(tmpstring,"%d", font_sizes[LYX_SIZE_TINY]);
		fl_set_input(fd_form_screen->intinput_tiny, tmpstring);
		sprintf(tmpstring,"%d", font_sizes[LYX_SIZE_SMALL]);
		fl_set_input(fd_form_screen->intinput_small, tmpstring);
		sprintf(tmpstring,"%d", font_sizes[LYX_SIZE_NORMAL]);
		fl_set_input(fd_form_screen->intinput_normal, tmpstring);
		sprintf(tmpstring,"%d", font_sizes[LYX_SIZE_LARGE]);
		fl_set_input(fd_form_screen->intinput_large, tmpstring);
		sprintf(tmpstring,"%d", font_sizes[LYX_SIZE_LARGER]);
		fl_set_input(fd_form_screen->intinput_larger, tmpstring);
		sprintf(tmpstring,"%d", font_sizes[LYX_SIZE_LARGEST]);
		fl_set_input(fd_form_screen->intinput_largest, tmpstring);
		sprintf(tmpstring,"%d", font_sizes[LYX_SIZE_HUGE]);
		fl_set_input(fd_form_screen->intinput_huge, tmpstring);
		sprintf(tmpstring,"%d", font_sizes[LYX_SIZE_GIANT]);
		fl_set_input(fd_form_screen->intinput_giant, tmpstring);
		if (fd_form_screen->form_screen->visible) {
			fl_raise_form(fd_form_screen->form_screen);
		} else
			fl_show_form(fd_form_screen->form_screen,
				     FL_PLACE_MOUSE | FL_FREE_SIZE, FL_FULLBORDER,
				     "Screen Options");
		delete [] tmpstring;
}



void ShowOptionsMenu(FL_OBJECT *ob, long)
{
  // set the pseudo menu-button
  fl_set_object_boxtype(ob, FL_UP_BOX);
  fl_set_button(ob, 0);
  fl_redraw_object(ob);

  int OptionsMenu = fl_defpup(FL_ObjWin(ob),
	"Screen Fonts..."
	"|Spellchecker Options..."
	"|Keyboard..."
	"|LaTeX..." );

  fl_setpup_shortcut(OptionsMenu, 1, "Ff#f#F");
  fl_setpup_shortcut(OptionsMenu, 2, "Ss#s#S");
  fl_setpup_shortcut(OptionsMenu, 3, "Kk#k#K");
  fl_setpup_shortcut(OptionsMenu, 4, "Ll#l#L");

  fl_setpup_position(
		fd_form_main->form_main->x + ob->x,
		fd_form_main->form_main->y + ob->y + ob->h + 10);   
  int choice = fl_dopup(OptionsMenu);
   XFlush(fl_display);

   // set the pseudo menu-button back
  fl_set_object_boxtype(ob, FL_FLAT_BOX);
  fl_redraw_object(ob);
	switch (choice){
	case 1: ScreenOptions(); break;
	case 2: SpellCheckerOptions(); break;      
	case 3: MenuKeymap(); break;
	case 4: LaTeXOptions(); break;
	default: break;
	}   
	fl_freepup(OptionsMenu);
}


extern void HandleBufferMenu(int);
extern void MakeBufferMenu(int);


void ShowBufferMenu(FL_OBJECT *ob, long)
{
  // set the pseudo menu-button
  fl_set_object_boxtype(ob, FL_UP_BOX);
  fl_set_button(ob, 0);
  fl_redraw_object(ob);
   
   int BufferMenu = fl_newpup(FL_ObjWin(ob));
   MakeBufferMenu(BufferMenu);
   
   fl_setpup_position(
		      fd_form_main->form_main->x + ob->x,
		      fd_form_main->form_main->y + ob->y + ob->h + 10);   
   int choice = fl_dopup(BufferMenu);
   XFlush(fl_display);

   // set the pseudo menu-button back
   fl_set_object_boxtype(ob, FL_FLAT_BOX);
   fl_redraw_object(ob);
   if (choice > 0) HandleBufferMenu(choice);
   
   fl_freepup(BufferMenu);
}


void ShowHelpMenu(FL_OBJECT *ob, long)
{
  // set the pseudo menu-button
  fl_set_object_boxtype(ob, FL_UP_BOX);
  fl_set_button(ob, 0);
  fl_redraw_object(ob);
   
   int HelpMenu = fl_defpup(FL_ObjWin(ob),
   "Documentation..."
   "|Copyright..."
   "|Warranty..."
   "|Credits..."
   "|Version...");
   
   fl_setpup_shortcut(HelpMenu, 1, "Dd#d#D");
   fl_setpup_shortcut(HelpMenu, 2, "oO#o#O");
   fl_setpup_shortcut(HelpMenu, 3, "Ww#w#W");
   fl_setpup_shortcut(HelpMenu, 4, "Cc#c#C");
   fl_setpup_shortcut(HelpMenu, 5, "Vv#v#V");

   fl_setpup_position(
		      fd_form_main->form_main->x + ob->x,
		      fd_form_main->form_main->y + ob->y + ob->h + 10);   
   int choice = fl_dopup(HelpMenu);
   XFlush(fl_display);

   // set the pseudo menu-button back
   fl_set_object_boxtype(ob, FL_FLAT_BOX);
   fl_redraw_object(ob);

   switch (choice) {
   case 1:
      ProhibitInput();
      MenuDocu();
      AllowInput();
      break;
   case 2: 
     ProhibitInput();
     fl_show_message("","LyX is Copyright (C) 1995 by Matthias Ettrich,"
		     " 1995, 1996 LyX Team\n\nThis program is free"
		     " software; you can redistribute it and/or modify"
		     " it under the\nterms of the GNU General Public"
		     " License as published by the Free Software\n"
		     "Foundation; either version 2 of the License,"
		     " or (at your option) any later version.","");
     AllowInput();
     break;
   case 3: 
     ProhibitInput();
     fl_show_message("","LyX is distributed in the hope that it will"
		       " be useful, but WITHOUT ANY\nWARRANTY; without"
		       " even the implied warranty of MERCHANTABILITY"
		       " or\nFITNESS FOR A PARTICULAR PURPOSE. See"
		       " the GNU General Public License\nfor more"
		       " details. You should have received a copy of"
		       " the GNU General Public\nLicense along with"
		       " this program; if not, write to the Free"
		       " Software Foundation,\n Inc., 675 Mass Ave,"
		       " Cambridge, MA 02139, USA.","");
     AllowInput();
     break;
   case 4:
      ShowCredits();
      break;
   case 5:
      ProhibitInput();
      fl_show_message("","This is LyX " VERSION " of " RELEASE,"");
      AllowInput();
      break;
   }
   fl_freepup(HelpMenu);
}
