# Routines to force "compilation" of all .py files in a directory
# tree or on sys.path.  By default recursion is pruned at a depth of
# 10 and the current directory, if it occurs in sys.path, is skipped.
# When called as a script, compiles argument directories, or sys.path
# if no arguments.
# After a similar module by Sjoerd Mullender.

import os
import sys
import py_compile

def compile_dir(dir, maxlevels = 10, quiet = 0, delete = 0):
	print 'Byte-compiling files in', dir, '...'
	try:
		names = os.listdir(dir)
	except os.error:
		print "Can't list", dir
		names = []
	names.sort()
	for name in names:
		fullname = os.path.join(dir, name)
		if os.path.isfile(fullname):
			if (name[-4:] == '.pyc'):
				head, tail = name[:-4], name[-4:]
				try:
					os.stat(os.path.join (dir, head + '.py'))
				except:
					if (not quiet): print fullname, 'removed, deleting .pyc'
					if (delete):
						os.unlink (os.path.join (dir, head + '.pyc'))
			if (name[-3:] == '.py'):
				head, tail = name[:-3], name[-3:]
				spy = os.stat(os.path.join (dir, head + '.py'))[8]
				spyc = -1;
				try:
					spyc = os.stat(os.path.join (dir, head + '.pyc'))[8]
				except:
					pass
				if (spy < spyc):
					if (not quiet): print fullname, 'is current'
				else:
					if (not quiet): print 'Compiling', fullname, '...'
					try:
						py_compile.compile(fullname)
					except KeyboardInterrupt:
						del names[:]
						print '\n[interrupt]'
						break
					except:
						if type(sys.exc_type) == type(''):
							exc_type_name = sys.exc_type
						else: exc_type_name = sys.exc_type.__name__
						print 'Sorry:', exc_type_name + ':',
						print sys.exc_value
		elif maxlevels > 0 and \
		     name != os.curdir and name != os.pardir and \
		     os.path.isdir(fullname) and \
		     not os.path.islink(fullname):
			compile_dir(fullname, maxlevels - 1, quiet, delete)

def compile_path(skip_curdir = 1, quiet = 0, delete = 0):
	for dir in sys.path:
		if (not dir or dir == os.curdir) and skip_curdir:
			print 'Skipping current directory'
		else:
			compile_dir(dir, 0, quiet, delete)

def main():
	import getopt
	try:
		opts, args = getopt.getopt(sys.argv[1:], 'lqd')
	except getopt.error, msg:
		print msg
		print "usage: compileall [-l] [-q] [-d] [directory ...]"
		print "-l: don't recurse down"
		print "-q: don't list files while compiling"
		print "-d: delete .pyc files with no .py files"
		print "if no arguments, -l sys.path is assumed"
	maxlevels = 10
	quiet = 0
	delete = 0
	for o, a in opts:
		if o == '-l': maxlevels = 0
		if o == '-q': quiet = 1
		if o == '-d': delete = 1
	if args:
		for dir in args:
			compile_dir(dir, maxlevels, quiet, delete)
	else:
		compile_path(1, quiet)

if __name__ == '__main__':
	main()
