#!/bin/bash -f
#
# xp2xpp -- convert xpostit-3.2.2 notes to xpostitplus-2.x format
# Karl Sackett (krs@caos.aamu.edu), September 1996.
# This program is in the public domain, all rights reversed, void where
# inhibited by blondes.
#
# Usage: xp2xpp
#
# Post-it note filenames have the format 'note<n>', where <n> is an integer
# number.  Xpostitplus ignores notes in xpostit format and overwrites them
# when saving new notes -- so convert'em or lose'em.
#
# Set the values for save_screenx and save_screeny to the appropriate
# x and y resolutions for your monitor.
#
set -e

for n in `/bin/ls ~/.postitnotes`; do \
	awk \
	'BEGIN {
		save_screenx = 1024
		save_screeny = 768
		newcookie = "%%!!<postitnote>"
		oldcookie = "%!<postitnote>"
		hidden = 0
		anchor = 0
		pnalarm = 0
		now = systime()
		mon = strftime("%m", now) - 1
		day = strftime("%d", now) - 0
		hour = strftime("%H", now) - 0
		min = strftime("%M", now) - 0
		date = mon " " day " " hour " " min
	}
	NR == 1 {
		if ($1 != oldcookie)
			print $0
		else {
			title = $8
			for (i=9; i<=NF; i++)
				title = title " " $i
			newstuff = hidden " " anchor " " save_screeny " " save_screenx " " pnalarm " " date
			print newcookie, $2, $3, $4, $5, $6, newstuff
			print title
		}
	}
	NR > 1 {
		print $0
	}' <~/.postitnotes/$n >/tmp/convert.$$ \
	  && mv /tmp/convert.$$ ~/.postitnotes/$n;
done
