u32 SCRIPT[] = {
/*


; NCR 53c810 driver, main script
; Sponsored by 
;	iX Multiuser Multitasking Magazine
;	hm@ix.de
;
; Copyright 1993, 1994, 1995 Drew Eckhardt
;      Visionary Computing 
;      (Unix and Linux consulting and custom programming)
;      drew@PoohSticks.ORG
;      +1 (303) 786-7975
;
; TolerANT and SCSI SCRIPTS are registered trademarks of NCR Corporation.
;
; PRE-ALPHA
;
; For more information, please consult 
;
; NCR 53C810
; PCI-SCSI I/O Processor
; Data Manual
;
; NCR 53C710 
; SCSI I/O Processor
; Programmers Guide
;
; NCR Microelectronics
; 1635 Aeroplaza Drive
; Colorado Springs, CO 80916
; 1+ (719) 578-3400
;
; Toll free literature number
; +1 (800) 334-5454
;
; IMPORTANT : This code is self modifying due to the limitations of 
;	the NCR53c7,8xx series chips.  Persons debugging this code with
;	the remote debugger should take this into account, and NOT set
;	breakpoints in modified instructions.
;
; Design:
; The NCR53c7,8xx family of SCSI chips are busmasters with an onboard 
; microcontroller using a simple instruction set.   
;
; So, to minimize the effects of interrupt latency, and to maximize 
; throughput, this driver offloads the practical maximum amount 
; of processing to the SCSI chip while still maintaining a common
; structure.
;
; Where tradeoffs were needed between efficiency on the older
; chips and the newer NCR53c800 series, the NCR53c800 series 
; was chosen.
;
; While the NCR53c700 and NCR53c700-66 lacked the facilities to fully
; automate SCSI transfers without host processor intervention, this 
; isn't the case with the NCR53c710 and newer chips which allow 
;
; - reads and writes to the internal registers from within the SCSI
; 	scripts, allowing the SCSI SCRIPTS(tm) code to save processor
; 	state so that multiple threads of execution are possible, and also
; 	provide an ALU for loop control, etc.
; 
; - table indirect addressing for some instructions. This allows 
;	pointers to be located relative to the DSA ((Data Structure
;	Address) register.
;
; These features make it possible to implement a mailbox style interface,
; where the same piece of code is run to handle I/O for multiple threads
; at once minimizing our need to relocate code.  Since the NCR53c700/
; NCR53c800 series have a unique combination of features, making a 
; a standard ingoing/outgoing mailbox system, costly, I've modified it.
;
; - Mailboxes are a mixture of code and data.  This lets us greatly
; 	simplify the NCR53c810 code and do things that would otherwise
;	not be possible.
;
; The saved data pointer is now implemented as follows :
;
; 	Control flow has been architected such that if control reaches
;	munge_save_data_pointer, on a restore pointers message or 
;	reconnection, a jump to the address formerly in the TEMP register
;	will allow the SCSI command to resume execution.
;

;
; Note : the DSA structures must be aligned on 32 bit boundaries,
; since the source and destination of MOVE MEMORY instructions 
; must share the same alignment and this is the alignment of the
; NCR registers.
;

ABSOLUTE dsa_temp_lun = 0		; Patch to lun for current dsa
ABSOLUTE dsa_temp_next = 0		; Patch to dsa next for current dsa
ABSOLUTE dsa_temp_addr_next = 0		; Patch to address of dsa next address 
					; 	for current dsa
ABSOLUTE dsa_temp_sync = 0		; Patch to address of per-target
					;	sync routine
ABSOLUTE dsa_temp_target = 0		; Patch to id for current dsa
ABSOLUTE dsa_temp_addr_saved_pointer = 0; Patch to address of per-command
					; 	saved data pointer
ABSOLUTE dsa_temp_addr_residual = 0	; Patch to address of per-command
					;	current residual code
ABSOLUTE dsa_temp_addr_saved_residual = 0; Patch to address of per-command
					; saved residual code
ABSOLUTE dsa_temp_addr_new_value = 0	; Address of value for JUMP operand
ABSOLUTE dsa_temp_addr_array_value = 0 	; Address to copy to
ABSOLUTE dsa_temp_addr_dsa_value = 0	; Address of this DSA value

;
; Once a device has initiated reselection, we need to compare it 
; against the singly linked list of commands which have disconnected
; and are pending reselection.  These commands are maintained in 
; an unordered singly linked list of DSA structures, through the
; DSA pointers at their 'centers' headed by the reconnect_dsa_head
; pointer.
; 
; To avoid complications in removing commands from the list,
; I minimize the amount of expensive (at eight operations per
; addition @ 500-600ns each) pointer operations which must
; be done in the NCR driver by precomputing them on the 
; host processor during dsa structure generation.
;
; The fixed-up per DSA code knows how to recognize the nexus
; associated with the corresponding SCSI command, and modifies
; the source and destination pointers for the MOVE MEMORY 
; instruction which is executed when reselected_ok is called
; to remove the command from the list.  Similarly, DSA is 
; loaded with the address of the next DSA structure and
; reselected_check_next is called if a failure occurs.
;
; Perhaps more concisely, the net effect of the mess is 
;
; for (dsa = reconnect_dsa_head, dest = &reconnect_dsa_head, 
;     src = NULL; dsa; dest = &dsa->next, dsa = dsa->next) {
; 	src = &dsa->next;
; 	if (target_id == dsa->id && target_lun == dsa->lun) {
; 		*dest = *src;
; 		break;
;         }	
; }
;
; if (!dsa)
;           error (int_err_unexpected_reselect);
; else  
;     longjmp (dsa->jump_resume, 0);
;
; 	


; Define DSA structure used for mailboxes
ENTRY dsa_code_template
dsa_code_template:
ENTRY dsa_code_begin
dsa_code_begin:
	MOVE dmode_memory_to_ncr TO DMODE

at 0x00000000 : */	0x78380000,0x00000000,
/*
	MOVE MEMORY 4, dsa_temp_addr_dsa_value, addr_scratch

at 0x00000002 : */	0xc0000004,0x00000000,
/*

at 0x00000004 : */	0x00000000,0x78380000,
/*

at 0x00000006 : */	0x00000000,0x88080000,
/*

at 0x00000008 : */	0x00000980,0x88080000,
/*

at 0x0000000a : */	0x000001fc,0x60000008,
/*

at 0x0000000c : */	0x00000000,0x60000040,
/*

at 0x0000000e : */	0x00000000,0xc0000004,
/*

at 0x00000010 : */	0x00000000,0x00000000,
/*
	JUMP select_done

at 0x00000012 : */	0x80080000,0x00000224,
/*

; wrong_dsa loads the DSA register with the value of the dsa_next
; field.
;
wrong_dsa:
;		Patch the MOVE MEMORY INSTRUCTION such that 
;		the destination address is the address of the OLD 
;		next pointer.
;
	MOVE MEMORY 4, dsa_temp_addr_next, reselected_ok + 8

at 0x00000014 : */	0xc0000004,0x00000000,
/*

at 0x00000016 : */	0x00000758,0x78380000,
/*

at 0x00000018 : */	0x00000000,0xc0000004,
/*

at 0x0000001a : */	0x00000000,0x00000000,
/*
	MOVE dmode_memory_to_memory TO DMODE

at 0x0000001c : */	0x78380000,0x00000000,
/*
	CALL scratch_to_dsa

at 0x0000001e : */	0x88080000,0x00000980,
/*
	JUMP reselected_check_next

at 0x00000020 : */	0x80080000,0x000006a4,
/*

ABSOLUTE dsa_save_data_pointer = 0
ENTRY dsa_code_save_data_pointer
dsa_code_save_data_pointer:
    	MOVE dmode_ncr_to_memory TO DMODE

at 0x00000022 : */	0x78380000,0x00000000,
/*
    	MOVE MEMORY 4, addr_temp, dsa_temp_addr_saved_pointer

at 0x00000024 : */	0xc0000004,0x00000000,
/*

at 0x00000026 : */	0x00000000,0x78380000,
/*

at 0x00000028 : */	0x00000000,0xc0000018,
/*

at 0x0000002a : */	0x00000000,0x00000000,
/*
        CLEAR ACK

at 0x0000002c : */	0x60000040,0x00000000,
/*



    	RETURN

at 0x0000002e : */	0x90080000,0x00000000,
/*
ABSOLUTE dsa_restore_pointers = 0
ENTRY dsa_code_restore_pointers
dsa_code_restore_pointers:
    	MOVE dmode_memory_to_ncr TO DMODE

at 0x00000030 : */	0x78380000,0x00000000,
/*
    	MOVE MEMORY 4, dsa_temp_addr_saved_pointer, addr_temp

at 0x00000032 : */	0xc0000004,0x00000000,
/*

at 0x00000034 : */	0x00000000,0x78380000,
/*

at 0x00000036 : */	0x00000000,0xc0000018,
/*

at 0x00000038 : */	0x00000000,0x00000000,
/*
        CLEAR ACK

at 0x0000003a : */	0x60000040,0x00000000,
/*



    	RETURN

at 0x0000003c : */	0x90080000,0x00000000,
/*

ABSOLUTE dsa_check_reselect = 0
; dsa_check_reselect determines whether or not the current target and
; lun match the current DSA
ENTRY dsa_code_check_reselect
dsa_code_check_reselect:
	MOVE SSID TO SFBR		; SSID contains 3 bit target ID

at 0x0000003e : */	0x720a0000,0x00000000,
/*
; FIXME : we need to accommodate bit fielded and binary here for '7xx/'8xx chips
	JUMP REL (wrong_dsa), IF NOT dsa_temp_target, AND MASK 0xf8

at 0x00000040 : */	0x8084f800,0x00ffff48,
/*
;
; Hack - move to scratch first, since SFBR is not writeable
; 	via the CPU and hence a MOVE MEMORY instruction.
;
	MOVE dmode_memory_to_ncr TO DMODE

at 0x00000042 : */	0x78380000,0x00000000,
/*
	MOVE MEMORY 1, reselected_identify, addr_scratch

at 0x00000044 : */	0xc0000001,0x00000000,
/*

at 0x00000046 : */	0x00000000,0x78380000,
/*

at 0x00000048 : */	0x00000000,0x72340000,
/*

at 0x0000004a : */	0x00000000,0x8084f800,
/*

at 0x0000004c : */	0x00ffff1c,0xc0000004,
/*

at 0x0000004e : */	0x00000000,0x00000754,
/*
	CALL reselected_ok

at 0x00000050 : */	0x88080000,0x00000750,
/*
	CALL dsa_temp_sync	

at 0x00000052 : */	0x88080000,0x00000000,
/*
; Release ACK on the IDENTIFY message _after_ we've set the synchronous 
; transfer parameters! 
	CLEAR ACK

at 0x00000054 : */	0x60000040,0x00000000,
/*
; Implicitly restore pointers on reselection, so a RETURN
; will transfer control back to the right spot.
    	CALL REL (dsa_code_restore_pointers)

at 0x00000056 : */	0x88880000,0x00ffff60,
/*
    	RETURN

at 0x00000058 : */	0x90080000,0x00000000,
/*
ENTRY dsa_zero
dsa_zero:
ENTRY dsa_code_template_end
dsa_code_template_end:

; Perform sanity check for dsa_fields_start == dsa_code_template_end - 
; dsa_zero, puke.

ABSOLUTE dsa_fields_start =  0	; Sanity marker
				; 	pad 48 bytes (fix this RSN)
ABSOLUTE dsa_next = 48		; len 4 Next DSA
 				; del 4 Previous DSA address
ABSOLUTE dsa_cmnd = 56		; len 4 Scsi_Cmnd * for this thread.
ABSOLUTE dsa_select = 60	; len 4 Device ID, Period, Offset for 
			 	;	table indirect select
ABSOLUTE dsa_msgout = 64	; len 8 table indirect move parameter for 
				;       select message
ABSOLUTE dsa_cmdout = 72	; len 8 table indirect move parameter for 
				;	command
ABSOLUTE dsa_dataout = 80	; len 4 code pointer for dataout
ABSOLUTE dsa_datain = 84	; len 4 code pointer for datain
ABSOLUTE dsa_msgin = 88		; len 8 table indirect move for msgin
ABSOLUTE dsa_status = 96 	; len 8 table indirect move for status byte
ABSOLUTE dsa_msgout_other = 104	; len 8 table indirect for normal message out
				; (Synchronous transfer negotiation, etc).
ABSOLUTE dsa_end = 112

ABSOLUTE schedule = 0 		; Array of JUMP dsa_begin or JUMP (next),
				; terminated by a call to JUMP wait_reselect

; Linked lists of DSA structures
ABSOLUTE reconnect_dsa_head = 0	; Link list of DSAs which can reconnect
ABSOLUTE addr_reconnect_dsa_head = 0 ; Address of variable containing
				; address of reconnect_dsa_head

; These select the source and destination of a MOVE MEMORY instruction
ABSOLUTE dmode_memory_to_memory = 0x0
ABSOLUTE dmode_memory_to_ncr = 0x0
ABSOLUTE dmode_ncr_to_memory = 0x0

ABSOLUTE addr_scratch = 0x0
ABSOLUTE addr_temp = 0x0


; Interrupts - 
; MSB indicates type
; 0	handle error condition
; 1 	handle message 
; 2 	handle normal condition
; 3	debugging interrupt
; 4 	testing interrupt 
; Next byte indicates specific error

; XXX not yet implemented, I'm not sure if I want to - 
; Next byte indicates the routine the error occurred in
; The LSB indicates the specific place the error occurred
 
ABSOLUTE int_err_unexpected_phase = 0x00000000	; Unexpected phase encountered
ABSOLUTE int_err_selected = 0x00010000		; SELECTED (nee RESELECTED)
ABSOLUTE int_err_unexpected_reselect = 0x00020000 
ABSOLUTE int_err_check_condition = 0x00030000	
ABSOLUTE int_err_no_phase = 0x00040000
ABSOLUTE int_msg_wdtr = 0x01000000		; WDTR message received
ABSOLUTE int_msg_sdtr = 0x01010000		; SDTR received
ABSOLUTE int_msg_1 = 0x01020000			; single byte special message
						; received

ABSOLUTE int_norm_select_complete = 0x02000000	; Select complete, reprogram
						; registers.
ABSOLUTE int_norm_reselect_complete = 0x02010000	; Nexus established
ABSOLUTE int_norm_command_complete = 0x02020000 ; Command complete
ABSOLUTE int_norm_disconnected = 0x02030000	; Disconnected 
ABSOLUTE int_norm_aborted =0x02040000		; Aborted *dsa
ABSOLUTE int_norm_reset = 0x02050000		; Generated BUS reset.
ABSOLUTE int_debug_break = 0x03000000		; Break point

ABSOLUTE int_debug_panic = 0x030b0000		; Panic driver


ABSOLUTE int_test_1 = 0x04000000		; Test 1 complete
ABSOLUTE int_test_2 = 0x04010000		; Test 2 complete
ABSOLUTE int_test_3 = 0x04020000		; Test 3 complete


; These should start with 0x05000000, with low bits incrementing for 
; each one.


						
ABSOLUTE NCR53c7xx_msg_abort = 0	; Pointer to abort message
ABSOLUTE NCR53c7xx_msg_reject = 0       ; Pointer to reject message
ABSOLUTE NCR53c7xx_zero	= 0		; long with zero in it, use for source
ABSOLUTE NCR53c7xx_sink = 0		; long to dump worthless data in
ABSOLUTE NOP_insn = 0			; NOP instruction

; Pointer to message, potentially multi-byte
ABSOLUTE msg_buf = 0

; Pointer to holding area for reselection information
ABSOLUTE reselected_identify = 0
ABSOLUTE reselected_tag = 0

; Request sense command pointer, it's a 6 byte command, should
; be constant for all commands since we always want 16 bytes of 
; sense and we don't need to change any fields as we did under 
; SCSI-I when we actually cared about the LUN field.
;EXTERNAL NCR53c7xx_sense		; Request sense command


; dsa_schedule  
; PURPOSE : after a DISCONNECT message has been received, and pointers
;	saved, insert the current DSA structure at the head of the 
; 	disconnected queue and fall through to the scheduler.
;
; CALLS : OK
;
; INPUTS : dsa - current DSA structure, reconnect_dsa_head - list
;	of disconnected commands
;
; MODIFIES : SCRATCH, reconnect_dsa_head
; 
; EXITS : always passes control to schedule

ENTRY dsa_schedule
dsa_schedule:




;
; Calculate the address of the next pointer within the DSA 
; structure of the command that is currently disconnecting
;
    CALL dsa_to_scratch

at 0x0000005a : */	0x88080000,0x00000938,
/*
    MOVE SCRATCH0 + dsa_next TO SCRATCH0

at 0x0000005c : */	0x7e343000,0x00000000,
/*
    MOVE SCRATCH1 + 0 TO SCRATCH1 WITH CARRY

at 0x0000005e : */	0x7f350000,0x00000000,
/*
    MOVE SCRATCH2 + 0 TO SCRATCH2 WITH CARRY

at 0x00000060 : */	0x7f360000,0x00000000,
/*
    MOVE SCRATCH3 + 0 TO SCRATCH3 WITH CARRY

at 0x00000062 : */	0x7f370000,0x00000000,
/*

; Point the next field of this DSA structure at the current disconnected 
; list
    MOVE dmode_ncr_to_memory TO DMODE

at 0x00000064 : */	0x78380000,0x00000000,
/*
    MOVE MEMORY 4, addr_scratch, dsa_schedule_insert + 8

at 0x00000066 : */	0xc0000004,0x00000000,
/*

at 0x00000068 : */	0x000001b4,0x78380000,
/*

at 0x0000006a : */	0x00000000,0xc0000004,
/*

at 0x0000006c : */	0x00000000,0x00000000,
/*

; And update the head pointer.
    CALL dsa_to_scratch

at 0x0000006e : */	0x88080000,0x00000938,
/*
    MOVE dmode_ncr_to_memory TO DMODE	

at 0x00000070 : */	0x78380000,0x00000000,
/*
    MOVE MEMORY 4, addr_scratch, reconnect_dsa_head

at 0x00000072 : */	0xc0000004,0x00000000,
/*

at 0x00000074 : */	0x00000000,0x78380000,
/*

at 0x00000076 : */	0x00000000,0x7c027f00,
/*

at 0x00000078 : */	0x00000000,0x60000040,
/*

at 0x0000007a : */	0x00000000,0x48000000,
/*

at 0x0000007c : */	0x00000000,0x80080000,
/*

at 0x0000007e : */	0x00000000,0x60000200,
/*

at 0x00000080 : */	0x00000000,0x4300003c,
/*

at 0x00000082 : */	0x000007a4,0x860b0000,
/*

at 0x00000084 : */	0x00000214,0x1e000000,
/*

at 0x00000086 : */	0x00000040,0x90080000,
/*

at 0x00000088 : */	0x00000000,0x820b0000,
/*

at 0x0000008a : */	0x00000244,0x9f030000,
/*

at 0x0000008c : */	0x00000000,0x8f0b0000,
/*

at 0x0000008e : */	0x00000404,0x870b0000,
/*

at 0x00000090 : */	0x00000234,0x9a030000,
/*

at 0x00000092 : */	0x00000000,0x1a000000,
/*

at 0x00000094 : */	0x00000048,0x820b0000,
/*

at 0x00000096 : */	0x0000024c,0x8f0b0000,
/*

at 0x00000098 : */	0x00000404,0x9e0b0000,
/*

at 0x0000009a : */	0x00000000,0x800b0000,
/*

at 0x0000009c : */	0x0000028c,0x810b0000,
/*

at 0x0000009e : */	0x000002e4,0x830b0000,
/*

at 0x000000a0 : */	0x0000060c,0x80080000,
/*

at 0x000000a2 : */	0x00000254,0x88080000,
/*

at 0x000000a4 : */	0x00000938,0x7e345000,
/*

at 0x000000a6 : */	0x00000000,0x7f350000,
/*

at 0x000000a8 : */	0x00000000,0x7f360000,
/*

at 0x000000aa : */	0x00000000,0x7f370000,
/*

at 0x000000ac : */	0x00000000,0x78380000,
/*

at 0x000000ae : */	0x00000000,0xc0000004,
/*

at 0x000000b0 : */	0x00000000,0x000002d4,
/*
    MOVE dmode_memory_to_memory TO DMODE

at 0x000000b2 : */	0x78380000,0x00000000,
/*
dataout_to_jump:
    MOVE MEMORY 4, 0, dataout_jump + 4 

at 0x000000b4 : */	0xc0000004,0x00000000,
/*

at 0x000000b6 : */	0x000002e0,0x80080000,
/*

at 0x000000b8 : */	0x00000000,0x88080000,
/*

at 0x000000ba : */	0x00000938,0x7e345400,
/*

at 0x000000bc : */	0x00000000,0x7f350000,
/*

at 0x000000be : */	0x00000000,0x7f360000,
/*

at 0x000000c0 : */	0x00000000,0x7f370000,
/*

at 0x000000c2 : */	0x00000000,0x78380000,
/*

at 0x000000c4 : */	0x00000000,0xc0000004,
/*

at 0x000000c6 : */	0x00000000,0x0000032c,
/*
    MOVE dmode_memory_to_memory TO DMODE		

at 0x000000c8 : */	0x78380000,0x00000000,
/*
ENTRY datain_to_jump
datain_to_jump:
    MOVE MEMORY 4, 0, datain_jump + 4

at 0x000000ca : */	0xc0000004,0x00000000,
/*

at 0x000000cc : */	0x00000338,0x80080000,
/*

at 0x000000ce : */	0x00000000,0x9a0b0000,
/*

at 0x000000d0 : */	0x00000000,0x870b0000,
/*

at 0x000000d2 : */	0x000003e4,0x9e0b0000,
/*

at 0x000000d4 : */	0x00000000,0x990b0000,
/*

at 0x000000d6 : */	0x00000000,0x830b0000,
/*

at 0x000000d8 : */	0x0000060c,0x80030000,
/*

at 0x000000da : */	0x0000033c,0x90080000,
/*

at 0x000000dc : */	0x00000000,0x9a0b0000,
/*

at 0x000000de : */	0x00000000,0x870b0000,
/*

at 0x000000e0 : */	0x000003e4,0x9e0b0000,
/*

at 0x000000e2 : */	0x00000000,0x980b0000,
/*

at 0x000000e4 : */	0x00000000,0x830b0000,
/*

at 0x000000e6 : */	0x0000060c,0x81030000,
/*

at 0x000000e8 : */	0x00000374,0x90080000,
/*

at 0x000000ea : */	0x00000000,0x9a0b0000,
/*

at 0x000000ec : */	0x00000000,0x8f0b0000,
/*

at 0x000000ee : */	0x00000404,0x9e0b0000,
/*

at 0x000000f0 : */	0x00000000,0x980b0000,
/*

at 0x000000f2 : */	0x00000000,0x990b0000,
/*

at 0x000000f4 : */	0x00000000,0x830b0000,
/*

at 0x000000f6 : */	0x0000060c,0x80080000,
/*

at 0x000000f8 : */	0x000003ac,0x7e1cf800,
/*

at 0x000000fa : */	0x00000000,0x7f1dff00,
/*

at 0x000000fc : */	0x00000000,0x7f1eff00,
/*

at 0x000000fe : */	0x00000000,0x7f1fff00,
/*

at 0x00000100 : */	0x00000000,0x0f000001,
/*

at 0x00000102 : */	0x00000000,0x800c0001,
/*

at 0x00000104 : */	0x00000524,0x800cdf20,
/*

at 0x00000106 : */	0x0000044c,0x800c0002,
/*

at 0x00000108 : */	0x00000454,0x800c0003,
/*

at 0x0000010a : */	0x000004b8,0x800c0004,
/*

at 0x0000010c : */	0x0000051c,0x980c0007,
/*

at 0x0000010e : */	0x01020000,0x980c000f,
/*

at 0x00000110 : */	0x01020000,0x80080000,
/*

at 0x00000112 : */	0x000005b4,0x80080000,
/*

at 0x00000114 : */	0x000005b4,0x76100000,
/*

at 0x00000116 : */	0x00000000,0x6a340000,
/*

at 0x00000118 : */	0x00000000,0x7711ff00,
/*

at 0x0000011a : */	0x00000000,0x6a350000,
/*

at 0x0000011c : */	0x00000000,0x7712ff00,
/*

at 0x0000011e : */	0x00000000,0x6a360000,
/*

at 0x00000120 : */	0x00000000,0x7713ff00,
/*

at 0x00000122 : */	0x00000000,0x6a370000,
/*

at 0x00000124 : */	0x00000000,0x78380000,
/*

at 0x00000126 : */	0x00000000,0xc0000004,
/*

at 0x00000128 : */	0x00000000,0x000004b4,
/*
    MOVE dmode_memory_to_memory TO DMODE

at 0x0000012a : */	0x78380000,0x00000000,
/*
jump_dsa_save:
    JUMP 0

at 0x0000012c : */	0x80080000,0x00000000,
/*

munge_restore_pointers:
    MOVE DSA0 + dsa_restore_pointers TO SFBR

at 0x0000012e : */	0x76100000,0x00000000,
/*
    MOVE SFBR TO SCRATCH0

at 0x00000130 : */	0x6a340000,0x00000000,
/*
    MOVE DSA1 + 0xff TO SFBR WITH CARRY

at 0x00000132 : */	0x7711ff00,0x00000000,
/*
    MOVE SFBR TO SCRATCH1

at 0x00000134 : */	0x6a350000,0x00000000,
/*
    MOVE DSA2 + 0xff TO SFBR WITH CARRY

at 0x00000136 : */	0x7712ff00,0x00000000,
/*
    MOVE SFBR TO SCRATCH2

at 0x00000138 : */	0x6a360000,0x00000000,
/*
    MOVE DSA3 + 0xff TO SFBR WITH CARRY

at 0x0000013a : */	0x7713ff00,0x00000000,
/*
    MOVE SFBR TO SCRATCH3

at 0x0000013c : */	0x6a370000,0x00000000,
/*

    MOVE dmode_ncr_to_memory TO DMODE

at 0x0000013e : */	0x78380000,0x00000000,
/*
    MOVE MEMORY 4, addr_scratch, jump_dsa_restore + 4

at 0x00000140 : */	0xc0000004,0x00000000,
/*

at 0x00000142 : */	0x00000518,0x78380000,
/*

at 0x00000144 : */	0x00000000,0x80080000,
/*

at 0x00000146 : */	0x00000000,0x80080000,
/*

at 0x00000148 : */	0x00000168,0x60000040,
/*

at 0x0000014a : */	0x00000000,0x9f030000,
/*

at 0x0000014c : */	0x00000000,0x0f000001,
/*

at 0x0000014e : */	0x00000001,0x800c0002,
/*

at 0x00000150 : */	0x00000554,0x800c0003,
/*

at 0x00000152 : */	0x00000584,0x80080000,
/*

at 0x00000154 : */	0x000005b4,0x60000040,
/*

at 0x00000156 : */	0x00000000,0x0f000001,
/*

at 0x00000158 : */	0x00000002,0x80040002,
/*

at 0x0000015a : */	0x000005b4,0x60000040,
/*

at 0x0000015c : */	0x00000000,0x0f000001,
/*

at 0x0000015e : */	0x00000003,0x98080000,
/*

at 0x00000160 : */	0x01000000,0x60000040,
/*

at 0x00000162 : */	0x00000000,0x0f000001,
/*

at 0x00000164 : */	0x00000002,0x80040001,
/*

at 0x00000166 : */	0x000005b4,0x60000040,
/*

at 0x00000168 : */	0x00000000,0x0f000002,
/*

at 0x0000016a : */	0x00000003,0x98080000,
/*

at 0x0000016c : */	0x01010000,0x58000008,
/*

at 0x0000016e : */	0x00000000,0x60000040,
/*

at 0x00000170 : */	0x00000000,0x0e000001,
/*

at 0x00000172 : */	0x00000000,0x90080000,
/*

at 0x00000174 : */	0x00000000,0x60000008,
/*

at 0x00000176 : */	0x00000000,0x60000040,
/*

at 0x00000178 : */	0x00000000,0x90080000,
/*

at 0x0000017a : */	0x00000000,0x58000008,
/*

at 0x0000017c : */	0x00000000,0x60000040,
/*

at 0x0000017e : */	0x00000000,0x1e000000,
/*

at 0x00000180 : */	0x00000068,0x90080000,
/*

at 0x00000182 : */	0x00000000,0x1b000000,
/*

at 0x00000184 : */	0x00000060,0x6a340000,
/*

at 0x00000186 : */	0x00000000,0x1f000000,
/*

at 0x00000188 : */	0x00000058,0x7c027f00,
/*

at 0x0000018a : */	0x00000000,0x60000040,
/*

at 0x0000018c : */	0x00000000,0x48000000,
/*

at 0x0000018e : */	0x00000000,0x98180000,
/*

at 0x00000190 : */	0x00000000,0x80080000,
/*

at 0x00000192 : */	0x00000000,0x98080000,
/*

at 0x00000194 : */	0x00030000,0x50000000,
/*

at 0x00000196 : */	0x0000076c,0x60000200,
/*

at 0x00000198 : */	0x00000000,0x78380000,
/*

at 0x0000019a : */	0x00000000,0x0f000001,
/*

at 0x0000019c : */	0x00000000,0x78380000,
/*

at 0x0000019e : */	0x00000000,0xc0000004,
/*

at 0x000001a0 : */	0x00000000,0x00000000,
/*
    MOVE dmode_memory_to_memory TO DMODE

at 0x000001a2 : */	0x78380000,0x00000000,
/*
    CALL scratch_to_dsa

at 0x000001a4 : */	0x88080000,0x00000980,
/*

    ; Fix the update-next pointer so that the reconnect_dsa_head
    ; pointer is the one that will be updated if this DSA is a hit 
    ; and we remove it from the queue.

    MOVE MEMORY 4, addr_reconnect_dsa_head, reselected_ok + 8

at 0x000001a6 : */	0xc0000004,0x00000000,
/*

at 0x000001a8 : */	0x00000758,0x72100000,
/*

at 0x000001aa : */	0x00000000,0x80040000,
/*

at 0x000001ac : */	0x000006ec,0x72110000,
/*

at 0x000001ae : */	0x00000000,0x80040000,
/*

at 0x000001b0 : */	0x000006ec,0x72120000,
/*

at 0x000001b2 : */	0x00000000,0x80040000,
/*

at 0x000001b4 : */	0x000006ec,0x72130000,
/*

at 0x000001b6 : */	0x00000000,0x80040000,
/*

at 0x000001b8 : */	0x000006ec,0x98080000,
/*

at 0x000001ba : */	0x00020000,0x72100000,
/*

at 0x000001bc : */	0x00000000,0x6e340000,
/*

at 0x000001be : */	0x00000000,0x72110000,
/*

at 0x000001c0 : */	0x00000000,0x6f35ff00,
/*

at 0x000001c2 : */	0x00000000,0x72120000,
/*

at 0x000001c4 : */	0x00000000,0x6f36ff00,
/*

at 0x000001c6 : */	0x00000000,0x72130000,
/*

at 0x000001c8 : */	0x00000000,0x6f37ff00,
/*

at 0x000001ca : */	0x00000000,0x78380000,
/*

at 0x000001cc : */	0x00000000,0xc0000004,
/*

at 0x000001ce : */	0x00000000,0x0000074c,
/*
    MOVE dmode_memory_to_memory TO DMODE

at 0x000001d0 : */	0x78380000,0x00000000,
/*
reselected_check:
    JUMP 0

at 0x000001d2 : */	0x80080000,0x00000000,
/*


;
;
ENTRY reselected_ok
reselected_ok:
    MOVE MEMORY 4, 0, 0				; Patched : first word

at 0x000001d4 : */	0xc0000004,0x00000000,
/*

at 0x000001d6 : */	0x00000000,0x90080000,
/*

at 0x000001d8 : */	0x00000000,0x98080000,
/*

at 0x000001da : */	0x00010000,0x74422000,
/*

at 0x000001dc : */	0x00000000,0x800c0020,
/*

at 0x000001de : */	0x00000764,0x741a4000,
/*

at 0x000001e0 : */	0x00000000,0x800c0040,
/*

at 0x000001e2 : */	0x00000000,0x74140800,
/*

at 0x000001e4 : */	0x00000000,0x800c0008,
/*

at 0x000001e6 : */	0x0000065c,0x98080000,
/*

at 0x000001e8 : */	0x030b0000,0x74423000,
/*

at 0x000001ea : */	0x00000000,0x800c0020,
/*

at 0x000001ec : */	0x00000764,0x800c0010,
/*

at 0x000001ee : */	0x0000065c,0x741a4000,
/*

at 0x000001f0 : */	0x00000000,0x800c0040,
/*

at 0x000001f2 : */	0x000001fc,0x74140800,
/*

at 0x000001f4 : */	0x00000000,0x800c0008,
/*

at 0x000001f6 : */	0x0000065c,0x98080000,
/*

at 0x000001f8 : */	0x030b0000,0xc0000004,
/*

at 0x000001fa : */	0x00000000,0x00000000,
/*
    INT int_test_1

at 0x000001fc : */	0x98080000,0x04000000,
/*

;
; Run arbitrary commands, with test code establishing a DSA
;
 
ENTRY test_2
test_2:
    CLEAR TARGET

at 0x000001fe : */	0x60000200,0x00000000,
/*
    SELECT ATN FROM 0, test_2_fail

at 0x00000200 : */	0x43000000,0x00000850,
/*
    JUMP test_2_msgout, WHEN MSG_OUT

at 0x00000202 : */	0x860b0000,0x00000810,
/*
ENTRY test_2_msgout
test_2_msgout:
    MOVE FROM 8, WHEN MSG_OUT

at 0x00000204 : */	0x1e000000,0x00000008,
/*
    MOVE FROM 16, WHEN CMD 

at 0x00000206 : */	0x1a000000,0x00000010,
/*
    MOVE FROM 24, WHEN DATA_IN

at 0x00000208 : */	0x19000000,0x00000018,
/*
    MOVE FROM 32, WHEN STATUS

at 0x0000020a : */	0x1b000000,0x00000020,
/*
    MOVE FROM 40, WHEN MSG_IN

at 0x0000020c : */	0x1f000000,0x00000028,
/*
    MOVE SCNTL2 & 0x7f TO SCNTL2

at 0x0000020e : */	0x7c027f00,0x00000000,
/*
    CLEAR ACK

at 0x00000210 : */	0x60000040,0x00000000,
/*
    WAIT DISCONNECT

at 0x00000212 : */	0x48000000,0x00000000,
/*
test_2_fail:
    INT int_test_2

at 0x00000214 : */	0x98080000,0x04010000,
/*

ENTRY debug_break
debug_break:
    INT int_debug_break

at 0x00000216 : */	0x98080000,0x03000000,
/*

;
; initiator_abort
; target_abort
;
; PURPOSE : Abort the currently established nexus from with initiator
;	or target mode.
;
;  

ENTRY target_abort
target_abort:
    SET TARGET

at 0x00000218 : */	0x58000200,0x00000000,
/*
    DISCONNECT

at 0x0000021a : */	0x48000000,0x00000000,
/*
    CLEAR TARGET

at 0x0000021c : */	0x60000200,0x00000000,
/*
    JUMP schedule

at 0x0000021e : */	0x80080000,0x00000000,
/*
    
ENTRY initiator_abort
initiator_abort:
    SET ATN

at 0x00000220 : */	0x58000008,0x00000000,
/*
;
; The SCSI-I specification says that targets may go into MSG out at 
; their leisure upon receipt of the ATN single.  On all versions of the 
; specification, we can't change phases until REQ transitions true->false, 
; so we need to sink/source one byte of data to allow the transition.
;
; For the sake of safety, we'll only source one byte of data in all 
; cases, but to accommodate the SCSI-I dain bramage, we'll sink an  
; arbitrary number of bytes.
    JUMP spew_cmd, WHEN CMD

at 0x00000222 : */	0x820b0000,0x000008b8,
/*
    JUMP eat_msgin, WHEN MSG_IN

at 0x00000224 : */	0x870b0000,0x000008c8,
/*
    JUMP eat_datain, WHEN DATA_IN

at 0x00000226 : */	0x810b0000,0x000008f8,
/*
    JUMP eat_status, WHEN STATUS

at 0x00000228 : */	0x830b0000,0x000008e0,
/*
    JUMP spew_dataout, WHEN DATA_OUT

at 0x0000022a : */	0x800b0000,0x00000910,
/*
    JUMP sated

at 0x0000022c : */	0x80080000,0x00000918,
/*
spew_cmd:
    MOVE 1, NCR53c7xx_zero, WHEN CMD

at 0x0000022e : */	0x0a000001,0x00000000,
/*
    JUMP sated

at 0x00000230 : */	0x80080000,0x00000918,
/*
eat_msgin:
    MOVE 1, NCR53c7xx_sink, WHEN MSG_IN

at 0x00000232 : */	0x0f000001,0x00000000,
/*
    JUMP eat_msgin, WHEN MSG_IN

at 0x00000234 : */	0x870b0000,0x000008c8,
/*
    JUMP sated

at 0x00000236 : */	0x80080000,0x00000918,
/*
eat_status:
    MOVE 1, NCR53c7xx_sink, WHEN STATUS

at 0x00000238 : */	0x0b000001,0x00000000,
/*
    JUMP eat_status, WHEN STATUS

at 0x0000023a : */	0x830b0000,0x000008e0,
/*
    JUMP sated

at 0x0000023c : */	0x80080000,0x00000918,
/*
eat_datain:
    MOVE 1, NCR53c7xx_sink, WHEN DATA_IN

at 0x0000023e : */	0x09000001,0x00000000,
/*
    JUMP eat_datain, WHEN DATA_IN

at 0x00000240 : */	0x810b0000,0x000008f8,
/*
    JUMP sated

at 0x00000242 : */	0x80080000,0x00000918,
/*
spew_dataout:
    MOVE 1, NCR53c7xx_zero, WHEN DATA_OUT

at 0x00000244 : */	0x08000001,0x00000000,
/*
sated:
    MOVE SCNTL2 & 0x7f TO SCNTL2

at 0x00000246 : */	0x7c027f00,0x00000000,
/*
    MOVE 1, NCR53c7xx_msg_abort, WHEN MSG_OUT

at 0x00000248 : */	0x0e000001,0x00000000,
/*
    WAIT DISCONNECT

at 0x0000024a : */	0x48000000,0x00000000,
/*
    INT int_norm_aborted

at 0x0000024c : */	0x98080000,0x02040000,
/*

;
; dsa_to_scratch
; scratch_to_dsa
;
; PURPOSE :
; 	The NCR chips cannot do a move memory instruction with the DSA register 
; 	as the source or destination.  So, we provide a couple of subroutines
; 	that let us switch between the DSA register and scratch register.
;
; 	Memory moves to/from the DSPS  register also don't work, but we 
; 	don't use them.
;
;

 
dsa_to_scratch:
    MOVE DSA0 TO SFBR

at 0x0000024e : */	0x72100000,0x00000000,
/*
    MOVE SFBR TO SCRATCH0

at 0x00000250 : */	0x6a340000,0x00000000,
/*
    MOVE DSA1 TO SFBR

at 0x00000252 : */	0x72110000,0x00000000,
/*
    MOVE SFBR TO SCRATCH1

at 0x00000254 : */	0x6a350000,0x00000000,
/*
    MOVE DSA2 TO SFBR

at 0x00000256 : */	0x72120000,0x00000000,
/*
    MOVE SFBR TO SCRATCH2

at 0x00000258 : */	0x6a360000,0x00000000,
/*
    MOVE DSA3 TO SFBR

at 0x0000025a : */	0x72130000,0x00000000,
/*
    MOVE SFBR TO SCRATCH3

at 0x0000025c : */	0x6a370000,0x00000000,
/*
    RETURN

at 0x0000025e : */	0x90080000,0x00000000,
/*

scratch_to_dsa:
    MOVE SCRATCH0 TO SFBR

at 0x00000260 : */	0x72340000,0x00000000,
/*
    MOVE SFBR TO DSA0

at 0x00000262 : */	0x6a100000,0x00000000,
/*
    MOVE SCRATCH1 TO SFBR

at 0x00000264 : */	0x72350000,0x00000000,
/*
    MOVE SFBR TO DSA1

at 0x00000266 : */	0x6a110000,0x00000000,
/*
    MOVE SCRATCH2 TO SFBR

at 0x00000268 : */	0x72360000,0x00000000,
/*
    MOVE SFBR TO DSA2

at 0x0000026a : */	0x6a120000,0x00000000,
/*
    MOVE SCRATCH3 TO SFBR

at 0x0000026c : */	0x72370000,0x00000000,
/*
    MOVE SFBR TO DSA3

at 0x0000026e : */	0x6a130000,0x00000000,
/*
    RETURN

at 0x00000270 : */	0x90080000,0x00000000,
};

#define A_NCR53c7xx_msg_abort	0x00000000
u32 A_NCR53c7xx_msg_abort_used[] = {
	0x00000249,
};

#define A_NCR53c7xx_msg_reject	0x00000000
u32 A_NCR53c7xx_msg_reject_used[] = {
	0x00000172,
};

#define A_NCR53c7xx_sink	0x00000000
u32 A_NCR53c7xx_sink_used[] = {
	0x00000233,
	0x00000239,
	0x0000023f,
};

#define A_NCR53c7xx_zero	0x00000000
u32 A_NCR53c7xx_zero_used[] = {
	0x0000022f,
	0x00000245,
};

#define A_NOP_insn	0x00000000
u32 A_NOP_insn_used[] = {
	0x00000010,
};

#define A_addr_reconnect_dsa_head	0x00000000
u32 A_addr_reconnect_dsa_head_used[] = {
	0x000001a7,
};

#define A_addr_scratch	0x00000000
u32 A_addr_scratch_used[] = {
	0x00000004,
	0x0000001b,
	0x00000046,
	0x00000067,
	0x00000073,
	0x000000b0,
	0x000000c6,
	0x00000128,
	0x00000141,
	0x000001a1,
	0x000001ce,
};

#define A_addr_temp	0x00000000
u32 A_addr_temp_used[] = {
	0x00000025,
	0x00000034,
};

#define A_dmode_memory_to_memory	0x00000000
u32 A_dmode_memory_to_memory_used[] = {
	0x00000005,
	0x0000001c,
	0x00000027,
	0x00000035,
	0x00000047,
	0x00000069,
	0x00000075,
	0x000000b2,
	0x000000c8,
	0x0000012a,
	0x00000143,
	0x00000199,
	0x000001a2,
	0x000001d0,
};

#define A_dmode_memory_to_ncr	0x00000000
u32 A_dmode_memory_to_ncr_used[] = {
	0x00000000,
	0x00000017,
	0x00000030,
	0x00000042,
	0x0000019d,
};

#define A_dmode_ncr_to_memory	0x00000000
u32 A_dmode_ncr_to_memory_used[] = {
	0x00000022,
	0x00000064,
	0x00000070,
	0x000000ad,
	0x000000c3,
	0x00000125,
	0x0000013e,
	0x000001cb,
};

#define A_dsa_check_reselect	0x00000000
u32 A_dsa_check_reselect_used[] = {
	0x000001bd,
};

#define A_dsa_cmdout	0x00000048
u32 A_dsa_cmdout_used[] = {
	0x00000094,
};

#define A_dsa_cmnd	0x00000038
u32 A_dsa_cmnd_used[] = {
};

#define A_dsa_datain	0x00000054
u32 A_dsa_datain_used[] = {
	0x000000bb,
};

#define A_dsa_dataout	0x00000050
u32 A_dsa_dataout_used[] = {
	0x000000a5,
};

#define A_dsa_end	0x00000070
u32 A_dsa_end_used[] = {
};

#define A_dsa_fields_start	0x00000000
u32 A_dsa_fields_start_used[] = {
};

#define A_dsa_msgin	0x00000058
u32 A_dsa_msgin_used[] = {
	0x00000188,
};

#define A_dsa_msgout	0x00000040
u32 A_dsa_msgout_used[] = {
	0x00000086,
};

#define A_dsa_msgout_other	0x00000068
u32 A_dsa_msgout_other_used[] = {
	0x00000180,
};

#define A_dsa_next	0x00000030
u32 A_dsa_next_used[] = {
	0x0000005c,
};

#define A_dsa_restore_pointers	0x00000000
u32 A_dsa_restore_pointers_used[] = {
	0x0000012e,
};

#define A_dsa_save_data_pointer	0x00000000
u32 A_dsa_save_data_pointer_used[] = {
	0x00000115,
};

#define A_dsa_select	0x0000003c
u32 A_dsa_select_used[] = {
	0x00000081,
};

#define A_dsa_status	0x00000060
u32 A_dsa_status_used[] = {
	0x00000184,
};

#define A_dsa_temp_addr_array_value	0x00000000
u32 A_dsa_temp_addr_array_value_used[] = {
};

#define A_dsa_temp_addr_dsa_value	0x00000000
u32 A_dsa_temp_addr_dsa_value_used[] = {
	0x00000003,
};

#define A_dsa_temp_addr_new_value	0x00000000
u32 A_dsa_temp_addr_new_value_used[] = {
};

#define A_dsa_temp_addr_next	0x00000000
u32 A_dsa_temp_addr_next_used[] = {
	0x00000015,
	0x0000004e,
};

#define A_dsa_temp_addr_residual	0x00000000
u32 A_dsa_temp_addr_residual_used[] = {
	0x0000002a,
	0x00000039,
};

#define A_dsa_temp_addr_saved_pointer	0x00000000
u32 A_dsa_temp_addr_saved_pointer_used[] = {
	0x00000026,
	0x00000033,
};

#define A_dsa_temp_addr_saved_residual	0x00000000
u32 A_dsa_temp_addr_saved_residual_used[] = {
	0x0000002b,
	0x00000038,
};

#define A_dsa_temp_lun	0x00000000
u32 A_dsa_temp_lun_used[] = {
	0x0000004b,
};

#define A_dsa_temp_next	0x00000000
u32 A_dsa_temp_next_used[] = {
	0x0000001a,
};

#define A_dsa_temp_sync	0x00000000
u32 A_dsa_temp_sync_used[] = {
	0x00000053,
};

#define A_dsa_temp_target	0x00000000
u32 A_dsa_temp_target_used[] = {
	0x00000040,
};

#define A_int_debug_break	0x03000000
u32 A_int_debug_break_used[] = {
	0x00000217,
};

#define A_int_debug_panic	0x030b0000
u32 A_int_debug_panic_used[] = {
	0x000001e8,
	0x000001f8,
};

#define A_int_err_check_condition	0x00030000
u32 A_int_err_check_condition_used[] = {
	0x00000194,
};

#define A_int_err_no_phase	0x00040000
u32 A_int_err_no_phase_used[] = {
};

#define A_int_err_selected	0x00010000
u32 A_int_err_selected_used[] = {
	0x000001da,
};

#define A_int_err_unexpected_phase	0x00000000
u32 A_int_err_unexpected_phase_used[] = {
	0x0000008c,
	0x00000092,
	0x0000009a,
	0x000000d0,
	0x000000d4,
	0x000000d6,
	0x000000de,
	0x000000e2,
	0x000000e4,
	0x000000ec,
	0x000000f0,
	0x000000f2,
	0x000000f4,
	0x0000014c,
};

#define A_int_err_unexpected_reselect	0x00020000
u32 A_int_err_unexpected_reselect_used[] = {
	0x000001ba,
};

#define A_int_msg_1	0x01020000
u32 A_int_msg_1_used[] = {
	0x0000010e,
	0x00000110,
};

#define A_int_msg_sdtr	0x01010000
u32 A_int_msg_sdtr_used[] = {
	0x0000016c,
};

#define A_int_msg_wdtr	0x01000000
u32 A_int_msg_wdtr_used[] = {
	0x00000160,
};

#define A_int_norm_aborted	0x02040000
u32 A_int_norm_aborted_used[] = {
	0x0000024d,
};

#define A_int_norm_command_complete	0x02020000
u32 A_int_norm_command_complete_used[] = {
};

#define A_int_norm_disconnected	0x02030000
u32 A_int_norm_disconnected_used[] = {
};

#define A_int_norm_reselect_complete	0x02010000
u32 A_int_norm_reselect_complete_used[] = {
};

#define A_int_norm_reset	0x02050000
u32 A_int_norm_reset_used[] = {
};

#define A_int_norm_select_complete	0x02000000
u32 A_int_norm_select_complete_used[] = {
};

#define A_int_test_1	0x04000000
u32 A_int_test_1_used[] = {
	0x000001fd,
};

#define A_int_test_2	0x04010000
u32 A_int_test_2_used[] = {
	0x00000215,
};

#define A_int_test_3	0x04020000
u32 A_int_test_3_used[] = {
};

#define A_msg_buf	0x00000000
u32 A_msg_buf_used[] = {
	0x00000102,
	0x0000014e,
	0x00000158,
	0x0000015e,
	0x00000164,
	0x0000016a,
};

#define A_reconnect_dsa_head	0x00000000
u32 A_reconnect_dsa_head_used[] = {
	0x0000006c,
	0x00000074,
	0x000001a0,
};

#define A_reselected_identify	0x00000000
u32 A_reselected_identify_used[] = {
	0x00000045,
	0x0000019c,
};

#define A_reselected_tag	0x00000000
u32 A_reselected_tag_used[] = {
};

#define A_schedule	0x00000000
u32 A_schedule_used[] = {
	0x0000007e,
	0x00000192,
	0x000001e2,
	0x0000021f,
};

#define A_test_dest	0x00000000
u32 A_test_dest_used[] = {
	0x000001fb,
};

#define A_test_src	0x00000000
u32 A_test_src_used[] = {
	0x000001fa,
};

#define Ent_accept_message	0x000005d4
#define Ent_cmdout_cmdout	0x0000024c
#define Ent_command_complete	0x0000060c
#define Ent_command_complete_msgin	0x0000061c
#define Ent_data_transfer	0x00000254
#define Ent_datain_to_jump	0x00000328
#define Ent_debug_break	0x00000858
#define Ent_dsa_code_begin	0x00000000
#define Ent_dsa_code_check_reselect	0x000000f8
#define Ent_dsa_code_fix_jump	0x0000003c
#define Ent_dsa_code_restore_pointers	0x000000c0
#define Ent_dsa_code_save_data_pointer	0x00000088
#define Ent_dsa_code_template	0x00000000
#define Ent_dsa_code_template_end	0x00000168
#define Ent_dsa_schedule	0x00000168
#define Ent_dsa_zero	0x00000168
#define Ent_end_data_transfer	0x0000028c
#define Ent_initiator_abort	0x00000880
#define Ent_msg_in	0x00000404
#define Ent_msg_in_restart	0x000003e4
#define Ent_other_in	0x00000374
#define Ent_other_out	0x0000033c
#define Ent_other_transfer	0x000003ac
#define Ent_reject_message	0x000005b4
#define Ent_reselected_check_next	0x000006a4
#define Ent_reselected_ok	0x00000750
#define Ent_respond_message	0x000005ec
#define Ent_select	0x000001fc
#define Ent_select_msgout	0x00000214
#define Ent_target_abort	0x00000860
#define Ent_test_1	0x000007e4
#define Ent_test_2	0x000007f8
#define Ent_test_2_msgout	0x00000810
#define Ent_wait_reselect	0x00000654
u32 LABELPATCHES[] = {
	0x00000008,
	0x0000000a,
	0x00000013,
	0x00000016,
	0x0000001f,
	0x00000021,
	0x0000004f,
	0x00000051,
	0x0000005b,
	0x00000068,
	0x0000006f,
	0x00000082,
	0x00000084,
	0x0000008a,
	0x0000008e,
	0x00000090,
	0x00000096,
	0x00000098,
	0x0000009c,
	0x0000009e,
	0x000000a0,
	0x000000a2,
	0x000000a4,
	0x000000b1,
	0x000000b6,
	0x000000ba,
	0x000000c7,
	0x000000cc,
	0x000000d2,
	0x000000d8,
	0x000000da,
	0x000000e0,
	0x000000e6,
	0x000000e8,
	0x000000ee,
	0x000000f6,
	0x000000f8,
	0x00000104,
	0x00000106,
	0x00000108,
	0x0000010a,
	0x0000010c,
	0x00000112,
	0x00000114,
	0x00000129,
	0x00000142,
	0x00000148,
	0x00000150,
	0x00000152,
	0x00000154,
	0x0000015a,
	0x00000166,
	0x00000196,
	0x000001a5,
	0x000001a8,
	0x000001ac,
	0x000001b0,
	0x000001b4,
	0x000001b8,
	0x000001cf,
	0x000001de,
	0x000001e6,
	0x000001ec,
	0x000001ee,
	0x000001f2,
	0x000001f6,
	0x00000201,
	0x00000203,
	0x00000223,
	0x00000225,
	0x00000227,
	0x00000229,
	0x0000022b,
	0x0000022d,
	0x00000231,
	0x00000235,
	0x00000237,
	0x0000023b,
	0x0000023d,
	0x00000241,
	0x00000243,
};

struct {
	u32	offset;
	void		*address;
} EXTERNAL_PATCHES[] = {
};

u32 INSTRUCTIONS	= 313;
u32 PATCHES	= 81;
u32 EXTERNAL_PATCHES_LEN	= 0;
