# NOTE: Derived from ./blib/lib/Ferret.pm.  Changes made here will be lost.
package Ferret;

sub LoadHTTP {
	my $usage = 'Usage: $data = Ferret::LoadHTTP(WEBFILE [, GET-OPTIONS])';
	@_ >= 1 && @_ <= 2 or croak $usage;
	my($addr,$opts) = @_;

	croak $usage if (ref $addr eq "Ferret");

	unless ($opts) {
		$opts  = "Connection: Keep-Alive\n";
	}

	my($http,$junk,$type,$host,$port);
	($http,$junk,$host,$port,$file) = ($addr =~ m|^(http:)?(//)?([^/:]*)?(:\d*)?(/.*)$|i);
	croak "Error: Badly formed HTTP address '$file'; stopped" unless $file;
	croak "Error: LoadHTTP cannot handle url in the form '$addr'; stopped" if ($http && $http !~ m/^http:$/i);
	$host = "localhost" unless $host;
	$port =~ s/^://;
	$port = 80 unless $port;

	use FileHandle;
	use Socket;

	my($proto,$sin,$ipaddr);

	local $SIG{ALRM} = sub { die "Error: Timeout building connection to '$addr'\n" };
	alarm ($Ferret::nettimeout/5 > 5 ? $Ferret::nettimeout/5 : 5) if $Ferret::nettimeout;
	$proto = getprotobyname('tcp');
	socket(SOCK, PF_INET, SOCK_STREAM, $proto);
	$ipaddr = inet_aton($host) || die "Error: Could not locate machine '$host'\n";
	$sin = sockaddr_in($port,$ipaddr);
	connect(SOCK,$sin) || die "Error: Could not connect to machine '$host' on port $port\n";
	alarm 0;

	local $SIG{ALRM} = sub { die "Error: Timeout waiting for data from '$addr'\n" };
	alarm $Ferret::nettimeout if $Ferret::nettimeout;
	my $delim = $/; undef $/;
	autoflush SOCK 1;
	print SOCK "GET $file HTTP/1.0\n$opts\n" || croak "Error: Could not write to socket -- $!; stopped";
	$data = <SOCK>;
	close(SOCK);
	$/ = $delim;
	alarm 0;

	die "Error: No data from server for '$addr'\n" unless $data;

	return($data);
}



1;
