# NOTE: Derived from ./blib/lib/Ferret.pm.  Changes made here will be lost.
package Ferret;

sub ResolveHTMLImages {
	my $usage = 'Usage: Ferret::ResolveHTMLImages(\$html, FROM-URL [, SHRINK [, MAX-HEIGHT]])';
	@_ >= 2 && @_ <= 4 or croak $usage;
	my($doc,$url,$shrink,$maxheight) = @_;

	croak $usage if (ref $doc ne "SCALAR");

	$imgfix = sub {
		$_ = shift;
		my($source,$height,$width);

		s/\ssrc\s*=\s*\"?([^\s\">]+)\"?//i	and $source = $1;
		s/\sheight\s*=\s*([^\s>]+)//i		and $height = $1;
		s/\swidth\s*=\s*([^\s>]+)//i		and $width	= $1;

		$source = ResolveURL($url,$source);

		if ($shrink) {
			my $reduce = $shrink;
			unless ($height && $width) {
				if (exists $Ferret::picsizes{$source}) {
					($width,$height) = split(/,/,$Ferret::picsizes{$source});
#					print "Found cached '$source' ($width x $height)\n";
				} else {
					my($head,$data);
					unless ($@) {
						if ($source =~ m/\.gif$/i) {
							$data = eval { LoadURL($source,\$head) };
							($width,$height) = GetGIFSize(\$data);
						} elsif ($source =~ m/\.(jpg|jpeg)$/i) {
							$data = eval { LoadURL($source,\$head) };
							($width,$height) = GetJPGSize(\$data);
						}
					}
					if ($height && $width) {
						$Ferret::picsizes{$source} = "$width,$height";
#						print "Cached '$source' ($width x $height)\n";
					} else {
						$Ferret::picsizes{$source} = "$maxheight,$maxheight";
#						print "Cached '$source' (??? x ???)\n";
					}
				}
			}

			if ($maxheight && $height*$reduce > $maxheight) {
				$reduce	 = $maxheight / $height;
			}
			$height = int($height * $reduce);
			$width	= int($width  * $reduce);
		}

		if ($height && $width) {
			s/\s*>$/ src="$source" height=$height width=$width>/;
		} else {
			s/\s*>$/ src="$source">/;
		}

		return $_;
	};

	$$doc =~ s/(<img\s+[^>]*?>)/&$imgfix($1)/gise;
}



###############################################################################
#
# Document display utilities
#

1;
