# NOTE: Derived from ./blib/lib/Ferret.pm.  Changes made here will be lost.
package Ferret;

sub ResolveURL {
	my $usage = 'Usage: $url = Ferret::ResolveURL(FROM-URL [, TO-URL])';
	@_ >= 1 && @_ <= 2 or croak $usage;
	my($from,$to) = @_;

	croak $usage if (ref $from eq "Ferret");

#	print "in: '$from' and '$to'\n";

	# Remove CGI arguments & tags
	$from =~ s/[?\#].*$//;

	my($ftype,$fhost,$fport,$ffile, $ttype,$thost,$tport,$tfile);
	($ftype,$fhost,$fport,$ffile) = ($from =~ m|^(\w+:)?(//[^/:]*)?(:\d+)?(.*)$|i);
	($ttype,$thost,$tport,$tfile) = ($to   =~ m|^(\w+:)?(//[^/:]*)?(:\d+)?(.*)$|i);

	$fhost =~ s!^//!!;
	$thost =~ s!^//!!;
	$ffile = "/"			unless $ffile;
	$tfile = $ffile			unless $to;
	$tfile = "/"			unless $tfile;
	$fport = ''				unless $fport;
	$tport = $fport			unless $tport && !$thost;
	$fhost = "localhost"	unless $fhost;
	$thost = $fhost			unless $thost;
	$ftype = "http:"		unless $ftype;
	$ttype = $ftype			unless $ttype;

#	print "type=$ftype, host=$fhost, port=$fport, file=$ffile -- ";
#	print "type=$ttype, host=$thost, port=$tport, file=$tfile\n";

	my $url,$file;
	if ($tfile =~ m|^/|) {
		$file = $tfile;
	} else {
		$file  = $ffile;
		$file =~ s|/[^/]+$|/|;
		$file .= $tfile;
	}
	$file =~ s|/+|/|g;
	1 while $file =~ s|/\./|/|g;
	1 while $file =~ s|/[^/]*/\.\./|/|g;

	$url  = "$ttype//$thost";
	$url .= "$tport" if ($tport);
	$url .= $file;

#	print "out: '$url'\n";
	return $url;
}



###############################################################################
#
# Document importing utilities
#

1;
