/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** fileTable.h
*/

# ifndef FILETABLE_H
# define FILETABLE_H

/*@constant int FTBASESIZE; @*/
# define FTBASESIZE 64

/* moved to fileloc.h
**    typedef int fileId;
*/

typedef enum { FILE_NORMAL, FILE_TEMP, FHEADER, FLIB, FMACROS } fileType;

typedef struct _ftentry
{
  bool     ftemp     BOOLBITS;
  bool     fsystem   BOOLBITS;
  bool     fspecial  BOOLBITS;
  cstring  fname;
  cstring  basename;
  fileType ftype;
  fileId   fder;
} *ftentry;

typedef /*@only@*/ ftentry o_ftentry;

abst_typedef /*@null@*/ struct _fileTable
{
  int nentries;
  int nspace;
  hashTable htable;
  /*@reldef@*/ /*@only@*/ o_ftentry *elements;
} *fileTable ;

/*@constant null fileTable fileTable_undefined; @*/
# define fileTable_undefined ((fileTable) NULL)

extern /*@unused@*/ /*@truenull@*/ bool 
  fileTable_isUndefined (/*@null@*/ fileTable f) /*@*/ ;
extern /*@unused@*/ /*@falsenull@*/ bool 
  fileTable_isDefined (/*@null@*/ fileTable f) /*@*/ ;

# define fileTable_isUndefined(ft) ((ft) == fileTable_undefined)
# define fileTable_isDefined(ft) ((ft) != fileTable_undefined)
extern /*@observer@*/ cstring fileTable_getName (fileTable ft, fileId fid) /*@*/ ; 
extern /*@observer@*/ cstring fileTable_getNameBase (fileTable ft, fileId fid) ; 
extern fileId fileTable_addFile (fileTable ft, cstring name)
   /*@modifies ft@*/ ;
extern fileId fileTable_addHeaderFile (fileTable ft, cstring name)
   /*@modifies ft@*/ ;
extern fileId fileTable_addTempFile (fileTable ft, fileId fid)
   /*@modifies ft@*/ ;
extern fileId fileTable_addLibraryFile (fileTable ft, cstring name)
   /*@modifies ft@*/ ;
extern fileId fileTable_addLCLFile (fileTable ft, cstring name)
   /*@modifies ft@*/ ;
extern /*@notnull@*/ /*@only@*/ fileTable fileTable_create (void) /*@*/ ;
extern fileId fileTable_lookup (fileTable ft, cstring s) /*@*/ ;
extern fileId fileTable_addCTempFile (fileTable ft, fileId fid)
   /*@modifies ft@*/ ;
extern fileId fileTable_addFileOnly (fileTable ft, /*@only@*/ cstring name)
   /*@modifies ft@*/ ;
extern fileId fileTable_addImportFile (fileTable ft, cstring name)
   /*@modifies ft@*/ ;
extern fileId fileTable_addMacrosFile (fileTable ft)
   /*@modifies ft@*/ ;
extern /*@observer@*/ cstring fileTable_getRootName (fileTable ft, fileId fid) /*@*/ ;
extern bool fileTable_isHeader       (fileTable ft, fileId fid) /*@*/ ;
extern bool fileId_isHeader (fileId f) /*@*/ ;
# define fileId_isHeader(f)          (fileTable_isHeader (context_fileTable(), f))

extern bool fileTable_sameBase (fileTable ft, fileId f1, fileId f2);
extern void fileTable_cleanup (fileTable ft) /*@modifies fileSystem@*/;
extern fileId fileTable_lookupBase (fileTable ft, cstring s) /*@modifies ft@*/ ;
extern void fileTable_printTemps (fileTable ft) /*@modifies stderr@*/ ;
extern /*@unused@*/ /*@only@*/ cstring fileTable_unparse (fileTable ft) /*@*/ ;
extern bool fileTable_exists (fileTable ft, cstring s) /*@*/ ;
extern fileId fileTable_addltemp (fileTable ft);
extern void fileTable_free (/*@only@*/ fileTable f);
extern bool fileTable_isSpecialFile (fileTable ft, fileId fid) /*@*/ ;
extern bool fileTable_isSystemFile (fileTable ft, fileId fid) /*@*/ ;

/*@-czechfcns@*/
extern /*@observer@*/ cstring fileName (fileId fid) /*@*/ ;
extern /*@observer@*/ cstring fileNameBase (fileId fid) /*@*/ ;
extern /*@observer@*/ cstring rootFileName (fileId fid) /*@*/ ;
/*@=czechfcns@*/

# define fileName(fid)     (fileTable_getName(context_fileTable(), fid))
# define fileNameBase(fid) (fileTable_getNameBase(context_fileTable(), fid))
# define rootFileName(fid) (fileTable_getRootName(context_fileTable(), fid))

# else
# error "Multiple include"
#endif

