/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
# ifndef FLAGS_H
# define FLAGS_H


typedef enum 
{
  FK_ABSTRACT, FK_ANSI, FK_BEHAVIOR, 
  FK_COMMENTS, FK_COMPLETE, FK_CONTROL, FK_DEBUG, FK_DECL,
  FK_DEF, FK_DIRECT, FK_DISPLAY, FK_EFFECT, FK_EXPORT,
  FK_EXPOSURE, FK_FORMAT, FK_GLOBAL, FK_GLOBALS, FK_HEADERS,
  FK_HELP, FK_IGNORERET, FK_INIT, FK_ITER, FK_LIBS, FK_LIMITS,
  FK_MACROS, FK_MEMORY, FK_MODIFIES, FK_NAMES, FK_NONE,
  FK_NULL, FK_OPS, FK_PRED, FK_PREPROC, FK_SECRET,
  FK_SUPPRESS, FK_SYNTAX, FK_TYPE, FK_TYPEEQ, FK_NUMBERS, 
  FK_POINTER, FK_UNRECOG, FK_USE, FK_BOOL, FK_ALIAS, 
  FK_PROTOS, FK_SPEC, 
  FK_IMPLICIT, FK_FILES, FK_ERRORS, FK_UNSPEC, 
  FK_SPEED, FK_PARAMS, FK_DEAD, 
  FK_LEAK, FK_ARRAY, FK_OBSOLETE, FK_PREFIX
} flagkind;

extern void listAllCategories (void);
extern void printAlphaFlags (void);
extern void printAllFlags (bool desc, bool full);

extern void flagcode_recordError (flagcode f);
extern void flagcode_recordSuppressed (flagcode f);
extern int flagcode_numReported (flagcode f);

extern /*@only@*/ cstring  describeFlag (cstring s);
extern flagcode identifyFlag (cstring s);
extern void setValueFlag (flagcode opt, cstring arg);
extern void setStringFlag (flagcode opt, /*@only@*/ cstring arg);

extern /*@observer@*/ cstring flagcode_name (flagcode f) /*@*/ ;
extern int flagcode_valueIndex (flagcode f) /*@*/ ;
extern int flagcode_stringIndex (flagcode f) /*@*/ ;
extern /*@observer@*/ cstring flagcode_unparse (flagcode f) /*@*/ ;
# define flagcode_unparse flagcode_name

extern /*@observer@*/ cstring flagcodeHint (flagcode f);

extern flagkind identifyCategory (cstring s) /*@*/ ;
extern void printCategory (flagkind c) /*@modifies stderr@*/ ;

extern bool flagcode_isInvalid (flagcode f);
# define flagcode_isInvalid(f) ((f) == INVALID_FLAG)

extern bool flagcode_isSkip (flagcode f);
# define flagcode_isSkip(f) ((f) == SKIP_FLAG)

extern bool flagcode_isValid (flagcode f);
# define flagcode_isValid(f) ((f) != INVALID_FLAG)

extern bool flagcode_isPassThrough (/*@sef@*/ flagcode f);
# define flagcode_isPassThrough(f) ((f) == FLG_DEFINE || (f) == FLG_UNDEFINE)

extern bool flagcode_hasValue (flagcode f);
extern bool flagcode_hasString (flagcode f);
extern bool flagcode_hasArgument (flagcode f);

/*@constant observer cstring DEFAULT_MODE;@*/
# define DEFAULT_MODE (cstring_makeLiteralTemp ("standard"))

extern void flags_initMod (void);

extern bool isMode (cstring s);
extern /*@only@*/ cstring describeModes (void);
extern void summarizeErrors (void);

extern bool flagcode_isNameChecksFlag (flagcode f);
extern bool flagcode_isIdemFlag (flagcode f);
extern bool flagcode_isModeFlag (flagcode f);
extern bool flagcode_isSpecialFlag (flagcode f);
extern bool flagcode_isGlobalFlag (flagcode f);

# else
# error "Multiple include"
# endif













