/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** uentryList.h (from slist_templace.h)
*/

# ifndef uentryLIST_H
# define uentryLIST_H

# include "indxMap.h"

abst_typedef /*@null@*/ struct _uentryList *uentryList ;

struct _uentryList
{
  int nelements;
  int nspace;
  int current;
  /*@reldef@*/ /*@relnull@*/ o_uentry  *elements;
} ;

/*@iter uentryList_elements (sef uentryList x, yield exposed uentry el); @*/
# define uentryList_elements(x, m_el) \
   { if (!uentryList_isUndefined(x) && !uentryList_isVoid(x))\
       { int m_ind; uentry *m_elements = &((x)->elements[0]); \
          for (m_ind = 0 ; m_ind < (x)->nelements; m_ind++) \
           { uentry m_el = *(m_elements++); 

# define end_uentryList_elements }}}

extern void uentryList_clear (uentryList s) /*@modifies s@*/ ;
extern int uentryList_size (uentryList s) /*@*/ ;
extern /*@only@*/ uentryList uentryList_makeMissingParams (void);

/*@constant null uentryList uentryList_missingParams; @*/
# define uentryList_missingParams uentryList_undefined

# define uentryList_makeMissingParams() uentryList_missingParams

extern /*@truenull@*/ bool uentryList_isMissingParams (uentryList s) /*@*/ ;
extern /*@truenull@*/ bool uentryList_isUndefined (uentryList s) /*@*/ ;
extern /*@unused@*/ /*@truenull@*/ bool uentryList_isEmpty (uentryList s) /*@*/ ;
extern /*@unused@*/ /*@falsenull@*/ bool uentryList_isDefined (uentryList s) /*@*/ ;

# define uentryList_isEmpty(s) (uentryList_size(s) == 0)

/*@constant null uentryList uentryList_undefined; @*/
# define uentryList_undefined      ((uentryList)0)

# define uentryList_isUndefined(c) ((c) == uentryList_undefined)
# define uentryList_isDefined(c)   ((c) != uentryList_undefined)

extern /*@notnull@*/ /*@only@*/ uentryList uentryList_new(void);
extern uentryList uentryList_add (/*@returned@*/ uentryList s, /*@keep@*/ uentry el)  /*@modifies s@*/ ;
extern /*@only@*/ uentryList uentryList_single (/*@keep@*/ uentry el) /*@*/ ;
extern /*@exposed@*/ uentry uentryList_getN (uentryList p, int n) /*@*/ ;

extern /*@unused@*/ cstring uentryList_unparseFull (uentryList s) /*@*/ ;
extern cstring uentryList_unparse (uentryList s) /*@*/ ;
extern cstring uentryList_unparseAbbrev (uentryList p) /*@*/ ;
extern cstring uentryList_unparseParams (uentryList p) /*@*/ ;

extern void uentryList_free (/*@only@*/ uentryList s) ;
extern bool uentryList_isVoid (uentryList cl) /*@*/ ;
extern /*@only@*/ uentryList uentryList_copy (uentryList s) /*@*/ ;
extern void uentryList_fixMissingNames (uentryList cl) /*@modifies cl@*/ ;

extern int uentryList_compareStrict (uentryList s, uentryList t) /*@*/ ;
extern int uentryList_compareParams (uentryList s, uentryList t) /*@*/ ;
extern int uentryList_compareFields (uentryList s, uentryList t) /*@*/ ;
extern cstring uentryList_dumpParams (uentryList s) /*@*/ ;
extern uentryList uentryList_undump (char **s) /*@modifies *s@*/ ;

extern bool uentryList_hasReturned (uentryList ul) /*@*/ ; 
extern void uentryList_advanceSafe (uentryList s) /*@modifies s@*/;
extern bool uentryList_isFinished (uentryList s) /*@*/ ;
extern void uentryList_reset (uentryList s) /*@modifies s@*/ ;
extern /*@exposed@*/ uentry uentryList_current (uentryList s) /*@*/ ;
extern int uentryList_lookupRealName (uentryList s, cstring name) /*@*/ ;
extern /*@exposed@*/ uentry 
  uentryList_lookupField (uentryList f, cstring name) /*@*/ ;
extern uentryList uentryList_mergeFields (/*@only@*/ uentryList f1, /*@only@*/ uentryList f2);
extern void uentryList_showFieldDifference (uentryList p1, uentryList p2);
extern void uentryList_convertTypeTable (uentryList p, indxMap map);
extern /*@only@*/ uentryList uentryList_undumpFields (char **s, fileloc loc);
extern /*@only@*/ cstring uentryList_dumpFields (uentryList s);
extern void uentryList_fixImpParams (uentryList cl);
extern bool uentryList_sameObject (uentryList, uentryList);
extern bool uentryList_matchFields (uentryList p1, uentryList p2);
extern bool uentryList_matchParams (uentryList p1, uentryList p2, bool force, bool arg);

# define uentryList_sameObject(s,t) ((s) == (t))

/*@constant int PRINTBREADTH;@*/
# define PRINTBREADTH 3

/*@constant int uentryListBASESIZE;@*/
# define uentryListBASESIZE MIDBASESIZE

# else
# error "Multiple include"
# endif




