#! /usr/bin/perl
#
# Common query routines
#
# Written by Behan Webster <behanw@verisim.com>
# Copyright (c) 1996 by Verisim, Inc.  All rights reserved.
#
###############################################################################


###########################################################################
### Start of User definable variables and subroutines
###########################################################################

#
# Default title description for pages
#
$title		= "Ferret";

#
# Path/File Constants
#
$helpfile   = "ferret-help.html";
$indexfile  = "ferret.index";
$imagesdir  = "images";

# search cgi constants
$sitePage	= "site.html";
$resultsIns = "<<RESULTS>>";

# Cgi script names
$advancedCgi = "advanced";
$simpleCgi   = "simple";
$powerCgi    = "power";
$loadCgi     = "load";
$searchCgi   = "search";

# Hyper-link for the Ferret on each page
$homeUrl     = "http://www.verisim.com/ferret/";

# Button bar defaults
$buttonSpacing	= "center-bar";	# Can be "center", "center-bar", "equal", or "proportional"


#
# Default user routines
#

#
# User routine to designate a label to be used for this URL
#
sub LabelForURL {
	my ($ferret, $url, $short) = @_;
	my $label = $ferret->DBGetTitle($url);

	return $label if $label;

	$url =~ s|^.*?([^/]+/?)$|$1| if $short;

	return $url;
}

#
# User routine to define a named anchor into the target page
#
sub JumpAnchor {
	my ($ferret, $url) = @_;

	return "";
}

#
# User routine to create a summary for the URL
#
sub URLDataSummary {
	my ($ferret, $url) = @_;
	return "";
}

#
# User routine to define whether post processing should occur
# on the data this URL points to
#
sub URLNeedsPostProcessing {
	my ($ferret, $url) = @_;
	return 0;
}


#
# Colors
#
$foundText   = "#FF0000";
$bgcolor     = "#EEEEEE";


#
# Print the content type and figure out the command name
#
($cmd) = ( $0 =~ m|^.*?([^/]+)$| );
contentHTML() if $cmd ne $loadCgi;

#
# Read in config file and the Ferret routines
#
readConfig("query.conf");
use Ferret;


#
# Pictures
#
$textBack    = "$imagesdir/paper.gif" if !$textBack;
$background  = "$imagesdir/paperfer.gif" if !$background;

# General images
$up      = qq{src="$imagesdir/up.gif" width=17 height=17 border=0 alt="[up]"} if !$up;
$down    = qq{src="$imagesdir/down.gif" width=17 height=17 border=0 alt="[down]"} if !$down;
$qerror  = qq{src="$imagesdir/questfer.gif" width=110 height=110 border=0 alt="Error"} if !$qerror;
$moregif = qq{src="$imagesdir/more.gif" width=68 height=17 border=0 alt="[more terms]"} if !$moregif;

# Bullets
$star1 = qq{src="$imagesdir/star1.gif" width=32 height=17 border=0 alt="    *"} if !$star1;
$star2 = qq{src="$imagesdir/star2.gif" width=32 height=17 border=0 alt="   **"} if !$star2;
$star3 = qq{src="$imagesdir/star3.gif" width=32 height=17 border=0 alt="  ***"} if !$star3;
$star4 = qq{src="$imagesdir/star4.gif" width=32 height=17 border=0 alt=" ****"} if !$star4;
$star5 = qq{src="$imagesdir/star5.gif" width=32 height=17 border=0 alt="*****"} if !$star5;

# Logos
$advancedLogo = qq{src="$imagesdir/advanced.gif" width=99 height=96 border=0 alt="Ferret"} if !$advancedLogo;
$simpleLogo   = qq{src="$imagesdir/simple.gif" width=99 height=96 border=0 alt="Ferret"} if !$simpleLogo;
$powerLogo    = qq{src="$imagesdir/power2.gif" width=135 height=226 border=0 alt="Ferret"} if !$powerLogo;

# Forms
%formGraphics = (
#	'form'				=>	"";
#	'/form'				=>	"";
	'checkbox'			=>	qq{<img src="$imagesdir/chku-w95.gif" width=23 height=22 }.
							qq{border=0 alt="[ ] " align=absmiddle>},
	'checkbox-checked'	=>	qq{<img src="$imagesdir/chkc-w95.gif" width=23 height=22 }.
							qq{border=0 alt="[x] " align=absmiddle>},
#	'hidden'			=>	"";
#	'image'				=>	qq{<img src="$imagesdir/subm-w95.gif" width=82 height=30 }.
#							qq{border=0 alt="[Submit]" align=absmiddle>},
	'password'			=>	qq{<img src="$imagesdir/pswd-w95.gif" width=127 height=24 }.
							qq{border=0 alt="[**********]" align=absmiddle>},
	'radio'				=>	qq{<img src="$imagesdir/rbtu-w95.gif" width=20 height=18 }.
							qq{border=0 alt="( ) " align=absmiddle>},
	'radio-checked'		=>	qq{<img src="$imagesdir/rbtc-w95.gif" width=20 height=18 }.
							qq{border=0 alt="(o) " align=absmiddle>},
	'reset'				=>	qq{<img src="$imagesdir/rset-w95.gif" width=44 height=18 }.
							qq{border=0 alt="[Reset]" align=absmiddle>},
	'select'			=>	qq{<img src="$imagesdir/slct-w95.gif" width=120 height=21 }.
							qq{border=0 alt="[Select]" align=absmiddle>},
	'submit'			=>	qq{<img src="$imagesdir/subm-w95.gif" width=48 height=18 }.
							qq{border=0 alt="[Submit]" align=absmiddle>},
	'text'				=>	qq{<img src="$imagesdir/text-w95.gif" width=127 height=24 }.
							qq{border=0 alt="[__________]" align=absmiddle>},
	'textarea'			=>	qq{<img src="$imagesdir/area-w95.gif" width=161 height=63 }.
							qq{border=0 alt="[__________]" align=absmiddle>},
) if !%formGraphics;


###########################################################################
### End of User definable variables and subroutines
###########################################################################


###########################################################################
# Print html content type
#
sub contentHTML {
	print "Content-type: text/html\n\n" if $cmd ne $loadCgi;
}


###########################################################################
# Read in config file
#
sub readConfig {
	my ($conffile) = @_;
	my $setup;

	# Read in config file
	my $eol = $/;
	undef $/;
	open(FILE, "$conffile") || return;

	# slurp in the file
	$setup = <FILE>;
	close(FILE);

	# restore the end of line character
	$/ = $eol;

	# run the setup file
	eval $setup;

	if ($@) {

	title("Config File Error");
	my $err = $@;
	$err =~ s/\n/<br>\n/g;

print qq{
<body>
<h1>Error in config file $conffile</h1>
<h2>$err</h2>
<h3>Please contact the administrator of this website about this problem</h3>
</body>
};

	end();

	exit;

	}
}


###########################################################################
# Split up key pairs from form get/post
#
sub splitPairs {
	my ($buffer) = @_;
	my (@pairs, $pair, $name, $value);

	@pairs = split(/&/, $buffer);

	foreach $pair (@pairs)
	{
	    ($name, $value) = split(/=/, $pair);

	    # Un-Webify plus signs and %-encoding
	    $value =~ tr/+/ /;
	    $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;

	    # Uncomment for debugging purposes
		#print "\n\nSetting $name to $value<P>";

	    $FORM{$name} = $value;
	}
}


###########################################################################
# Print html file header
#
sub title {
	my ($usertitle) = @_;

print qq{
<html>
<head>
  <title>$title $usertitle</title>
</head>
};

}


###########################################################################
# Put in a background graphic/color
#
sub background {
	my ($back, $color) = @_;

	my $body = qq{<body};
	$body   .= qq{ background="$back"} if $back;
	$color = $bgcolor if !$color;
	$body   .= qq{ bgcolor=$color>\n};

	print $body;
}


###########################################################################
# Finish it off
#
sub end {

print qq{
</html>
};

}


###########################################################################
# Display an HTML file
#
sub filePage {
	my ($file) = @_;

	open(FILE, $file);
	print <FILE>;
	close(FILE);
}


###########################################################################
# Armor phrase to be sent in a URL
#
sub armorURL {
	$_ = join(' ', @_) if @_;

	s/%/%25/g;	# This must be done first
	s/\t/%09/g;
	s/ /%20/g;
	s/"/%22/g;
	s/#/%23/g;
	s/&/%26/g;
	s/\+/%2b/g;
	s/=/%3d/g;
	s/\?/%3f/g;
	s/\\/%5c/g;

	return $_;
}


###########################################################################
# Unarmor phrase that came from a URL
#
sub unarmorURL {
	$_ = join(' ', @_) if @_;

	s/\\([^\\])/$1/g;
	s/\\\\$/\\/;

	return $_;
}


###########################################################################
# Print the button bar
#
#$buttonSpacing  = "center"; # Can be "center", "equal", or "proportional"
sub buttonBar {
	my ($url, $button, $text);

	# See if there are any buttons to display
	return if (!@buttons);

	my $width = int(100/($#buttons+1));

	print "<center>\n";

	if ($buttonSpacing =~ /^(equal|proportional)$/io) {
		print "<table border=0 cellpadding=0 cellspacing=0 width=100%>\n";
		print "<tr align=center>\n\n";
	}

	while (@buttons) {
		$url    = shift @buttonUrl;
		$button = shift @buttons;
		$text   = shift @buttonText;

		print "  <td width=$width%>\n" if $buttonSpacing =~ /^equal$/io;
		print "  <td>\n" if $buttonSpacing =~ /^proportional$/io;

		print "    <a href=\"$url\" target=_top><nobr>\n";
		print "    <img $button align=absmiddle>\n";
		print "    $text</nobr></a>\n";

		print "  </td>\n\n" if $buttonSpacing =~ /^(equal|proportional)$/io;

		print "  &nbsp|&nbsp\n" if @buttons && $buttonSpacing =~ /^center-bar$/io;

	}

	print "</tr>\n</table>\n" if $buttonSpacing =~ /^(equal|proportional)$/io;

	print "</center>\n";

}


###########################################################################
# The advanced/simple set of frames
#
sub queryFrames {
	my ($cgi, $form, $query, $oldquery) = @_;
	my $defnum  = ($number > 0) ? $number : "all";
	$oldquery =~ s/\"/&quot;/g;

	my $frame1 =            "$cgi?2+$page+$display+$defnum+$oldquery";
	my $frame2 = ($query) ? "$cgi?3+$page+$display+$defnum+$oldquery" : "$cgi?5";
	my $frame3 =            "$cgi?6";

    if (@buttons) {

print qq{
<frameset rows="28%, *, 43">
  <frame src="$frame1" name=query scrolling=no>
  <frame src="$frame2" name=results>
  <frame src="$frame3" name=buttons scrolling=no marginheight=0 marginwidth=0>
</frameset>

<noframes>
};

	} else {

print qq{
<frameset rows="28%, *">
  <frame src="$frame1" name=query scrolling=no>
  <frame src="$frame2" name=results>
</frameset>

<noframes>
};

	}

	#
	# Just in case for some bizarre reason they all of a
	# sudden don't have frames.
	#
	eval "$form(1,qq{$query});";
	print "<hr>\n";
	buttonBar();

print qq{
</noframes>
};

}


###########################################################################
# The advanced query form
#
sub advancedQueryForm {
	my ($frame, $query) = @_;

	my $summary = "selected" if $display =~ /^s/io;
	my $jump    = "selected" if $display =~ /^j/io;
	my $compact = "selected" if $display =~ /^c/io;
	my $defnum  = ($number > 0) ? $number : "all";
	my $target  = "target=results"  if $frame > 1;
	my $simpframe = ($frame == 1) ? 0 : 2;

	$query		=~ tr/+/ /s;
	$query		=~ tr/\\//d;
    $query		=~ s/\"/&quot;/g;

	background($textBack);

print qq{
<center><form action="$advancedCgi" method=get $target>
  <a href="$homeUrl" target=_top>
  <img $advancedLogo align=left>
  </a>
  <input type=hidden name=f value=$frame>
  <input type=text name=q size=30 maxlength=200 value="$query">
  <input type=hidden name=p value=1>
  <input type=submit value=Submit>
  <input type=reset  value=Clear>
  <input type=submit value=Help name=help>
  <br><nobr>Display results as
  <select name=d>
    <option value=s $summary> summary list
};

print qq{
    <option value=j $jump> jump list
} if $frame > 1;

print qq{
    <option value=c $compact> compact list
  </select></nobr>
  <nobr>Show
  <input type=text name=n value="$defnum" size=5 maxlength=10>
  entries at once.</nobr>

  <br><center>
    <a href="$simpleCgi?$simpframe">simple search</a>
	&nbsp;&nbsp;
    <a href="$powerCgi" target=_top>power search</a>
	&nbsp;&nbsp;
  	<font color=#555555>advanced search</font>
  </center>
</form></center>
};

}


###########################################################################
# Print the title page
#
sub titlePage {
	my( $display ) = @_;

	title("Title Page");
	background($background);

print qq{
  <br><br>
  <center>
    <h1>Search the <i>$title</i> pages</h1>
  </center>
};

}


###########################################################################
# Print the error page
#
sub errorPage {
	my ($query, $error) = @_;

	background($textBack);
	$error =~ s/\n/<br>\n/g;

print qq{
<img $qerror align=left>
<center>
  <br>
  <h1>There was a problem with the query:</h1>
  <h1>$query</h1>
  <h2>$error</h2>
</center>
};

}


###########################################################################
# Print kind of results being displayed
#
sub resultsTitle($display) {
	my $rt;

	if ($display =~ /^s/io) {
		$rt = "Summary";
	} elsif ($display =~ /^c/io) {
		$rt = "Compact";
	} else {
		return;
	}

	print "<center><h2>$rt Results List</h2></center>\n";
}


###########################################################################
# Print page number and number of results
#
sub pageNumber {
	my($page, $number, $results) = @_;

	my $start = ($number <= 0) ? 1 : ($page-1)*$number+1;
	my $end   = $start+$number-1;
	   $end   = $results if $end > $results | $number <= 0;

print qq{
<nobr>Entries $start-$end</nobr> <nobr>out of $results results</nobr><br><br>
};

}


###########################################################################
# Allow the user to go to the previous results in the list
#
sub prevPage {
	my($cgi, $frame, $page, $display, $number, $query) = @_;

	if ($page > 1 & $number > 0) {
		$frame = 4 if $frame != 1;
		$page--;

print qq{
<nobr><a href="$cgi?$frame+$page+$display+$number+$query"><img $up>
  previous $number results </a></nobr><br><br>
};

	}
}


###########################################################################
# Allow the user to go to the next results in the list
#
sub nextPage {
	my($cgi, $frame, $page, $display, $number, $query, $results) = @_;

	my $numpages = ($number <= 0) ? 1 : ($results+$number)/$number;
	if ($numpages > 1) {
		$frame = 4 if $frame != 1;
		$results = $number if $results > $number;
		$page++;

		print "<br>" if $display ne "s";

print qq{
<nobr><a href="$cgi?$frame+$page+$display+$number+$query"><img $down>
  next $results results </a></nobr>
};

	}
}


###########################################################################
# Open the index file
#
sub openIndex {
	my $search = new Ferret;
	eval { $search->Open($indexfile) };

	if ($@) {
		my $err = $@;
		$err =~ s/\n/<br>\n/g;

print qq{
<center>
  <br>
  <h1>There was a problem opening the database:</h1>
  <h2>$err</h2>
</center>
</html>
};

	exit;
	}

	return $search;
}


###########################################################################
# Interpret the score returned by the search engine
#
sub rank {
	my ($score) = @_;
	my ($bullet);

	if      ($score < 20) { $bullet = $star1;
	} elsif ($score < 40) { $bullet = $star2;
	} elsif ($score < 60) { $bullet = $star3;
	} elsif ($score < 80) { $bullet = $star4;
	} else                { $bullet = $star5;
	}

	return "<img $bullet>";

}


###########################################################################
# Process one result for a list page
#
sub processResult {
	($result, $words) = @_;

	#
	# Extract info from result
	#
	my ($score, $url) = ($result =~ m|^([0-9]*) (.*)$|);
	my $bullet = rank($score);

	#
	# See if we need to generate the data at the URL or not
	#
	my ($topurl, $selfurl);
	if (URLNeedsPostProcessing($search, $url)) {
		$_       = armorURL($url);
		$topurl  = "$loadCgi?1+$words+$_";
		$selfurl = "$loadCgi?0+$words+$_";
	} else {
		$topurl = $url;
		$selfurl = $url;
	}

	#
	# See if we should jump to a named anchor in the URL
	#
	my $anchor = JumpAnchor($search, $url);
	if ($anchor) {
		$topurl  .= "#$anchor";
		$selfurl .= "#$anchor";
	}

	return ($bullet, $url, $topurl, $selfurl);
}


###########################################################################
# Get the summary of the data at the URL
#
sub getSummary {
	my ($url) = @_;
	my ($summary);

	#
	# Get the file summary
	#
	$summary = URLDataSummary($search, $url);
	$summary = $search->GetSummary("$url") if !$summary;

	#
	# Convert/disable summarized forms
	#
    Ferret::ChangeHTMLForm(\$summary, \%formGraphics);

	return $summary;
}


###########################################################################
# Display the summary list (default)
#
sub summaryList {
	my ($frame, $query) = @_;
	my ($num, $bullet, $url, $topurl, $selfurl, $label, $summary);
	my $words = armorURL( join(':', Ferret::QueryWords($query)) );

print qq{
<dl>
};

	$num = ($number > 0) ? $number : $#results+1;
	for (1..$num) {
		last if (!@results);
		($bullet, $url, $topurl, $selfurl) = processResult( shift @results, $words);
		$label = LabelForURL($search, $url);
		$summary = getSummary($url);
		Ferret::MarkHTMLWords(\$summary, "<font color=$foundText>", "</font>",
			Ferret::QueryWords($query));

print qq{
<!------------------------------------------------------------------------>
<dt><nobr><a href="$topurl" target=_top>$bullet</a>
  <a href="$selfurl" target=_self>$label</a></nobr><dd>
<font size=-1><ul>
$summary
</ul></font><br clear=all><hr size=1>
};

	}

print qq{
</dl>
};

}


###########################################################################
# Display the compact list
#
sub compactList {
	my ($frame, $query) = @_;
	my ($num, $bullet, $url, $topurl, $selfurl, $label);
	my $words = armorURL( join(':', Ferret::QueryWords($query)) );

	$num = ($number > 0) ? $number : $#results+1;
	for (1..$num) {
		last if (!@results);
		($bullet, $url, $topurl, $selfurl) = processResult( shift @results, $words);
		$label = LabelForURL($search, $url);

print qq{
<nobr><a href="$topurl" target=_top>$bullet</a>
  <a href="$selfurl" target=_self>$label</a></nobr><br>
};

	}
}


###########################################################################
# The jump list frameset
#
sub jumpFrame {
	my ($cgi, $form, $query, $oldquery) = @_;
    $oldquery =~ s/\"/&quot;/g;

print qq{
<frameset cols="25%,*">
  <frame src="$cgi?4+$page+$display+$number+$oldquery" name=jump >
  <frame src="$cgi?5" name=view>
</frameset>

<noframes>
};

	#
	# Just in case for some bizarre reason they all of a
	# sudden don't have frames.
	#
	eval "$form(1,qq{$query});";
	print "<hr>\n";
	buttonBar();

#  <meta http-equiv=refresh content="0; URL=$cgi?0+$display+$page+$number+$query">
#  Wait a second.  Your browser had frame capabilities a second ago.
#  Try this <a href="$cgi?0+$display+$page+$number+$query">url</a> instead.

print qq{
</noframes>
};

}


###########################################################################
# Display the jump list
#
# NOTE: This is only available inside a frame
#
sub jumpList {
	my ($query) = @_;
	my ($num, $bullet, $url, $topurl, $selfurl, $label);
	my $words = armorURL( join(':', Ferret::QueryWords($query)) );


	$num = ($number > 0) ? $number : $#results+1;
	for (1..$num) {
		last if (!@results);
		($bullet, $url, $topurl, $selfurl) = processResult( shift @results, $words);
		$label = LabelForURL($search, $url, 1);

print qq{
<nobr><a href="$topurl" target=_top>$bullet</a>
  <a href="$selfurl" target=view>$label</a></nobr><br>
};

	}
}


###########################################################################
# Print the results of the query
#
sub resultsPage {
	my ($frame, $page, $query, $oldquery, $cgi, $form) = @_;

	#
	# Set to defaults if these are undefined
	#
	$display = "s"  if (!$display | !$query);
	$number  = -1   if $number =~ /(all|ALL|\*)/;
	$page    =  1   if !$page | $number <= 0;
	$number  = 15   if !$number | $number =~ /^$/ | $number !~ /[0-9]/;

	#
	# Print the title page to fill the frame
	#
	if ($frame == 5) {
		titlePage();
		exit;
	}

	#
	# Print the button bar at the bottom of the page
	#
	if ($frame == 6) {
		title("Button Bar");
		background($textBack);
		buttonBar();
		exit;
	}

	#
	# Print help file if it's been requested
	#
	if ($FORM{'help'}) {
	    filePage($helpfile);
	    exit;
	}

	#
	# Print html file header
	#
	title("Query");

	#
	# Print the overall frameset/noframes page
	#
	if (!$frame) {
		queryFrames($cgi, $form, $query, $oldquery);

	#
	# Just print the query form by default if no options were specified
	#
	} elsif ($frame == 2) {
		eval "$form(3,qq{$oldquery});";

	#
	# If frames are enabled, and jump list is selected, create the frameset
	#
	} elsif ($frame == 3 && $display =~ /^j/io) {
		jumpFrame($cgi, $form, $query, $oldquery);

	#
	# Query the search engine
	#
	} else {
		#
		# Put in correct background
		#
		background($textBack);

		#
		# If there are no frames, print out the query form again
		#
		if ($frame == 1) {
			eval "$form($frame,qq{$oldquery});";
			print "<hr>\n";
		}

		#
		# Perform the query
		#
		$search  = openIndex();
		@results = $search->Query($query);

		#
		# See if the query failed
		#
		if ($@) {
			errorPage($query, $@);

		} else {
			#
			# Print kind of output
			#
			resultsTitle($display);

			#
			# Print page number and number of results
			#
			pageNumber($page, $number, $#results+1);

			#
			# Skip the first pages
			#
			for(1..($page-1)*$number) {
				shift @results;
			}

			#
			# Allow the user to go to the previous results in the list
			#
			prevPage($cgi, $frame, $page, $display, $number, $oldquery);

			#
			# Display the jump list
			#
			if ($display =~ /^j/io) {
				jumpList($query);

			#
			# Display the compact list
			#
			} elsif ($display =~ /^c/io) {
				compactList($frame, $query);

			#
			# Display the summary list (default)
			#
			} else { # $display="s" is the default
				summaryList($frame, $query);
			}

			#
			# Allow the user to go to the next results in the list
			#
			nextPage($cgi, $frame, $page, $display, $number, $oldquery, $#results+1);

		}

		#
		# If there are no frames, print out the button bar
		#
		if ($frame == 1) {
			print "<hr>\n";
			buttonBar();
		}
	}

	#
	# Finish it off
	#
	end();
}

1;
