# NOTE: Derived from ./blib/lib/Ferret.pm.  Changes made here will be lost.
package Ferret;

sub GetJPGSize {
	my $usage = 'Usage: Ferret::GetJPGSize(\$jpeg)';
	@_ == 1 or croak $usage;
	my($jpeg) = @_;

	croak $usage if (ref $jpeg ne "SCALAR");

	my($c1,$c2,$len);
	my $jpos = 0;
	my $jlen = length $$jpeg;

	my $next_byte = sub {
		my $byte = substr($$jpeg,$jpos++,1);
		my @bval = unpack("C",$byte);
		return $bval[0];
	};

	my $next_word = sub {
		my $b1 = &$next_byte();
		my $b2 = &$next_byte();
		return $b1 * 256 + $b2;
	};

	$c1 = &$next_byte();
	$c2 = &$next_byte();
	return if $c1 != 255 || $c2 != 216;	# first marker must be SOI

	while ($jpos < $jlen) {
		$c1 = &$next_byte();
		next if $c1 == 255;

		return if $c1==217 || $c1==218;	# stop at SOS or EOI

		if ($c1 >= 192 && $c1 <= 207) {
			if ($c1 != 196 && $c1 != 200 && $c1 != 204) {
				my($w,$h);
				   &$next_word();	# length
				   &$next_byte();	# precision
				$h=&$next_word();	# height
				$w=&$next_word();	# width
				return ($w,$h);
			}
		}

		$len = &$next_word();
		return if $len < 2;
		$len -= 2;
		while ($len--) { &$next_byte(); }
	}

	return;
}



1;
