# NOTE: Derived from ./blib/lib/Ferret.pm.  Changes made here will be lost.
package Ferret;

sub LoadURL {
	my $usage = 'Usage: $data = Ferret::LoadURL(URL, \$results [, FILTERFLAG])';
	@_ >= 2 && @_ <= 3 or croak $usage;
	my($url,$head,$dofilt) = @_;

	croak $usage if (ref $url eq "Ferret");
	croak $usage if (ref $head ne "SCALAR");

	my($file,$data,$filt);
	$@="";

	if ($url =~ m/^file:(.*)$/i) {
		$file = $1;
		$filt = StdExtFilters($file) if $dofilt;
		$$head= "";
		return LoadFile($file,$filt);
	} elsif ($url =~ m/^(http:)?(.*)$/i) {
		$file =	 $2;
		$data =	 LoadHTTP($file);
		$data =~ s/^(.*?\n)\s*\n//s;
		$$head=	 $1;
		$$head=~ s/\r//g;

		my($rnum,$rmsg) = ($$head =~ m/^HTTP\S*\s+(\d+)\s+(.*?)$/im);
		croak "Load $url failed: $rnum $rmsg; stopped" if ($rnum != 200);
	} else {
		croak "Error: Unsupported/unknown URL '$url'; stopped";
	}

	if ($dofilt) {
		$filt = StdExtFilters($file);
		FilterData(\$data,$filt) if ($filt);
	}

	return $data;
}



###############################################################################
#
# Remote Queries
#
1;
