#! /bin/sh

me=`basename $0`

usage() {
    >&2 echo $me "[ --srcdir directory ] file-or-name ..."
    exit 1
}

src=.

while [ $# -ne 0 ]
do
    case "$1" in
	--srcdir)
	    test $# -gt 1 || usage
	    src="$2"
	    shift
	    ;;
	-*)
	    usage
	    ;;
	*)
	    break
	    ;;
    esac
    shift
done

if [ $# -eq 0 ]
then
    usage
fi

if [ -x ../debian/apachemodname ]
then
    apachemodname=../debian/apachemodname
else
    apachemodname=/usr/sbin/apachemodname
fi

cat <<EOF

# LoadModule: This is how one can dynamically load an Apache module
# at run time.
# LoadFile: Loads a file (without a module name)
#
# These directives cannot be used if your system does not provide
# dynamic linking.
#
# The way lines are commented here is used by the Debian package
# installation procedure: if a line is commented starting with a #+
# or #- the user will be asked if she wants the module, otherwise (no
# non-letter non-blank sign after the #) she will not. This means that
# the sample conf. file will use such hashes.
#
# Please keep this LoadModule: line, here, it is needed for installation.

EOF

for i
do
    what=$src/`echo $i | sed 's/\.[^.]*//'`.c
    modname=`sh $apachemodname $what`
    echo "#-LoadModule $modname '/usr/lib/apache/$i.so'"
done

echo

