
#
# apache.sh
#
# This loads variables and functions needed for Apache configuration.
#
# Yves Arrouye <arrouye@debian.org>
#

_apache_sh_failed=0

: ${apacheconfig:=/usr/lib/apache/config}

for f in functions.sh variables.sh file.sh interact.sh
do
    if [ -r ${apacheconfig}/$f ]
    then
	. ${apacheconfig}/$f
    else
	_apache_sh_failed=1
    fi
done

_apache_sh_testloaded() {
    if [ $_apache_sh_failed -ne 0 ]
    then
	if [ "$1" = --noname ]
	then
	    >&2 echo Problems encountered while initializing, aborting
	else
	    >&2 echo $me: problems encountered while initializing, aborting
	fi
	exit 2
    fi
    return $_apache_sh_failed
}

