
#
# functions.sh
#
# These are functions used by the Apache configuration scripts.
#
# Yves Arrouye <arrouye@debian.org>
#

# Various filename-manipulation functions.

unbundledfilename() {
    _fname=`echo "$1" | sed -e 's/\\\\/\\\\\\\\/g' -e 's/\\\\"/\\\\021/g' \
	-e 's/"\([^"]*\)".*/\1/' -e 's/\\\\021/"/g' -e 's/\\\\\\\\/\\\\/g'`
    if [ "$_fname" = "$1" ]
    then
	_fname=`echo "$1" | sed -e 's/\\\\/\\\\\\\\/g' \
	    -e "s/\\\\\\\\'/\\\\\\\\023/g" \
	    -e "s/'\\([^']*\\)'.*/\\1/" -e "s/\\\\\\\\023/'/g" \
	    -e 's/\\\\\\\\/\\\\/g'`
    fi
    echo "$_fname"
    unset _fname
}

quotedfilename() {
    echo "$1" | sed "s/'/\\\\'/g"
}

apachefilename() {
    _fs="`filenameserver \"$1\"`"
    echo "'`quotedfilename \"$_fs\" | sed \"s/'/\\\\'/g\"`'"
}

serverfilename() {
    for _f
    do
	echo "$_f" | sed "s,^\([^/]\),$serverroot\\1,"
    done
}

filenameserver() {
    for _f
    do
	echo "$_f" | sed "s,^$serverroot,,g"
    done
}

httplinefilename() {
    _file=`echo "$2" | sed -n "s,^[    ]*$1[   ]*\\([^  ]*\\)[   ]*,\\1,p" |
	tail -1`
    if [ ! -z "$_file" ]
    then
        serverfilename `unbundledfilename $_file`
    fi
    unset _line _file
}

httpfilepath() {
    _file=`2>/dev/null \
	sed -n "s,^[    ]*$1[   ]*\\([^  ]*\\)[   ]*,\\1,p" "$2" | tail -1`
    : ${_file:=$3}
    unbundledfilename $_file
}

httpfilename() {
    _file=`2>/dev/null \
	sed -n "s,^[    ]*$1[   ]*\\([^  ]*\\)[   ]*,\\1,p" "$2" | tail -1`
    : ${_file:=$3}
    serverfilename `unbundledfilename $_file`
}

# Name of module file.

modulefilename() {
    for _f
    do
	if eval test -z \"\$module_$_f\"
	then
	    echo /usr/lib/apache/modules/$_f.so
	else
	    eval "echo \$module_$_f"
	fi
    done
    unset _f _name
}

