
#
# interact.sh
#
# These are functions used by scripts.
#
# Yves Arrouye <arrouye@debian.org>
#

# Echo without starting a new line.
    
if [ "`echo -n a`" = "-na" ]
then     
    echon() {
        echo "$@\c"       
    }
else                     
    echon() {    
        echo -n "$@"
    }
fi                 

# Ask a simple question.

yorn() {
    _answers='y or n'

    if [ "$1" = -h ]
    then
	_help="$2"
	shift 2
	_answers='y, n, or either h or ? for help'
    fi

    _def="[$1]"

    _prompt="$2"
    _again="$3"

    : ${_again:="$_prompt"}

    boolean_answer=

    until [ ! -z "$boolean_answer" ]
    do
	echon "$_prompt" "$_def "
	read _ans
	case "$_ans" in
	    "")
		boolean_answer="$1"
		;;
	    y|Y)
		boolean_answer=y
		;;
	    n|N)
		boolean_answer=n
		;;
	    h|H|\?)
		if [ ! -z "$_help" ]
		then
		    boolean_answer=h
		    if [ -r "$_help" ]
		    then
		    	sed 's/^/    /' "$_help" | $PAGER
		    else
			echo 'Sorry, no help is available...'
		    fi
		fi
		;;
	esac
	if [ -z "$boolean_answer" ]
	then
	    echo "Please answer $_answers."
	    _prompt="$_again"
	else
	    if [ "$boolean_answer" = h ]
	    then
		boolean_answer=
	    fi
	fi
    done

    unset _def _prompt _again _help _answers
}

