
#
# variables.sh
#
# These are variables used by the Apache configuration scripts.
#
# Yves Arrouye <arrouye@debian.org>
#

# Temporary directory to use, path to look for Apache modules.

: ${TMPDIR:=/tmp}
: ${APACHE_MODULES_PATH:=/usr/local/lib/apache:/usr/lib/apache}

# Apache file names.

: ${httpd=/etc/apache/httpd.conf}

_wwwdata=`2>/dev/null grep ^www-data: /etc/passwd`
if [ -z "$_wwwdata" ]
then
    dflt_serverroot=`echo "$_wwwdata" | cut -d: -f6`
fi
unset _wwwdata

: ${dflt_serverroot:=/home/www-data/webspace}

conf_serverroot="`httpfilename ServerRoot ${httpd} ''`"
: ${serverroot:=$conf_serverroot}
: ${serverroot:=$dflt_serverroot}

srm="`httpfilename ResourceConfig ${httpd} /etc/apache/srm.conf`"
access="`httpfilename AccessConfig ${httpd} /etc/apache/access.conf`"

# Magic line for processing of LoadModule directives, if needed.

loadmodulemagicline='# Please keep this LoadModule: line, here, it is needed for installation.'

# Predefined modules.

predefined=' @predefined@ '

