#!	/bin/bash

set -e
# set -v
# set -x
version=1_2

umask 022

if [ $# != 1 ]; then
	echo "Usage:	"$0 "debian-archive-directory" 1>& 2
	cat 1>&2 << EOF

	Creates a new base archive.

	debian-archive-directory: the local copy of the Debian archive.

	Warning: If there is more than one version of each package in the
	base archive, the one that comes out last (highest) in an
	numeric-then-alphabetic sort will be used.

EOF
	exit -1;
fi

last () {
	eval 'echo $'$#''
}

(modprobe floppy; exit 0)

make_paths() {
	exit=false
	local PATHS=""
	for i in $*; do
		p=`last $archive/${i}_[^a-zA-Z]*.deb`
		if [ ! -f $p ]; then
			echo "Can't find package" $p 1>& 2
			exit=true
		fi
		PATHS=$PATHS" "$p
	done
	echo $PATHS
	if $exit; then
		exit -1
	fi
}

# Set this to the location of the package archive.
archive=$1

# To build a rootdisc for an other architecture we need the name
arch="`dpkg --print-architecture`"

# Temporary directories
B=/var/tmp/base-tmp-$$
P=/var/tmp/partial-tmp-$$

# The home of the scripts used by this script.
scripts=`pwd`/scripts/basedisks

exit=false

for i in $archive/Packages.gz $scripts/PACKAGES_all $scripts/PACKAGES_${arch} \
 $scripts/PARTIAL_PACKAGES_all $scripts/PARTIAL_PACKAGES_${arch}; do
	if [ ! -f $i ]; then
		echo "Can't open $i"
		exit=true
	fi
done
if $exit; then
	exit -1;
fi

# Expand the package names into full pathnames.
PACKAGE_PATHS=`make_paths \`cat $scripts/PACKAGES_all \
 $scripts/PACKAGES_${arch}\``
PARTIAL_PACKAGE_PATHS=`make_paths \`cat $scripts/PARTIAL_PACKAGES_all \
 $scripts/PARTIAL_PACKAGES_${arch}\``

if $exit; then
	exit -1;
fi

rm -f -r $B $P # Paranoia.

for i in $PACKAGE_PATHS; do
	# echo Extracting $i 1>&2
	dpkg-deb --extract $i $B
done

for i in $PARTIAL_PACKAGE_PATHS; do
	# echo Extracting $i 1>&2
	dpkg-deb --extract $i $P
done

(cd $P; tar -cf - `cat $scripts/PARTIAL_PACKAGE_FILES_all \
 $scripts/PARTIAL_PACKAGE_FILES_${arch}`) \
 |(cd $B;tar xvlpf -)

gzip -d < $archive/Packages.gz > $B/var/lib/dpkg/available

# Miscellaneous links normally done by the postinst scripts.
if [ ! -f $B/etc/ld.so.cache ]; then
	cp /etc/ld.so.cache $B/etc/ld.so.cache
	chmod 644 $B/etc/ld.so.cache
	chown root.root $B/etc/ld.so.cache
fi

if [ "$arch" = "m68k" ]; then
  #Until now linux-m68k has no fdisks in util-linux.deb
  #I've only a beta version for atari und amiga from the
  #programmer.
  cp /sbin/fdisk /sbin/cfdisk /sbin/atari-fdisk /sbin/afdisk $B/sbin
  #and same devices are missing in base.deb
  cp -a /dev/atarimouse /dev/amigamouse /dev/fb0* /dev/ad* $B/dev
fi

if [ ! -f $B/lib/ld-linux.so.1 ]; then
	(cd $B/lib; ln -s ld-linux.so.1.* ld-linux.so.1)
fi

if [ ! -f $B/usr/bin/perl -a -f $B/usr/bin/perl.dist ]; then
	(cd $B/usr/bin; mv perl.dist perl)
fi
(cd $B/bin; ln -s ../usr/bin/perl perl)
echo -n > $B/var/lib/dpkg/status

(cd $B/dev; $B/dev/MAKEDEV -I -c generic)

(cd $B; chroot $B sbin/ldconfig.new)
trap "umount $B/proc" 0
chroot $B mount -t proc proc /proc
(cd $B;dpkg --root=. --install --force-depends --force-auto-select `make_paths base/ldso base/base-files base/libc5 base/dpkg`)

chroot $B /sbin/ldconfig
(cd $B;dpkg --root=. --unpack --force-auto-select \
 --force-depends --force-overwrite $PACKAGE_PATHS)

# Bug: ppp insists that /var/run/syslogd.pid exist.
echo "1">$B/var/run/syslogd.pid

mv $B/usr/sbin/start-stop-daemon $B/usr/sbin/start-stop-daemon.REAL
cp $B/bin/true $B/usr/sbin/start-stop-daemon
(cd $B/etc; ln -s ../usr/lib/zoneinfo/Factory localtime)
echo America/Los_Angeles > $B/etc/timezone # Avoid post-inst question.
chmod 644 $B/etc/localtime $B/etc/timezone
(cd $B;yes N | dpkg --root=. --configure --pending --force-configure-any \
 --force-depends)
mv $B/usr/sbin/start-stop-daemon.REAL $B/usr/sbin/start-stop-daemon
echo Factory > $B/etc/timezone
chroot $B umount /proc
trap 0

# Bug: ppp insists that /var/run/syslogd.pid exist.
rm -f $B/var/run/syslogd.pid

# Locale files make the base a bit larger. Un-comment this if it becomes
# a problem.
# rm -f -r $B/usr/share/locale $B/usr/share/gettext $B/usr/share/nls

(find $B -name '*.dpkg-old' -exec rm -f \{\} \; ; true)
rm -f $B/var/lib/dpkg/status-old $B/var/lib/dpkg/available-old
(cd $B; tar clf - .)| gzip --best > base${version}.tgz
rm -f -r $B $P &
./utilities/floppy_split base${version}.tgz base14 1440
./utilities/floppy_split base${version}.tgz base12 1200
exit 0
