/*------------------------------------------------------------------------*/
/* Classification -  IBM Internal Use Only                                */
/*                                                                        */
/* Name           -  FEEDTEST CMD                                         */
/* Programmer     -  Greg Rollins                                         */
/* Date Written   -  14 June 1990                                         */
/* Release Level  -  2.6                                                  */
/* Function       -  Copies Stress scripts and atomics to hard drive.     */
/*                                                                        */
/* Change History -                                                       */
/*   2.6   08/27/97  B. Budak                                             */
/*                   Support for specified drive for the stress test      */
/*                   other than the 'D:' drive.  The default if not passed*/
/*                   will be the 'D:' drive though.                       */
/*                                                                        */
/*------------------------------------------------------------------------*/

parse upper arg sdrv .

  if sdrv = '' then sdrv = 'D:'

  do forever
    say ' '
    say ' Insert a STRESS TESTS disk in drive A and then:'
    'pause'

    say ' '
    say ' Copying to hard file:
    say ' '

    'copy a:\stress 'sdrv'\stress'
    'copy a:\script 'sdrv'\script'

    say ' '
    say ' If all disks have been processed, hold in "CTRL" and press "C" to terminate'
    say ' batch job.'
    say ' '
    say ' OR'
  end


EXIT
