/*****************************************************************************/
/****                                                                        */
/****   NRUNTEST.CMD  -- OS/2 System Test Stess Lab                          */
/****                    Date: September 13, 1994                            */
/****                                                                        */
/****                                                                        */
/****   COMMAND FORMAT:   RUNTEST test     <ENTER>                           */
/****                  or RUNTEST test -c  <ENTER>                           */
/****                                                                        */
/****   Change History:                                                      */
/****        9/29/94      Make Wayne changes to date.                        */
/****                                                                        */
/****                                                                        */
/****                                                                        */
/****                                                                        */
/****                                                                        */
/*****************************************************************************/
Parse Arg TestCase Option

Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs


EnvVar = 'OS2ENVIRONMENT'

ECHO OFF

 'D:'
 'CD\'
 'CD Log'

 TestCaseDir = "D:\Script"
 TestLogDir  = "D:\Log"
 TestLogFile = TestLogDir || "\Test.log"
 Switchlog   = TestLogDir || "\Switch"
 FreeDirFile = TestLogDir || '\Freedir'

    NumArgs = ARG()

    /*
    **  Check Arguments.
    */

    If NumArgs = 0 Then Do
        ErrRc = 1
        Signal Runtest_Error
      End


     /*
     **  Check for TestCase.
     */

     TestCase  = Strip(TransLate(TestCase))
     CheckTest = TestCaseDir || "\" || TestCase

     If Stream(CheckTest,'C','Query Exists') = '' Then Do
        ErrRc = 2
        Signal Runtest_Error
      End

     /*
     **  Clear log directory.
     */

        '@Del ' || TestLogDir || '\*.* < ' || TestLogDir  || '\YES.IN'


      /*
      ** Get SwapFile information
      */

      Call SysFileSearch 'swappath', 'C:\Config.sys', 'SwapPath.', 'C'

      Parse Var SwapPath.1 Junk "=" PathFile FireWall InitialSetting

      SwapFile = PathFile || 'Swapper.dat'

      Call SysFileTree SwapFile, 'File', 'F'

      Parse Var File.1 Junk Junk BeforeTest Junk

      BeforeTest = Format(BeforeTest/1048576,3,1)

      rc = Value('BSwap',BeforeTest,EnvVar)

      /*
      **  Get Free Space Before Test
      */

      Parse Var PathFile DriveLetter "\"

      'Dir ' || DriveLetter ||' >' || FreeDirFile

      Call SysFileSearch 'bytes free', FreeDirFile, 'Free.'

      Parse Var Free.1 BeforeFreeSpace Junk

      BeforeFreeSpace = Format(BeforeFreeSpace/1048576,3,1)

      rc = Value('BFSpace',BeforeFreeSpace,EnvVar)


     /*
     **  Start Build Runtime Log.
     */
        Blank = ""

        SDate  = Date('S')
        STime  = Left(Time('N'),5)
        ETime  = Time('E')

        Line1 = Left(TestCase,15) SDate || '; ' || Stime || '; Swap='|| Strip(BeforeTest) || ' Free=' || Strip(BeforeFreeSpace)
        Rc = Lineout(TestLogFile,Line1)


     /*
     **  Runtest
     */


     'switch \script\'TestCase' -d -l5'

     /*
     **  Prep For Log File Finish
     */

        FDate  = Date('S')
        FTime  = Left(Time('N'),5)
        ETime  = Time('E')

        Parse Var ETime Seconds "." Junk

        CAll Convert_Time

        /*
        **  Get Swapfile after Test
        */

        Call SysFileTree SwapFile, 'File', 'F'

        Parse Var File.1 Junk Junk AfterTest Junk

        AfterTest = Format(AfterTest/1048576,3,1)

        rc = Value('ASwap',AfterTest,EnvVar)

        /*
        **  Get Free Space after Test
        */

        Parse Var PathFile DriveLetter "\"

        'Dir ' || DriveLetter ||' >' || FreeDirFile

        Call SysFileSearch 'bytes free', FreeDirFile, 'Free.'

        Parse Var Free.1 AfterFreeSpace Junk

        AfterFreeSpace = Format(AfterFreeSpace/1048576,3,1)

        rc = Value('AFSpace',AfterFreeSpace,EnvVar)


        /*
        **  Finish Log File.
        */

        Line2 = Right(Blank,15) Fdate || '; '|| FTime ||'; Swap=' || Strip(AfterTest) || ' Free=' || Strip(AfterFreeSpace) || ' Runtime='|| ConVertedTime
        Rc = Lineout(TestLogFile,Line2)

      /*
      ** Find Fails From Switch Log
      */

     If Stream(SwitchLog,'C','Query Exists') = '' Then Do

        Say "Switch Log cannot be Found !"

      End

     Else Do

      Call SysFileSearch 'FAIL', SwitchLog, 'Fails.'

      If Fails.0 \= 0 Then Do

                Do f = 1 to Fails.0
                     Rc = Lineout(TestLogFile, Fails.f)
                End
         End

       Else Do

        'grep -y fail >> ' || TestLogDir || '\Fails'
        'type ' || TestLogDir || '\Fails | more '

        End

      End

        Rc = Lineout(TestLogFile,Blank)
        Rc = Lineout(TestLogFile,'************* Test Complete ********************')
        Rc = Lineout(TestLogFile)

        /*
        ** Play Beep.
        */

           note.1 = 262
           note.2 = 294
           note.3 = 330
           note.4 = 349
           note.5 = 392
           note.6 = 440
           note.7 = 494
           note.8 = 523

           Do 4
                  Do i = 1 to 8
                      Call beep note.i,100
                  End

           End

        /*
        **  Type out Test.log
        */


        'Type ' || TestLogDir || "\test.log | more"

Exit

Convert_Time:


        Parse Var ETime Seconds "." Junk

              If Seconds < 60 Then Do

                    Time = "00:00"

                 End

               Else Do

                 Min = Seconds / 60

                 Parse Var Min Min "." Junk

                 If Min >= 60 Then Do
                    Hour = Seconds / 3600

                    Parse Var Hour Hour "." Remainder

                    If Remainder \= "" Then Do
                       /* Convert remainding hours into minutes */
                        Min = (Seconds - (3600*Hour)) / 60

                        Parse Var Min Min "." Sec

                        If Sec \= "" Then Do
                         /* Convert remainding minutes into seconds */
                          Sec =(Seconds - ((3600*Hour)+(60*Min)))
                          Parse Var Sec Sec "." Mlsec

                         /* Round second to min/hour */
                          If (Min <=58) & (Sec >=30) Then
                            Min = Min +1
                          Else If (Min >58) & (Sec >=30) Then Do
                            Min = 0
                            Hour = Hour +1
                            End
                        End

                        Min = Left(Strip(Min),2)

                        If Min <= 9 Then
                                Min = "0" || Min

                        End
                      Else
                        Min = "00"

                    If Hour < 9 Then
                       Time = "0" || Hour || ":" || Strip(Min)
                     Else
                       Time = Hour || ":" || Strip(Min)

                  End

                Else Do

                 Parse Var Min Min "." Junk

                    If Min < 9 Then
                      Time = "00:0" || Min
                    Else
                      Time = "00:" || Min

                 End

              End

        ConVertedTime = Time

Return


Runtest_Error:

     Select

        When ErrRc = 1 Then Do

                Say "Usage  : Runtest TestCase Option <Enter>"
                Say ""
                Say "Example: Runtest Med01-p <Enter>"
                Say ""
                Say "Options: -C  = Continuous"

        End

        When ErrRc = 2 Then Do

                Say "TestCase : " || TestCase || " cannot be found !"

        End

        OtherWise
                Nop

     End

Exit

