/*****************************************************************************/
/****   RUNTEST.CMD  -- Rexx Version 1.0 of RUNTEST for OS/2 System Test III */
/****                   by Phil Estes , March 26, 1991                       */
/****                                                                        */
/****   --rexx language translation of Batch Version 3.4 RUNTEST.CMD         */
/****   --handles up to 9 testname inputs                                    */
/****                                                                        */
/****   COMMAND FORMAT:   RUNTEST test1 <ENTER>                              */
/****                  or RUNTEST test1 test2 ... test9 <ENTER>              */
/****                  or RUNTEST test1 -c <ENTER>                           */
/****                  or RUNTEST test1 test2 ... test9 -c <ENTER>           */
/****                  or RUNTEST test1 -16 <ENTER>                          */
/****                  or RUNTEST test1 test2 ... test9 -16 <ENTER>          */
/****                                                                        */
/****           Updated: 3/26/91 -- Phil Estes, base version                 */
/****                    4/10/91  - PFE, handles 9 tests                     */
/****                    4/15/91  - PFE, has continuous mode                 */
/****                    4/17/91  - PFE, continuous for more than one test   */
/****                    4/20/91  - PFE, colors on each run                  */
/****                    7/24/91  - PFE, new cutter test directory support   */
/****                    7/25/91  - PFE, handles -16 parm. for cutter run    */
/****                    8/15/91  - PFE, asks for update diskette before run */
/****                    8/21/91  - PFE, DIRs the cutter directory for test  */
/****                                    when a wrong testname is specified  */
/*****************************************************************************/
ECHO OFF
CLS
                                     /*  parse command line arguments  */
arg test.1 test.2 test.3 test.4 test.5 test.6 test.7 test.8 test.9

if test.1 = '' then                  /* if no argument entered then goto */
   call noparm                       /* no parameters subroutine */
   else if stream('d:\script\'TEST.1'','c','query exists') = '' then

        if stream('d:\cutter\'TEST.1'','c','query exists') = ''   then
          call notfound                /* testname not in script directory */

if test.2 = '-16' then
   call next;

if test.2 = '-C' then                /* for continuous mode testing */
   call next;

do x = 2 to 9

if test.x = '-C' then               /* if the param is -C then continuous mode*/
   call next;

if test.x = '-16' then
   call next;

if test.x = '' then                  /* if test 'x' is not there then leave this */
   call next                         /* routine */
   else if stream('d:\script\'TEST.x'','c','query exists') = '' then

           if stream('d:\cutter\'TEST.x'','c','query exists') = ''   then
        call notfound                /* if test 'x' not found in script directory */

End
/*-------------------------------------------------------------------------*/
next:                                       /*removes log directories from */
                                            /*last testing phase if remain */

logg.1 = 'd:\log1\*.* <YES.DAT'
logg.2 = 'd:\log2\*.* <YES.DAT'
logg.3 = 'd:\log3\*.* <YES.DAT'
logg.4 = 'd:\log4\*.* <YES.DAT'
logg.5 = 'd:\log5\*.* <YES.DAT'
logg.6 = 'd:\log6\*.* <YES.DAT'
logg.7 = 'd:\log7\*.* <YES.DAT'
logg.8 = 'd:\log8\*.* <YES.DAT'
logg.9 = 'd:\log9\*.* <YES.DAT'

runtime.1 = 'd:\log1\runtime1.log'
runtime.2 = 'd:\log2\runtime2.log'
runtime.3 = 'd:\log3\runtime3.log'
runtime.4 = 'd:\log4\runtime4.log'
runtime.5 = 'd:\log5\runtime5.log'
runtime.6 = 'd:\log6\runtime6.log'
runtime.7 = 'd:\log7\runtime7.log'
runtime.8 = 'd:\log8\runtime8.log'
runtime.9 = 'd:\log9\runtime9.log'

log.1 = 'd:\log1'
log.2 = 'd:\log2'
log.3 = 'd:\log3'
log.4 = 'd:\log4'
log.5 = 'd:\log5'
log.6 = 'd:\log6'
log.7 = 'd:\log7'
log.8 = 'd:\log8'
log.9 = 'd:\log9'

do x = 1 to 9

if stream(runtime.x,'c','query exists') = '' then
   do                                   /* do nothing if not found */
   nop ;
   end
   else do
     'attrib -r 'log.x'\comp.in'    /* unattribute all attributed files */
     'attrib -r 'log.x'\yes.in'     /* in the log file directory        */
     'attrib -r 'log.x'\fortext'
     'attrib -r 'log.x'\ret'
     'attrib -r 'log.x'\ret.in'     /* if the runtime log from the last */
     'del 'logg.x
     'rd 'log.x                    /* test exists then zap the log dir */
   end

end
/*-------------------------------------------------------------------------*/
next1:

'call cleanit.cmd'                /* call the directory cleanup batch file */

/*-------------------------------------------------------------------------*/

'echo %VERSION% > D:\LOG\VERS.DAT' /* echo the version environment variable to */
                                  /* a data file where rexx can read it in */

version = linein(vers.dat)        /* read it in to a string var, version */

if version = 'CUTTER' then        /* if version = cutter then ask for debugger */
 do
  say ' '
  say 'Please break in at the DEBUGGER and type "VSD;G"'
  pause
 end
 else nop                         /* else for CRUISER skip the debugger */

call lineout vers.dat             /* close the data file for the version var. */

say ' '
say 'Please put the update diskette in drive A:\ '
say ' '
pause
say ' '
say ' Copying updates to hard file...'
say ' '
'if exist a:\stress\*.* copy a:\stress\*.* d:\stress'
'if exist a:\script\*.* copy a:\script\*.* d:\script'
'if exist a:\cutter\*.* copy a:\cutter\*.* d:\cutter'
say ' '
say ' Update now complete...'
say ' '
say ' Please remove the update diskette from drive A:\ '
say ' '
pause
say ' '
say ' Insert SCRATCH diskettes if necessary..test will now begin.'
say ' '

rntime.1='runtime.log d:\log1\runtime1.log'
rntime.2='runtime.log d:\log2\runtime2.log'
rntime.3='runtime.log d:\log3\runtime3.log'
rntime.4='runtime.log d:\log4\runtime4.log'
rntime.5='runtime.log d:\log5\runtime5.log'
rntime.6='runtime.log d:\log6\runtime6.log'
rntime.7='runtime.log d:\log7\runtime7.log'
rntime.8='runtime.log d:\log8\runtime8.log'
rntime.9='runtime.log d:\log9\runtime9.log'

log.1='d:\log1'
log.2='d:\log2'
log.3='d:\log3'
log.4='d:\log4'
log.5='d:\log5'
log.6='d:\log6'
log.7='d:\log7'
log.8='d:\log8'
log.9='d:\log9'

fail.1='d:\log1\fails1'
fail.2='d:\log2\fails2'
fail.3='d:\log3\fails3'
fail.4='d:\log4\fails4'
fail.5='d:\log5\fails5'
fail.6='d:\log6\fails6'
fail.7='d:\log7\fails7'
fail.8='d:\log8\fails8'
fail.9='d:\log9\fails9'

color.1=' $e[1;33;40m $p] $e[1;37;40m'     /* white */
color.2=' $e[1;33;40m $p] $e[1;34;40m'     /* bright blue */
color.3=' $e[1;33;40m $p] $e[1;32;40m'     /* bright green */
color.4=' $e[1;33;40m $p] $e[1;26;40m'     /* yellow */
color.5=' $e[1;33;40m $p] $e[1;35;40m'     /* purple */
color.6=' $e[1;33;40m $p] $e[0;29;40m'     /* grey */
color.7=' $e[1;33;40m $p] $e[0;31;40m'     /* red */
color.8=' $e[1;33;40m $p] $e[0;32;40m'     /* dull green */
color.9=' $e[1;33;40m $p] $e[1;36;40m'     /* cyan */

if test.2 = '-16' then      /* -16 parm for use of d:\cutter directory */
  call cutter_run;              /* only for one test being run */

if test.2 = '-C' then       /* -C parm for continuous run of one test */
   call continuous;

do x = 3 to 9

if test.x = '-16' then      /* -16 parm for use of d:\cutter for more  */
   call cutter_run2;        /*    than one testcase                    */

if test.x = '-C' then       /* -C parm for use of continuous mode for  */
   call continuous2;        /*    more than one testcase               */

end
/*--------------------------------------------------------------------**/
/*  Normal testing loop with no parameters, up to 9 tests             **/
/*--------------------------------------------------------------------**/
do x = 1 to 9

if test.x = '' then
  call endtest

else do

'prompt' color.x       /* sets the prompt and character color */
'md 'log.x

'md d:\temp'                       /* 6.161 fix for CMD.EXE problem */
'copy d:\log\*.in d:\temp'
'copy d:\log\fortext d:\temp'
'copy d:\log\ret. d:\temp'

'del d:\log\*.* <YES.DAT'

'copy d:\temp d:\log'             /* 6.161 fix for CMD.EXE problem */

'echo TEST CASE:  'test.x' > runtime.log'
'ver>> runtime.log'
'echo >> runtime.log'
'echo START:>> runtime.log'
'echo >> runtime.log'
'echo.| more | date | find "Current" >> runtime.log'
'echo.| more | time | find "Current" >> runtime.log'
'cls'
'echo on'
'switch \script\'test.x' -d -l5'
'echo off'
'echo. >> runtime.log'
'echo. >> runtime.log'
'echo FINISH:>> runtime.log'
'echo >> runtime.log'
'echo.| more | date | find "Current" >> runtime.log'
'echo.| more | time | find "Current" >> runtime.log'
'echo ******************** TEST COMPLETED ********************'
'call rexxtime >1.dat'
'type 1.dat >>runtime.log'
'echo on'
'grep -y fail >> 'fail.x
'echo off'
'copy 'rntime.x
'copy d:\log\*.* 'log.x


  end

end
call endtest

/*-------------------------------------------------------------------------*/
continuous:                         /* if -c parameter used then the test  */
                                    /* will be repeated over and over in   */
do forever                          /* a forever loop with all output just */
                                    /* writing over previous results .     */
                                    /*-------------------------------------*/
do x = 1 to 9

'prompt' color.x                    /* sets prompt and character color */


'md d:\temp'                       /* 6.161 fix for CMD.EXE problem */
'copy d:\log\*.in d:\temp'
'copy d:\log\fortext d:\temp'
'copy d:\log\ret. d:\temp'

'del d:\log\*.* <YES.DAT'

'copy d:\temp d:\log'              /* 6.161 fix for CMD.EXE problem */

'echo TEST CASE:  'test.1' > runtime.log'
'ver>> runtime.log'
'echo >> runtime.log'
'echo START:>> runtime.log'
'echo >> runtime.log'
'echo.| more | date | find "Current" >> runtime.log'
'echo.| more | time | find "Current" >> runtime.log'
'cls'
'echo on'
'switch \script\'test.1' -d -l5'
'echo off'
'echo. >> runtime.log'
'echo. >> runtime.log'
'echo FINISH:>> runtime.log'
'echo >> runtime.log'
'echo.| more | date | find "Current" >> runtime.log'
'echo.| more | time | find "Current" >> runtime.log'
'echo ******************** TEST COMPLETED ********************'
'call rexxtime >1.dat'
'type 1.dat >>runtime.log'
'echo on'
'grep -y fail >> 'fail.1
'echo off'

 end   /* end of color do loop */
end
/*-------------------------------------------------------------------------*/
continuous2:                        /* -C parm for more than one testcase  */
                                    /*    --->                             */
do forever                          /* a forever loop with all output just */
                                    /* writing over previous results .     */
do x = 1 to 9                       /*-------------------------------------*/

if test.x = '-C' then               /*if the current param is -c then tests*/
  end;                              /*are through, time to start over with */
                                    /*test 1 again */
else do

'prompt' color.x

'md 'log.x

'md d:\temp'                       /* 6.161 fix for CMD.EXE problem */
'copy d:\log\*.in d:\temp'
'copy d:\log\fortext d:\temp'
'copy d:\log\ret. d:\temp'

'del d:\log\*.* <YES.DAT'

'copy d:\temp d:\log'              /* 6.161 fix for CMD.EXE problem */

'echo TEST CASE:  'test.x' > runtime.log'
'ver>> runtime.log'
'echo >> runtime.log'
'echo START:>> runtime.log'
'echo >> runtime.log'
'echo.| more | date | find "Current" >> runtime.log'
'echo.| more | time | find "Current" >> runtime.log'
'cls'
'echo on'
'switch \script\'test.x' -d -l5'
'echo off'
'echo. >> runtime.log'
'echo. >> runtime.log'
'echo FINISH:>> runtime.log'
'echo >> runtime.log'
'echo.| more | date | find "Current" >> runtime.log'
'echo.| more | time | find "Current" >> runtime.log'
'echo ******************** TEST COMPLETED ********************'
'call rexxtime >1.dat'
'type 1.dat >>runtime.log'
'echo on'
'grep -y fail >> 'fail.x
'echo off'
'copy 'rntime.x
'copy d:\log\*.* 'log.x


  end

end
end
call endtest;
/*-------------------------------------------------------------------------*/
cutter_run:                         /* -16 parm used so testcase script is */
                                    /* looked for in d:\cutter directory.  */
                                    /* -- Only one testcase.               */
                                    /*-------------------------------------*/

'prompt' color.1       /* sets prompt and character color */

'md 'log.1

'md d:\temp'                       /* 6.161 fix for CMD.EXE problem */
'copy d:\log\*.in d:\temp'
'copy d:\log\fortext d:\temp'
'copy d:\log\ret. d:\temp'

'del d:\log\*.* <YES.DAT'

'copy d:\temp d:\log'              /* 6.161 fix for CMD.EXE problem */

'echo TEST CASE:  'test.1' > runtime.log'
'ver>> runtime.log'
'echo >> runtime.log'
'echo START:>> runtime.log'
'echo >> runtime.log'
'echo.| more | date | find "Current" >> runtime.log'
'echo.| more | time | find "Current" >> runtime.log'
'cls'
'echo on'
'switch \cutter\'test.1' -d -l5'
'echo off'
'echo. >> runtime.log'
'echo. >> runtime.log'
'echo FINISH:>> runtime.log'
'echo >> runtime.log'
'echo.| more | date | find "Current" >> runtime.log'
'echo.| more | time | find "Current" >> runtime.log'
'echo ******************** TEST COMPLETED ********************'
'call rexxtime >1.dat'
'type 1.dat >>runtime.log'
'echo on'
'grep -y fail >> 'fail.1
'echo off'
'copy 'rntime.1
'copy d:\log\*.* 'log.1

   /* end of test */

call endtest;
/*-------------------------------------------------------------------------*/
cutter_run2:                       /* -16 parm used with more that one test*/
                                   /* tests are run in succession from the */
do x = 1 to 9                      /* d:\cutter subdirectory.              */
                                   /*--------------------------------------*/
if test.x = '-16' then
  call endtest;

else do

'prompt' color.x

'md 'log.x

'md d:\temp'                       /* 6.161 fix for CMD.EXE problem */
'copy d:\log\*.in d:\temp'
'copy d:\log\fortext d:\temp'
'copy d:\log\ret. d:\temp'

'del d:\log\*.* <YES.DAT'

'copy d:\temp d:\log'              /* 6.161 fix for CMD.EXE problem */

'echo TEST CASE:  'test.x' > runtime.log'
'ver>> runtime.log'
'echo >> runtime.log'
'echo START:>> runtime.log'
'echo >> runtime.log'
'echo.| more | date | find "Current" >> runtime.log'
'echo.| more | time | find "Current" >> runtime.log'
'cls'
'echo on'
'switch \cutter\'test.x' -d -l5'
'echo off'
'echo. >> runtime.log'
'echo. >> runtime.log'
'echo FINISH:>> runtime.log'
'echo >> runtime.log'
'echo.| more | date | find "Current" >> runtime.log'
'echo.| more | time | find "Current" >> runtime.log'
'echo ******************** TEST COMPLETED ********************'
'call rexxtime >1.dat'
'type 1.dat >>runtime.log'
'echo on'
'grep -y fail >> 'fail.x
'echo off'
'copy 'rntime.x
'copy d:\log\*.* 'log.x


  end

end
/*-------------------------------------------------------------------------*/
endtest:

say '********************************************************************'
say 'Press a key to look at the Test(s) Results'
pause                              /* the test is finished, wait for input */

do x = 1 to 9

if test.x = '' then
 do
 call endit
 end
 else do

if test.x = '-16' then
   call endit;

say '*************************' TEST.x '*********************************'
'type 'runtime.x
say '************************************************************************'
say 'Press a key to view the FAILS log'
pause
say '*************************' FAIL.x '*********************************'
'type 'fail.x'| more '
pause

 end

end

call endit
/*-------------------------------------------------------------------------*/
noparm:                            /*      If no parameters specified      */

say 'No test name was specified.  Please try again.'
say ' '
say 'Command format:'
say '     RUNTEST script_name        --> for one testcase in d:\script dir '
say '     RUNTEST script1 script2... --> for multiple tests in d:\script   '
say '     RUNTEST script_name -c     --> for one test in continuous mode   '
say '     RUNTEST script1 script2 -c --> for multiple tests in cont. mode  '
say '     RUNTEST script_name -16    --> for one test in d:\cutter directory'
say '     RUNTEST script1 script2 -16--> for multiple tests in d:\cutter   '
say ' '
say '   script_name must be a valid testname in d:\cutter or d:\script dirs.'

call endit
                               /*  leave rxuntest   */
/*-------------------------------------------------------------------------*/
notfound:                /*  If testname not found in script directory  */

directory='d:\script /p'      /* variable with DIR options */
directory16='d:\cutter /p'    /* variable for DIR for cutter scripts */

say 'No file of that exact name exists in the SCRIPT subdirectory.'
say ' '
say 'For a directory..'

pause

do x = 2 to 9
if test.x = '-16' then
do
dir directory16
call endit
end
End

dir directory
call endit                    /*   leave runtest  */


/*-------------------------------------------------------------------------*/
endit:

say '...'      /* end of runtest , back to OS/2 */

