/*  RXQCLEAN.CMD  */
/*============================================================================*/
/*      Program  ID    :  RXQCLEAN  - IBM Confidential                        */
/*      Filename       :  RXQCLEAN.CMD                                        */
/*      Author(s)      :  Jack Kipp, IBM System Test, Delray Beach, FL        */
/*      Based on       :  RXQMAXQS.CMD amd RXQSINGQ.CMD, written by J. Kipp   */
/*      Date Written   :   4/27/89                                            */
/*      Date Revised   :  na                                                  */
/*                                                                            */
/*    ***** IMPORTANT ******************************************************* */
/*    * The code in this program is intended to be identical in function    * */
/*    * to the code of RXQCLEAS.CMD.  So, if one changes, the other should. * */
/*    *********************************************************************** */
/*                                                                            */
/*      Command line for this test :                                          */
/*                                                                            */
/*      RXQCLEAN qname loglevel logfile temp                                  */
/*                                                                            */
/*      qname   - name of queue (SESSION queue default)                       */
/*      loglevel- level at or below which to log messages (6 default)         */
/*      logfile - name of logfile (RXQCLEAN default)                          */
/*      temp    - just a place holder to help make logfile acceptable         */
/*                                                                            */
/*      REXX commands  :  RXQUEUE('Set'), PULL, RXQUEUE('Delete')             */
/*                                                                            */
/*      Comments       :  Cleans up a queue.  Purges and deletes it.          */
/******************************************************************************/
/*   PSEUDOCODE -                                                             */
/*   Until queue <qname> is empty                                             */
/*      Purge <qname> of its entries                                          */
/*   Delete queue.                                                            */
/*   Exit.                                                                    */
/******************************************************************************/
/*                            revision history                                */
/*                                                                            */
/*  Changes for OS/2 SE 1.20:                                                 */
/*                                                                            */
/*   Date       Name                 Description                              */
/* --------  -----------  ----------------------------------------------------*/
/*  4/27/89  J. Kipp      base version of the test                            */
/*  5/ 1/89  J. Kipp      allows option of testing SESSION queue              */
/*  5/ 1/89  J. Kipp      makes SESSION queue default queue                   */
/*  6/14/89  J. Kipp      replace ^ with                                     */
/*  6/23/89  J. Kipp      replace  with ^ till  is implemented              */
/*  7/21/89  J. Kipp      replace ^ with                                     */
/*  9/26/89  J. Kipp      wait till RXQREADQ.CMDs empty q, then delete q here */
/*  9/26/89  J. Kipp      this program no longer purges qs                    */
/*  9/26/89  J. Kipp      roll of purging qs now belongs to each RXQREADQ.CMD */
/*  9/27/89  J. Kipp      else do for Queue was not empty message             */
/*  9/27/89  J. Kipp      adds a space for Queue xxx is purged message        */
/* 10/ 5/89  J. Kipp      put elapsed time (sec.) on each log message         */
/* 10/ 6/89  J. Kipp      leave initial space out of msgtag                   */
/* 10/ 6/89  J. Kipp      make REXX source code fit in first 80 columns       */
/* 10/ 7/89  J. Kipp      use time('L') rather than time('E')                 */
/* 10/ 7/89  J. Kipp      say RXQCLEAN PASSED or FAILED, not RXQREAD          */
/* 10/17/89  J. Kipp      use external function rxqueue_get_flag in           */
/*                        RXSTRESS.DLL, written by Eric Mintz                 */
/* 10/17/89  J. Kipp      wait for readers to say all done                    */
/* 10/17/89  J. Kipp      handle Ctrl-C; 'call off halt' doesn't keep Ctrl-C  */
/*                        from discontinuing a REXX program                   */
/* 10/17/89  J. Kipp      have a deletecount so that Ctrl-C handler knows if  */
/*                        data q has already been deleted                     */
/* 10/17/89  J. Kipp      make logit parameter driven so that each call takes */
/*                        fewer commands, and so less time                    */
/* 10/19/89  J. Kipp      get full pathname of logfile so that old version    */
/*                        of logfile may be deleted properly                  */
/*                                                                            */
/*  Changes for OS/2 SE 2.00:                                                 */
/*                                                                            */
/*  3/14/91  J. Kipp      change DO UNTIL to DO WHILE to check for empty q    */
/*  3/14/91  J. Kipp      change STRIP calls to function calls in defaults()  */
/*  3/14/91  J. Kipp      eliminate code adding a function from a DLL that    */
/*                        is no longer to be used:  RXSTRESS.DLL, which is    */
/*                        C code                                              */
/*  6/ 1/91  J. Kipp      wipes out source text past column 80                */
/*  6/ 1/91  J. Kipp      pass test if deleting queue gets rc 9:  q not found */
/******************************************************************************/

   arg qname loglevel logfile .

/*ͻ*/
/* (main)               Here is the start of the test                     */
/*ͼ*/

      call defaults;              /* set default and initial values */
      call on halt name cleanup;  /* when Ctrl-C comes, go cleanup */
      call waitpurgeq;            /* wait here till readers are done */

      if isitsession =0 then call deleteq;    /* if not, delete it */

      call didwepass;             /* well, did we? */
      call ending;                /* say bye bye */

exit;   /* end of main program */

defaults:
/*ͻ*/
/* (defaults)           Set default and initial values:                   */
/*                                                                        */
/*                      Queue name:             RXQMULTI                  */
/*                      Logging level:                 6                  */
/*                      Log file name:          RXQCLEAN                  */
/*ͼ*/

      /* logging defaults */
      if loglevel = '' then loglevel = 6;
      if logfile = '' then logfile = 'RXQCLEAN';
      logfile = directory() || '\' || logfile;          /* tack on cur. dir. */
      logfile = strip(logfile,'t');                 /* strip trailing blanks */
      msgtag = '(RXQCLEAN) ';

      /* erase old log file if a previous version exists */
      if stream( logfile, 'c', 'query exists' ) = '' then do;
         logmsg = 'Erasing old log file ' || logfile;
         call logit logmsg, 5;
         erase logfile;
      end;

      /* start logging */
      logmsg = 'ENTER RXQCLEAN STRESS TEST';
      call logit logmsg, 1;

      /* qname */
      if qname = '' then qname = 'SESSION';

      /* counters */
      failcount = 0;    /* if zero we pass the test */
      deletecount = 0;  /* nonzero when the data queue is deleted */

      /* data items for each queue entry */
      dqsize = 0;       /* q size */
      dqrecnum = 0;     /* q record # */

      /* session queue flag */
      isitsession = compare(qname,'SESSION');  /* is it SESSION q? */

return;  /* end of defaults */

activate:
/*ͻ*/
/* (activate)           Make this queue the active one.                   */
/*                      Assumed it already has been created.              */
/*ͼ*/

      signal off novalue;
      logmsg = '(activate) Activating queue ' || qname;
      call logit logmsg, 5;
      oq = RXQUEUE('Set',qname);
      signal on novalue;

return;  /* end of activate */

waitpurgeq:
/*ͻ*/
/* (waitpurgeq)         Wait till the active queue is purged              */
/*                                                                        */
/*                      Input:                                            */
/*                        qname      the name of the queue to clean up    */
/*ͼ*/

       logmsg = '(waitpurgeq) Waiting till queue ' || qname || ' is purged';
       call logit logmsg, 5;

       purgecount = 0;
       do while ( queued() > 0 );                    /* till readers are done */
          purgecount = purgecount + 1;               /* just diddle */
          if purgecount >= 10 then purgecount = 1;   /* and fiddle */
       end;

       if purgecount = 0 then
       do
          logmsg = '(waitpurgeq) Found queue empty';
       end;
       else do;
          logmsg = '(waitpurgeq) Queue was not empty';
       end;

       call logit logmsg, 5;

       logmsg = '(waitpurgeq) Queue ' || qname || ' is purged';
       call logit logmsg, 5;

return;  /* end of waitpurgeq */

deleteq:
/*ͻ*/
/* (deleteq)            Delete the active queue                           */
/*                                                                        */
/*                      Input:                                            */
/*                        qname      the name of the queue to clean up    */
/*ͼ*/

    /* delete queue and log deletion results */
    if deletecount = 0 then do;
       dq = RXQUEUE('Delete',qname);
       if dq = 0 then do;
          if dq = 9 then do;
             logmsg = '(deleteq) Failed to delete queue ' || qname;
             logmsg = logmsg || '; result is ' || dq || '; should be 0';
             whatlevel = 4;
             failcount = failcount + 1;
          end;
          else do;
             logmsg = '(deleteq) Delete queue ' || qname || ' returned ';
             logmsg = logmsg || dq || ', queue not found; this is ok';
             whatlevel = 5;
          end;
       end;
       else do;
          logmsg = '(deleteq) Deleted queue ' || qname;
          deletecount = deletecount + 1;
       end;
       call logit logmsg, 4;
    end;
    else do;
       logmsg = '(deleteq) Already deleted queue ' || qname;
       call logit logmsg, 5;
    end;

return;  /* end of deleteq */

didwepass:
/*ͻ*/
/* (didwepass)          Print PASS or FAIL message.  We pass if we are    */
/*                      able to delete the queue.                         */
/*                                                                        */
/*                      Input:                                            */
/*                        failcount  the # of times we just plain goofed  */
/*ͼ*/

      if failcount = 0 then do;
         logmsg = '(didwepass) RXQCLEAN PASSED';
      end;
      else do;
         logmsg = '(didwepass) RXQCLEAN FAILED';
      end;

      call logit logmsg, 1;

return;  /* end of didwepass */

cleanup:
/*ͻ*/
/* (cleanup)            Ctrl-Break and Ctrl-C handler.                    */
/*                                                                        */
/*                      We come here to clean up if Ctrl-Break or Ctrl-C  */
/*                      was pressed.                                      */
/*ͼ*/

      call waitpurgeq;            /* wait here till readers are done */

      if isitsession =0 then call deleteq;    /* if not, delete it */

      call didwepass;             /* well, did we? */
      call ending;                /* say bye bye */

return;  /* end of cleanup */

logit:  procedure expose logfile loglevel msgtag
parse arg whatmsg, whatlevel
/*ͻ*/
/* (logit)              Log a message if <= requested logging level       */
/*                                                                        */
/*                      Input:                                            */
/*                        whatlevel  level at or above which to log       */
/*                        whatmsg   the message to be logged              */
/*                                                                        */
/*                      Globals:                                          */
/*                        logfile    the name of the logfile              */
/*                        loglevel   logging level requested at startup   */
/*                        msgtag     tag to be used on each message       */
/*ͼ*/

      newmsg = time('L') || ' ' || msgtag;
      newmsg = newmsg || whatmsg;
      if whatlevel <= loglevel then do;
         msgcnt = lineout(logfile,newmsg);
         say newmsg;
      end;

return;  /* end of logit */

ending:
/*ͻ*/
/* (ending)             End of the test                                   */
/*ͼ*/

      logmsg = 'EXIT RXQCLEAN STRESS TEST';
      call logit logmsg, 1;

return;  /* end of ending */
