/*  RXQMAXQS.CMD  */
/*============================================================================*/
/*      Program  ID    :  RXQMAXQS  - IBM Confidential                        *//* jak */
/*      Filename       :  RXQMAXQS.CMD                                        *//* jak */
/*      Author(s)      :  Jack Kipp                                           */
/*                        IBM System Test Group, Delray Beach, FL             */
/*      Based on       :  Tony Ingenoso's STRQ01D.C                           */
/*                        from OS/2 base queue stress system test suite       */
/*      Date Written   :  12/22/88                                            */
/*      Date Revised   :  na                                                  */
/*                                                                            */
/*      Command line for this test :                                          */
/*                                                                            */
/*      RXQMAXQS startlq lngqi maxlngq rexxlog                                *//* jak */
/*                                                                            */
/*      startlq - starting length of longname to append to queue name         */
/*      lngqi   - number of characters to add to longname on each iteration   */
/*      maxlngq - maximum length  of longname to append to queue name         */
/*      rxqmlogn- name of logfile (maxqs default; .log extension is appended) */
/*      loglevel- for logging any messages (6 default)                        *//* jak */
/*                                                                            */
/*      REXX calls     :  RXQUEUE('Create'), RXQUEUE('Delete')                */
/*      Comments       :  Queue limits test,                                  */
/*                           max # of queues, max elements etc..              */
/******************************************************************************/
/*   PSEUDOCODE -                                                             */
/*   Read command line arguments.                                             */
/*   For increasing lengths of longnames:                                     */
/*      Make longnames.                                                       */
/*      Create lots of Qs.                                                    */
/*      Cleanup queues.                                                       */
/*   Exit.                                                                    */
/******************************************************************************//* jak */
/*                            revision history                                *//* jak */
/*                                                                            *//* jak */
/* Changes for OS/2 SE 1.20:                                                  *//* jak */
/*                                                                            *//* jak */
/*   Date       Name                 Description                              *//* jak */
/* --------  -----------  ----------------------------------------------------*//* jak */
/*  2/21/89  J. Kipp      MAXQS.CMD renamed to RXQMAXQS.CMD                   *//* jak */
/*  2/22/89  J. Kipp      Cut down on the size of the log                     *//* jak */
/*  2/24/89  J. Kipp      Strip trailing blanks from log filename             *//* jak */
/*  3/ 2/89  J. Kipp      erase old copy of log file                          *//* jak */
/*  3/20/89  J. Kipp      log msgs only at or below level requested           *//* jak */
/*  3/20/89  J. Kipp      simplify say commands                               *//* jak */
/*  3/20/89  J. Kipp      put make & delete qs in separate routines           *//* jak */
/*  3/20/89  J. Kipp      separate out pass/fail detection routine            *//* jak */
/*  3/20/89  J. Kipp      clean up after Ctrl-Break or Ctrl-C                 *//* jak */
/*  3/22/89  J. Kipp      show msg saying Ctrl-Break was pressed              *//* jak */
/*  3/22/89  J. Kipp      put all setup into defaults routine                 *//* jak */
/*  3/22/89  J. Kipp      comments to distinguish setup steps                 *//* jak */
/*  3/22/89  J. Kipp      put ending messages in a separate routine           *//* jak */
/*  4/14/89  J. Kipp      don't need to make longnames if lngq=0              *//* jak */
/*  4/24/89  J. Kipp      passfail renamed didwepass                          *//* jak */
/*  4/24/89  J. Kipp      if we passed, should be no 'fail's in log           *//* jak */
/*  6/14/89  J. Kipp      replace ^ with                                     *//* jak */
/*  6/23/89  J. Kipp      replace  with ^ till  is implemented              *//* jak */
/*  7/21/89  J. Kipp      replace ^ with                                     *//* jak */
/* 10/ 7/89  J. Kipp      put time of day, time('L'), on each log message     *//* jak */
/* 10/ 7/89  J. Kipp      fit as much REXX code as possible in first 80 cols. *//* jak */
/******************************************************************************//* jak */

   arg startlq lngqi maxlngq rxqmlogn loglevel temp                             /* jak */

/*ͻ*/
/* (main)               Here is the start of the test                     */
/*ͼ*/

      call defaults;  /* set defaults and initialize variables     */
      call filllong;  /* load up the character table for longnames */

      do lngq=startlq by lngqi to maxlngq;

         if lngq=0 then do;   /* requested longname length is zero */           /* jak */
            lnbfr='';         /* so append a null string in that case */        /* jak */
         end;
         else do;             /* requested longname length is nonzero */
            call makelong;    /* generate a longname of length lngq */
         end;

         /* In the event of Ctrl-Break, go clean up whatever queues are open. *//* jak */

         call on halt name cleanup;                                             /* jak */

         call makequeues; /* create queues named with number & longname  */
         startdel = 1;    /* start cleanup by deleting first queue */
         call delqueues;  /* delete queues */                                   /* jak */
         call didwepass;  /* did we pass or fail for this longname length? */   /* jak */
      end;

      call ending;

exit;   /* end of main program */

novalue:
/*ͻ*/
/* (novalue)            Error trapping for uninitialized variables        */
/*ͼ*/

      mlogmsg = time('L') || ' ' || msgtag;                                     /* jak */
      mlogmsg = mlogmsg || '(novalue) No value ' || rc || ' at line ' || sigl;
      whatlevel = 2;                                                            /* jak */
      call logit;                                                               /* jak */
      say mlogmsg;                                                              /* jak */
      mlogmsg = time('L') || ' ' || msgtag;                                     /* jak */
      mlogmsg = mlogmsg || '(novalue) Program cannot continue.  '
      mlogmsg = mlogmsg || 'Sorry about that.'
      call logit;                                                               /* jak */
      say mlogmsg;                                                              /* jak */

exit;

defaults:
/*ͻ*/
/* (defaults)           Set default values:                               */
/*                                                                        */
/*                      Starting queue name length:    0                  */
/*                      Queue name length increment:  15                  */
/*                      Maximum queue name length:   255                  */
/*                      Logging level:                 6                  */  /* jak */
/*                      Log file prefix:           maxqs                  */  /* jak */
/*ͼ*/

      /* queue size defaults */                                                 /* jak */

      if startlq='' then startlq=0;
      if lngqi='' then lngqi=15;
      if maxlngq='' then maxlngq=255;

      /* log file name default */                                               /* jak */

      msgtag = '(RXQMAXQS) ';                                                   /* jak */
      if loglevel = '' then loglevel = 6;                                       /* jak */
      if rxqmlogn = '' then rxqmlogn = 'maxqs';
      call STRIP rxqmlogn,'t'   /* strip trailing blanks from log filename */   /* jak */

      rxqmlog = rxqmlogn || '.log';

      erase rxqmlog; /* if a previous version exists */                         /* jak */

      /* start logging */                                                       /* jak */

      mlogmsg = time('L') || ' ' || msgtag;                                     /* jak */
      mlogmsg = mlogmsg || 'ENTER RXQMAXQS STRESS TEST';
      whatlevel = 1;                                                            /* jak */
      call logit;                                                               /* jak */
      say mlogmsg;                                                              /* jak */

      /* other variables to initialize */                                       /* jak */

      totalqs = 0;                      /* count of queues created */           /* jak */
      delqs = 0;                        /* count of deleted queues */           /* jak */

      /* log the queue sizes if we are debugging */                             /* jak */

      mlogmsg = time('L') || ' ' || msgtag;                                     /* jak */
      mlogmsg = mlogmsg || '(main) argument startlq = ' || startlq;
      whatlevel = 9;                                                            /* jak */
      call logit;                                                               /* jak */
      mlogmsg = time('L') || ' ' || msgtag;                                     /* jak */
      mlogmsg = mlogmsg || '(main) argument maxlngq = ' || maxlngq;
      call logit;                                                               /* jak */
      mlogmsg = time('L') || ' ' || msgtag;                                     /* jak */
      mlogmsg = mlogmsg || '(main) argument lngqi   =' || lngqi;
      call logit;                                                               /* jak */

return;

filllong:
/*ͻ*/
/* (filllong)           Fill the character table for making longnames     */
/*                                                                        */
/*                      The table has upper, lower and digit character    */
/*                      graphics.                                         */
/*                                                                        */
/*                      Input:                                            */
/*                         lngq        requested queue name length        */
/*                      Output:                                           */
/*                         lnbfr       long name of the requested length  */
/*ͼ*/

      s.1=64; f.1=90;          /* Initialize byte value range of digit numb.*/
      s.2=47; f.2=57;          /* Initialize byte value range of upper alph.*/
      s.3=96; f.3=122;         /* Initialize byte value range of lower alph.*/

        i=0;
        do while i < 256;       /* Build character array of initialized chrs */
         do j=1 to 3;           /* of the three ranges specified             */
          n=s.j;                /* by starting and                           */
          do while n < f.j;     /* stopping at each range                    */
           if i>255 then leave; /* to the limit of the byte value.           */
           i=i+1; n=n+1;
           ctbl.i=d2c(n);       /* assign character to the array.            */

          end;                  /* loop of range.                            */
         end;                   /* loop of 3 ranges.                         */
        end;                    /* loop of byte value.                       */

return; /* end of filllong */

makelong:
/*ͻ*/
/* (makelong)           Build a longname of length requested              */
/*                                                                        */
/*                      The longname has upper, lower and digit character */
/*                      graphics, and is taken from the character table   */
/*                      built by the 'filllong' routine.                  */
/*                                                                        */
/*                      Input:                                            */
/*                         lngq        requested queue name length        */
/*                         ctbl        the character table                */
/*                      Output:                                           */
/*                         lnbfr       long name of the requested length  */
/*ͼ*/

      mlogmsg = time('L') || ' ' || msgtag;                                     /* jak */
      mlogmsg = mlogmsg || '(makelong) Generating long names of length '
      mlogmsg = mlogmsg || lngq;
      whatlevel = 5;                                                            /* jak */
      call logit;                                                               /* jak */
      say mlogmsg;

/*      signal off novalue;             */
        lnbfr='';
/*      signal on novalue;              */
        if lngq<>'' & lngq=0 then  /* For the size of the queue name     */    /* jak */
         do l=1 to lngq;
          lnbfr = lnbfr||ctbl.l;      /* assign characters of the array to  */
         end;                         /* string buffer.                     */

return; /* end of longname */

makequeues:                                                                     /* jak */
/*ͻ*/
/* (makequeues)         Create queues                                     */  /* jak */
/*                                                                        */
/*                      Each queue will be given a unique name so that    */
/*                      it may be deleted after as many queues as         */
/*                      possible have been created.                       */
/*                                                                        */
/*                      The name of each queue will include a unique      */
/*                      one- to three-digit number, and a longname of     */
/*                      variable length.                                  */
/*                                                                        */
/*                             Qilnbfr                                    */
/*                                                                        */
/*                      where                                             */
/*                             i      is a 1-3 digit number for the queue */
/*                             lnbfr  is the long name appended           */
/*                                                                        */
/*                      Input:                                            */
/*                         lnbfr      the longname created by the         */
/*                                    longname routine                    */
/*ͼ*/

      mlogmsg = time('L') || ' ' || msgtag;                                     /* jak */
      mlogmsg = mlogmsg || '(makequeues) Creating maximum number of queues';    /* jak */
      whatlevel = 7;                                                            /* jak */
      call logit;                                                               /* jak */
      say mlogmsg;

      i = 1;
      totalqs = 0;
      newqname = 'Q';   /* just a starting value for new queue name */

      do until length(newqname) = 0;
         qname='Q' || i || lnbfr;
         mlogmsg = time('L') || ' ' || msgtag;                                  /* jak */
         mlogmsg = mlogmsg || '(makequeues) Attempting to create ';             /* jak */
         mlogmsg = mlogmsg || 'queue number: ' || i || '; name: ' || qname;     /* jak */
         whatlevel = 9;                                                         /* jak */
         call logit;                                                            /* jak */

/*       signal off novalue;            */
         newqname=RXQUEUE('Create',qname);
/*       signal on novalue;             */

         if length(newqname) = 0 then do;
            mlogmsg = time('L') || ' ' || msgtag;                               /* jak */
            mlogmsg = mlogmsg || '(makequeues) Cannot open queue name '
            mlogmsg = mlogmsg || qname;
            whatlevel = 4;                                                      /* jak */
            call logit;                                                         /* jak */
            say mlogmsg;
            leave;
         end;
         else do;
            mlogmsg = time('L') || ' ' || msgtag;                               /* jak */
            mlogmsg = mlogmsg || '(makequeues) Queue created; number: '
            mlogmsg = mlogmsg || i || '; name: ' || newqname;
            whatlevel = 7;                                                      /* jak */
            call logit;                                                         /* jak */
            totalqs = totalqs + 1;
         end;

         i = i + 1;
         if i > 9999999 then i = 1;
      end;

      mlogmsg = time('L') || ' ' || msgtag;                                     /* jak */
      mlogmsg = mlogmsg || '(makequeues) ' || totalqs || ' queues created';
      whatlevel = 5;
      call logit;
      say mlogmsg;

return;  /* end of makequeues */                                                /* jak */

delqueues:                                                                      /* jak */
/*ͻ*/
/* (delqueues)          Cleanup queues                                    */
/*                                                                        */
/*                      Input:                                            */
/*                         startdel    Which queue to start with          */
/*                         totalqs     Number of qs that were created     */
/*                         lnbfr       Long name                          */
/*ͼ*/

      delqs = startdel - 1;             /* count of deleted queues */           /* jak */

      mlogmsg = time('L') || ' ' || msgtag;                                     /* jak */
      mlogmsg = mlogmsg || '(delqueues) Deleting queues starting with queue ';  /* jak */
      mlogmsg = mlogmsg || startdel;                                            /* jak */
      whatlevel = 5;                                                            /* jak */
      call logit;                                                               /* jak */
      say mlogmsg;
      dq = 0;                           /* starting value for delete-queue return code */
      do i=startdel to totalqs by 1;
         qname='Q' || i || lnbfr;

         /* save the queue name so that we can report it after  */
         /* trying to delete it                                 */

         dqname = qname;

         dq = RXQUEUE('Delete',qname);
         if dq = 0 then do;
            mlogmsg = time('L') || ' ' || msgtag;                               /* jak */
            mlogmsg = mlogmsg || '(delqueues) Queue deleted; number: '          /* jak */
            mlogmsg = mlogmsg || i || '; name: ' || dqname;                     /* jak */
            whatlevel = 7;                                                      /* jak */
            call logit;                                                         /* jak */
            delqs = delqs + 1;
         end;
         else do;
            mlogmsg = time('L') || ' ' || msgtag;                               /* jak */
            mlogmsg = mlogmsg || '(delqueues) Cannot delete queue name ';
            mlogmsg = mlogmsg || dqname || '; return code is ' || dq;           /* jak */
            whatlevel = 4;                                                      /* jak */
            call logit;                                                         /* jak */
            say mlogmsg;                                                        /* jak */
         end;
      end;

      mlogmsg = time('L') || ' ' || msgtag;                                     /* jak */
      mlogmsg = mlogmsg || '(delqueues) ' || delqs || ' queues deleted';        /* jak */
      whatlevel = 5;                                                            /* jak */
      call logit;                                                               /* jak */
      say mlogmsg;                                                              /* jak */

return;  /* end of delqueues */                                                 /* jak */

didwepass:                                                                      /* jak */
/*ͻ*/
/* (didwepass)           Print PASS or FAIL message for this pass         */  /* jak */
/*ͼ*/

      mlogmsg = time('L') || ' ' || msgtag;                                     /* jak */
      mlogmsg = mlogmsg || '(didwepass) ' || totalqs || ' qs created; ';        /* jak */
      mlogmsg = mlogmsg || delqs || ' deleted; long name length ' || lngq;      /* jak */
      whatlevel = 5;                                                            /* jak */
      call logit;                                                               /* jak */
      say mlogmsg;                                                              /* jak */

      if delqs=totalqs then do;
         mlogmsg = time('L') || ' ' || msgtag;                                  /* jak */
         mlogmsg = mlogmsg || '(didwepass) RXQMAXQS PASSED for ';               /* jak */
         mlogmsg = mlogmsg || 'long name length ' || lngq;                      /* jak */
      end;
      else do;
         mlogmsg = time('L') || ' ' || msgtag;                                  /* jak */
         mlogmsg = mlogmsg || '(didwepass) RXQMAXQS FAILED for ';               /* jak */
         mlogmsg = mlogmsg || 'long name length ' || lngq;                      /* jak */
      end;

      whatlevel = 1;                                                            /* jak */
      call logit;                                                               /* jak */
      say mlogmsg;                                                              /* jak */

return;  /* end of didwepass */                                                 /* jak */

logit:                                                                          /* jak */
/*ͻ*/  /* jak */
/* (logit)              Log a message if <= requested logging level       */  /* jak */
/*                                                                        */  /* jak */
/*                      Input:                                            */  /* jak */
/*                        whatlevel  level at or above which to log       */  /* jak */
/*                        mlogmsg    the message to be logged             */  /* jak */
/*                                                                        */  /* jak */
/*                      Globals:                                          */  /* jak */
/*                        rxqmlog    the name of the logfile              */  /* jak */
/*                        loglevel   logging level requested at startup   */  /* jak */
/*ͼ*/  /* jak */
                                                                                /* jak */
      if whatlevel <= loglevel then do;                                         /* jak */
         msgcnt = lineout(rxqmlog,mlogmsg);                                     /* jak */
      end;                                                                      /* jak */

return;  /* end of logit */                                                     /* jak */

cleanup:
/*ͻ*/  /* jak */
/* (cleanup)            Ctrl-Break and Ctrl-C handler.                    */  /* jak */
/*                                                                        */  /* jak */
/*                      We come here to clean up if Ctrl-Break or Ctrl-C  */  /* jak */
/*                      was pressed.  Clean-up consists of deleting any   */  /* jak */
/*                      queues that have been created up to now.          */  /* jak */
/*                                                                        */  /* jak */
/*                      Input:                                            */  /* jak */
/*                        totalqs    total number of queues that have     */  /* jak */
/*                                   been created up to now               */  /* jak */
/*ͼ*/  /* jak */

      mlogmsg = time('L') || ' ' || msgtag;                                     /* jak */
      mlogmsg = mlogmsg || '(cleanup) Ctrl-Break or Ctrl-C was pressed; '       /* jak */
      mlogmsg = mlogmsg || 'clean-up begins';                                   /* jak */
      whatlevel = 2;                                                            /* jak */
      call logit;                                                               /* jak */
      say mlogmsg;                                                              /* jak */

      if (totalqs > 0) then do;                                                 /* jak */
         if (delqs > 0) then do;                                                /* jak */
            if (delqs < totalqs) then do;                                       /* jak */
               startdel = (totalqs - delqs) + 1; /* next queue to delete */     /* jak */
            end;                                                                /* jak */
            else do;                                                            /* jak */
               startdel = 1;                                                    /* jak */
            end;                                                                /* jak */
         end;                                                                   /* jak */
         else do;                                                               /* jak */
            startdel = 1;                                                       /* jak */
         end;                                                                   /* jak */
         call delqueues;  /* delete the rest of the qs */                       /* jak */
         call didwepass;   /* did we pass or fail for this longname length? */  /* jak */
      end;                                                                      /* jak */

      call ending;                                                              /* jak */

exit;  /* end of cleanup */                                                     /* jak */

ending:                                                                         /* jak */
/*ͻ*/  /* jak */
/* (ending)             End of the test                                   */  /* jak */
/*ͼ*/  /* jak */

      mlogmsg = time('L') || ' ' || msgtag;                                     /* jak */
      mlogmsg = mlogmsg || 'EXIT RXQMAXQS STRESS TEST';                         /* jak */
      whatlevel = 1;                                                            /* jak */
      call logit;                                                               /* jak */
      say mlogmsg;                                                              /* jak */
/*    call off halt;        */  /* turn off Ctrl-Break handler */               /* jak */

return;  /* end of ending */
