/*  RXQSINGR.CMD  */
/*============================================================================*/
/*    Program  ID    :  RXQSINGR.CMD - IBM Confidential                       */
/*    Filename       :  RXQSINGR.CMD                                          */
/*    Author(s)      :  Jack Kipp                                             */
/*                      IBM System Test Group, Delray Beach, FL               */
/*    Based on       :  Tony Ingenoso's STRQ01B.C                             */
/*                      from OS/2 base queue stress system test suite         */
/*    Date Written   :  1/6/89                                                */
/*    Date Revised   :  see Revision History below                            */
/*                                                                            */
/*    Command line for this test :                                            */
/*                                                                            */
/*    RXQSINGR qname qsize method variety logprefx loglevel                   */
/*                                                                            */
/*      all of these parameters are determined by caller program RXQSINGQ.CMD.*/
/*      DO NOT TRY TO RUN THIS PROGRAM BY ITSELF.                             */
/*      IT IS INTENDED TO BE STARTED BY RXQSINGQ.CMD.                         */
/*                                                                            */
/*    qname   - assigned by REXX on RxCreate call in RXQSINGQ.CMD             */
/*    qsize   - one of the queue sizes, based on RXQSINGQ.CMD queue size args */
/*    method  - 'FIFO' or 'LIFO' access                                       */
/*    variety - 'NAMED' or 'SESSION' queue                                    */
/*    loglevel- for TESTLOG utility used by C program RXQSINGL (6 default)    */
/*    logprefx- log file prefix (maximum 4 chars, prefixes a 4-digit #)       */
/*                                                                            */
/*    REXX calls     :  none (this is just a front-end to the C program)      */
/*                                                                            */
/*    Comments       :  Tests FIFO & LIFO Qs, named and session queues.       */
/*                                                                            */
/*                      This REXX program is called from REXX program         */
/*                      RXQSINGQ.CMD.  This one is the front end to the       */
/*                      C program, RXQSINGL.EXE, that verifies the            */
/*                      contents of the queue that was written by             */
/*                      RXQSINGQ.CMD.                                         */
/*                                                                            */
/*                      The chief purpose of this front end is to make        */
/*                      sure that the C program that verifies the queue       */
/*                      is run in a separate session from the REXX program    */
/*                      that creates and fills the queue.                     */
/*                                                                            */
/*                      Another benefit of this batch file is that it uses    */
/*                      its exit command to make sure that the screen group   */
/*                      it is given will go away when it is done.             */
/*                                                                            */
/******************************************************************************/
/*                                                                            */
/*  PSEUDOCODE -                                                              */
/*     1.    Build the log file name from the other arguments.                */
/*     2.    Set up the command to start the C program.                       */
/*     3.    Run the C program.                                               */
/*                                                                            */
/******************************************************************************//* jak */
/*                            revision history                                *//* jak */
/*                                                                            *//* jak */
/*   Date     OS/2       Name                 Description                     *//* jak */
/* --------  -------  -----------  -----------------------------------------  *//* jak */
/*  2/21/89  SE 1.20  J. Kipp      SINGLEQR.CMD renamed to RXQSINGR.CMD       *//* jak */
/*  2/21/89  SE 1.20  J. Kipp      SINGLEQ.CMD renamed to RXQSINGQ.CMD        *//* jak */
/*  2/21/89  SE 1.20  J. Kipp      SINGLEQS.EXE renamed to RXQSINGL.EXE       *//* jak */
/*  3/23/89  SE 1.20  J. Kipp      Do not allow Ctrl-Break to take effect     *//* jak */
/******************************************************************************//* jak */

   arg qname qsize method variety loglevel logprefx

/*ͻ*/
/* (main)               Build the log file name                           */
/*ͼ*/

      call off halt;

      logfile = logprefx || qsize || '.LOG';    /* build logfile name */

/*ͻ*/
/*                      Build the command line for the C program          */
/*ͼ*/

      cmdline = 'rxqsingl.exe';                                                                                         /* jak */
      cmdline = cmdline || ' -Crxqsingl..' || method || '..' || variety || '..' || qsize || '..in..progress..';         /* jak */
      cmdline = cmdline || ' -V'    || qname;     /* qname to Verify */
      cmdline = cmdline || ' -n'    || qsize;     /* size of queue */
      cmdline = cmdline || ' -q'    || method;    /* FIFO or LIFO */
      cmdline = cmdline || ' -v'    || variety;   /* NAMED or SESSION */
      cmdline = cmdline || ' -f'    || logfile;   /* WRITELOG file */
      cmdline = cmdline || ' -l'    || loglevel;  /* WRITELOG logging level */

/*ͻ*/
/*                      NOW RUN THE C PROGRAM                             */
/*ͼ*/

      say '(sngq.2) About to run the C part of this test as follows:';
      say '(sngq.2)' cmdline;

      cmdline;

/*ͻ*/
/*                      End this session                                  */
/*ͼ*/

exit;
