/*  RXQSINGS.CMD  */
/*============================================================================*/
/*      Program  ID    :  RXQSINGS  - IBM Confidential                        */
/*      Filename       :  RXQSINGS.CMD                                        */
/*      Author(s)      :  Jack Kipp, IBM System Test, Delray Beach, FL        */
/*      Based on       :  RXQMAXQS.CMD amd RXQSINGQ.CMD, written by J. Kipp   */
/*      Date Written   :   4/20/89                                            */
/*      Date Revised   :  na                                                  */
/*                                                                            */
/*      Command line for this test :                                          */
/*                                                                            */
/*      RXQSINGS qname qsize variety logfile loglevel                         */
/*                                                                            */
/*      qname   - name of queue                                               */
/*      qsize   - size of queue; number of entries in it                      */
/*      variety - 'NAMED' or 'SESSION'                                        */
/*      logfile - name of logfile                                             */
/*      loglevel- for logging any messages (6 default)                        */
/*                                                                            */
/*      all of these parameters are determined by caller program RXQSINGR.CMD.*/
/*      DO NOT TRY TO RUN THIS PROGRAM BY ITSELF.                             */
/*      IT IS INTENDED TO BE STARTED BY RXQSINGR.CMD.                         */
/*                                                                            */
/*      REXX calls     :  RXQUEUE('Set'), PULL, RXQUEUE('Delete')             */
/*                                                                            */
/*      Comments       :  Queue limits test,                                  */
/*                           max # of elements in a queue                     */
/******************************************************************************/
/*   PSEUDOCODE -                                                             */
/*   Read command line arguments.                                             */
/*   Initialize variables.                                                    */
/*   Purge queue <qname> of its <qsize> elements.                             */
/*   Delete queue if it is not a session queue.                               */
/*   Say if we pass or fail.                                                  */
/*   Exit.                                                                    */
/******************************************************************************//* jak */
/*                            revision history                                *//* jak */
/*                                                                            *//* jak */
/*   Date     OS/2       Name                 Description                     *//* jak */
/* --------  -------  -----------  -----------------------------------------  *//* jak */
/*  4/20/89  SE 1.20  J. Kipp      no reason whatsoever; just piddling        *//* jak */
/******************************************************************************//* jak */

   arg qname qsize variety logfile loglevel

/*ͻ*/
/* (main)               Here is the start of the program                  */
/*ͼ*/

       call off halt;   /* ignore Ctrl-Break & Ctrl-C key presses */
       call initialize; /* set initial values */
       call purgeq;     /* read & dispose of each queue entry */

       if variety ^= 'SESSION' then do;
          call deleteq;  /* delete queue if it is not session queue */
       end;

       call passfail;   /* did we pass or fail? */
       call ending;

exit;  /* end of main program */

initialize:
/*ͻ*/
/* (initialize)         Set initial values                                */
/*ͼ*/

      logmsg = 'ENTER RXQSINGQ STRESS TEST';
      whatlevel = 1;
      call logit;
      say logmsg;

      failcount = 0;    /* to start; if nonzero, test fails */

      /* data items for each queue entry */

      dqsize = 0;       /* q size */
      dqrecnum = 0;     /* q record # */
      dhash = 0;        /* hash value */

return;  /* end of defaults */

purgeq:
/*ͻ*/
/* (purgeq)             Purge the active queue                            */
/*                                                                        */
/*                      Input:                                            */
/*                        qsize      number of elements in the queue      */
/*ͼ*/

       logmsg = '(purgeq) About to purge ' || qsize || ' elements from queue ' || qname;
       say logmsg;

       /* purge the queue */

       purgecount = 0;
       do qrecnum = 1 by 1 to qsize;
          PULL dqsize dqrecnum dhash;
          purgecount = purgecount + 1;
       end;

       /* log purge results */

       logmsg = '(purgeq) Elements added = ' || qsize || '; elements purged = ' || purgecount;
       whatlevel = 5;
       call logit;
       say logmsg;

return;  /* end of purgeq */

deleteq:
/*ͻ*/
/* (deleteq)            Delete the active queue                           */
/*                                                                        */
/*                      Input:                                            */
/*                        qname      the name of the queue to clean up    */
/*ͼ*/

       /* delete queue and log deletion results */

       dq = RXQUEUE('Delete',qname);
       if dq ^= 0 then do;
          logmsg = '(deleteq) Failed to delete queue ' || qname || '; result is ' || dq || '; should be 0';
          whatlevel = 4;
          failcount = failcount + 1;
       end;
       else do;
          logmsg = '(deleteq) Deleted queue ' || qname;
          whatlevel = 5;
       end;
       call logit;
       say logmsg;

return;  /* end of deleteq */

passfail:
/*ͻ*/
/* (passfail)           Print PASS or FAIL message                        */
/*                                                                        */
/*                      Input:                                            */
/*                        failcount  the # of times we just plain goofed  */
/*ͼ*/

      if failcount = 0 then do;
         mlogmsg = 'RXQSINGS PASSED';
      end;
      else do;
         mlogmsg = 'RXQSINGS FAILED';
      end;

      whatlevel = 1;
      call logit;
      say mlogmsg;

return;  /* end of passfail */

logit:
/*ͻ*/
/* (logit)              Log a message if <= requested logging level       */
/*                                                                        */
/*                      Input:                                            */
/*                        whatlevel  level at or above which to log       */
/*                        mlogmsg    the message to be logged             */
/*                                                                        */
/*                      Globals:                                          */
/*                        logfile    the name of the logfile              */
/*                        loglevel   logging level requested at startup   */
/*ͼ*/

      if whatlevel <= loglevel then do;
         msgcnt = lineout(logfile,mlogmsg);
      end;

return;  /* end of logit */

ending:
/*ͻ*/
/* (ending)             End of the test                                   */
/*ͼ*/

      mlogmsg = 'EXIT RXQSINGS STRESS TEST';
      whatlevel = 1;
      call logit;
      say mlogmsg;

return;  /* end of ending */
