/***************************************************************************/
/*                                                                         */
/*    This REXX file setups the SCRIPT directory in LDU server to each     */
/*    individual script based on type of machines in the STRESS lab.       */
/*    The Master SCRIPT directory is kept intact, just specific files      */
/*    are copied over sub-SCRIPT directories for each individual type.     */
/*    These individual script directories help reduce the number of        */
/*    file transfer.                                                       */
/*                                                                         */
/*    Written on 1/24/1992                                                 */
/*    The Install Group of STRESS department                               */
/*                                                                         */
/***************************************************************************/

'@echo on'
type.1=1                    /* Assigning machine types to variables */
type.2=2
type.3=3
type.4=4
type.5=5
type.6=6
type.7=7
type.8=8
type.9=9
type.10=C
type.11=H
type.12=M
type.13=P
type.14=T
type.15=X
type.16=Y
type.17=Z


do i = 1 to 17                    /*  making scriptX directories  */
'if not exist d:\script'type.i ' md d:\script'type.i
end


'rxqueue /clear'
'dir d:\script\* /f | rxqueue /fifo'

do i = 1 to 2
   pull filename
   end i

do queued()
  pull filename
  position = pos('-',filename)
  if position = 0          /* No '-' in filename, copy it since generic */
    then do i = 1 to 17
      say 'Copy  'filename    'D:\SCRIPT'type.i'
      'copy 'filename 'd:\script'type.i' >nul'
     end i
    else do                              /* Check for other machine type */
      ftype = delstr(filename,1,position)
      filetype = delstr(ftype,2)
      do i = 1 to 17
         if filetype = type.i then do
           say ' Copy 'filename     'D:\SCRIPT'type.i
           'copy 'filename  'd:\script'type.i ' >nul'
           end
         end i
     end   /* end else */
end  /* end do */
exit
