/* TEST.CMD to test automation                                        */
/* Parse fails one log file, update status tool                       */



/* CALL rexx functions and get command line arguments.                */

call RxFuncAdd 'SysFileTree','RexxUtil','SysFileTree'

ARG testname failslog

/* OEM Machine information                                            */

oem.1.name = 'SPV41'
oem.1.type = 'NCR'

oem.2.name = 'SPV43'
oem.2.type = 'TOSHIBA'

oem.3.name = 'SMV32'
oem.3.type = 'COMPAQ'

oem.4.name = 'SMV33'
oem.4.type = 'COMPAQ'

oem.5.name = 'S8V18'
oem.5.type = 'SIEMANS'

oem.6.name = 'SYV19'
oem.6.type = 'SIEMANS'

oem.7.name = 'SMV14'
oem.7.type = 'AST'

oem.8.name = 'SPV05'
oem.8.type = 'AST'

oem.9.name = 'SPV06'
oem.9.type = 'AST'

oem.10.name = 'SMV20'
oem.10.type = 'OLIVETTI'

oem.11.name = 'SPV15'
oem.11.type = 'OLIVETTI'

oem.12.name = 'SMV40'
oem.12.type = 'GATEWAY'

oem.13.name = 'SPV42'
oem.13.type = 'ZENITH'


        IF testname = '' THEN DO
                exit_code = 2
                CALL EXIT_ROUTINE exit_code;
                END
        IF failslog = '' THEN DO
                exit_code = 2;
                CALL EXIT_ROUTINE exit_code;
                END

        testinfo = linein('test.inf') ;
        line     = SUBWORD(testinfo,1,1)
        driver = SUBWORD(testinfo,2,1)
        specparm = SUBWORD(testinfo,3,1)
        machine = VALUE('USERNAME',,'OS2ENVIRONMENT')

/* Check to see if the test is DPMI of MFSYS and add -machine type if so */

        IF testname = 'DPMI' THEN
                testname = testname||'-'||SUBSTR(machine,2,1)
        IF testname = 'MFSYS' THEN
                testname = testname||'-'||SUBSTR(machine,2,1)

/* Check to see if machine is an OEM, if yes redo test name for status */
        index = 1;
        DO 13
                match = compare(oem.index.name, machine);
                        IF match = 0 THEN DO
                           parse var testname temp1 '-' temp2
                           testname = temp1||'-'||oem.index.type
                           LEAVE
                           END
                        ELSE
                                index = index + 1;
        END  /* do end */

                if specparm = NULL THEN
                    NOP;
                else
                    machine = specparm;

/* Parse runtime.log to get time                                      */

      linesrem = 1;
      Do While linesrem = 1
          runtimestring = linein('d:\log\runtime.log');
          check = SUBWORD(runtimestring,1,1)
                IF check = 'Total' Then Do
                     time = SUBWORD(runtimestring,6,1)
                END
          linesrem = lines('d:\log\runtime.log');
      END

       rc = lineout('d:\log\runtime.log');  /* Close the runtime.log */

/* Check the fails log for errors                                       */
/* Call parselog procedure which looks for fail files in fails1 log,    */
/*   if file found, sends filename to look procedure which checks       */
/*   against list of known errors.                                      */

/* call parselog result failslog;*/  /* commenting this out temporarily */

/* SAY " result = " result */
result = 0;


output = line'  'driver'  'testname'  'machine'  'time'  'result;

SAY "output = " output
SAY "machine = " machine
SAY "specparm = " specparm

        IF result = 0 then do
              rc = lineout('d:\log\test.log' ,output);
              rc = lineout('d:\log\test.log');
              bend = 1;   /* parameter to tell statbat this is end of test */
              pfb=0;
              'netserv cmd statserv d:\status\statbat.cmd '||line driver testname pfb time machine bend;
              exit_code = 0;
              CALL EXIT_ROUTINE exit_code;
              END
        IF result = 1 then do
                exit_code = 1;
                CALL EXIT_ROUTINE exit_code;
               END





EXIT

/*******************************************************************/
/* PARSELOG procedure - parse the fails log                        */
/*******************************************************************/
parselog: procedure expose result failslog;

            linesrem = lines(failslog);      /* check to see if failslog has any */
                  IF linesrem = 0  THEN DO      /* data, if not no errors    */
                      result = 0;
                      return result;
                      END

filenum = 0;
index = 0;


      Do While linesrem = 1
          stringin = linein(failslog) ;
          check = SUBWORD(stringin,1,1)
                IF check = 'File' Then Do
                     filenum = filenum + index;
                     call look stringin filenum result;
                     index = 1;
                         IF result = 1 then
                            return result;
                END
          linesrem = lines(failslog);
      End
      rc = lineout(failslog);        /* close failslog */
      return 0;

/*******************************************************************/
/*  Look Procedure - Checks fails log for known errors.            */
/*                                                                 */
/*******************************************************************/

look: procedure expose stringin filenum result

    error.0  = FSDH30.
    error.1  = FSDH60.
    error.2  = PIPEH45.
    error.3  = SCRH20.
    error.4  = FSDIR.
    error.5  = SCRIBBLE.
    error.6  = VIDEO.
    error.7  = GPIFLOOD.
    error.8  = SCRH10.
    error.9  = GFLM330.
    error.10 = SCRH70.
    error.11 = SCRH040.
    error.12 = FSDH20.
    error.13 = SCRH20.
    error.14 = DIRC00.
    error.15 = DIRE00.
    error.16 = DIRI00.
    error.17 = DIRG00.
    error.18 = DIRK00.
    error.19 = DIRM00.
    error.20 = DIRL00.
    error.21 = DIRH00.
    error.22 = LOCM05.
    error.23 = LOCL05.
    error.24 = DELL10.
    error.25 = DELM10.
    error.26 = RANDM15.
    error.27 = RANDL15.
    error.28 = SEQL20.
    error.29 = SEQM20.
    error.30 = DIRH25.
    error.31 = DIRL25.
    error.32 = DIRJ25.
    error.33 = LOCM25.
    error.34 = DIRC25.
    error.35 = DIRI25.
    error.36 = SEQL25.
    error.37 = DELL25.
    error.38 = DIRK25.
    error.39 = RANDL25.
    error.40 = DIRG25.
    error.41 = RANDM25.
    error.42 = DELM25.
    error.43 = DIRM25.
    error.44 = SEQM25.
    error.45 = LOCL25.
    error.46 = DIRC135.
    error.47 = DIRK135.
    error.48 = DIRJ135.
    error.49 = DIRI135.
    error.50 = LOCM135.
    error.51 = DIRM135.
    error.52 = DIRC235.
    error.53 = DELM135.
    error.54 = SEQM135.
    error.55 = DELL135.
    error.56 = DIRH135.
    error.57 = RANDM135.
    error.58 = DIRG135.
    error.59 = SEQL135.
    error.60 = DIRL135.
    error.61 = RANDL135.
    error.62 = LOCL135.
    error.63 = DIRJ00.
    error.64 = LOCI05.
    error.65 = DIRC25.
    error.66 = FONTD.
    error.67 = KBDSX61.
    error.68 = KBDSX81.
    error.69 = GFLM310.
    error.70 = GFLM370.
    error.71 = FSDEH050.
    error.72 = FSDIH060.
    error.73 = VIDH120.

    pos1 = WORDPOS('#'||filenum||'==>',stringin,1);
    stringout.filenum = SUBWORD(stringin, pos1+1 ,1);
        num = 0;

        Do 73
        match = compare(error.num, stringout.filenum)
                if match = 0 then do
                        result = 0;
                        return result;
                     END
                else
                        nop;
        num = num + 1;
        end

        result = 1;
        return result;

/*******************************************************************/
/* EXIT_ROUTINE  procedure -  exit the routine                     */
/*******************************************************************/
EXIT_ROUTINE: procedure expose exit_code;

        IF exit_code = 0 THEN DO
                frc = lineout('d:\log\pfb.log', 'PASS');
                frc = lineout ('d:\log\pfb.log');
                SAY "exit code 0"
                END
        IF exit_code = 1 THEN DO
                frc = lineout('d:\log\pfb.log', 'FAIL');
                frc = lineout ('d:\log\pfb.log');
                SAY "exit code 1"
                END
        IF exit_code = 2 THEN DO
                frc = lineout('d:\log\pfb.log', 'ABORT');
                frc = lineout ('d:\log\pfb.log');
                END
        EXIT
