/* tents.cmd */
/* run makesign.cmd to make tents for each stress machine       */
/* needed to test the specified fixpack driver                  */

arg drv dat .
if drv='' then do
 say 'please specify driver (e.g. XR_W033 [default = XR_W033]):'
 pull drv
 if drv='' then drv = 'XR_W033'
end
if dat='' then do
 say 'please specify driver date (e.g. 18Nov1997 [default = 01Jan1996]):'
 pull dat
 if dat='' then dat = '01Jan1996'
end
if substr(drv,4,1)='W' then do                  /* Warp 3 tents */
 'del stressx.out'                              /* delete previous tents */
 'del stressm.out'
 'del stressy.out'
 'del stresst.out'
 'del stress6.out'
 'del stress7.out'
 'del stress9a.out'
 'del st320l.out'
 'del st320u.out'
 'del stastsmp.out'
 call makesign drv dat STRESSX stressx.out      /* make new tents */
 call makesign drv dat STRESSM stressm.out
 call makesign drv dat STRESSY stressy.out
 call makesign drv dat STRESST stresst.out
 call makesign drv dat STRESS6 stress6.out
 call makesign drv dat STRESS7 stress7.out
 call makesign drv dat STRESS9A stress9a.out
 call makesign drv dat ST320L st320l.out
 call makesign drv dat ST320U st320u.out
 call makesign drv dat STASTSMP stastsmp.out
 'copy stressx.out lpt1:'                       /* print new tents */
 'copy stressm.out lpt1:'
 'copy stressy.out lpt1:'
 'copy stresst.out lpt1:'
 'copy stress6.out lpt1:'
 'copy stress7.out lpt1:'
 'copy stress9a.out lpt1:'
 'copy st320l.out lpt1:'
 'copy st320u.out lpt1:'
 'copy stastsmp.out lpt1:'
end;
if substr(drv,4,1)='M' then do                  /* Warp 4 (Merlin) tents */
 'del stressm.out'                              /* delete previous tents */
 'del stressy.out'
 'del stresst.out'
 'del stmicron.out'
 'del st750c.out'
 'del stmod95.out'
 call makesign drv dat STRESSM stressm.out      /* make new tents */
 call makesign drv dat STRESSY stressy.out
 call makesign drv dat STRESST stresst.out
 call makesign drv dat STMICRON stmicron.out
 call makesign drv dat ST750C st750c.out
 call makesign drv dat STMOD95 stmod95.out
 'copy stressm.out lpt1:'                       /* print new tents */
 'copy stressy.out lpt1:'
 'copy stresst.out lpt1:'
 'copy stmicron.out lpt1:'
 'copy st750c.out lpt1:'
 'copy stmod95.out lpt1:'
end;
