#-----------------------------------------------------------------------------
# PROJEKT         IBM SB Terminals
#
# NAME            SBSPRT02.MAK
#
# CONTENT         Makefile for building Statement Printer Server.
#-----------------------------------------------------------------------------
# created         from [az] at 26.05.94  Andreas Zimprich AZ Electronic GMBH
#
# changed         from [az] at 14.10.94  Andreas Zimprich AZ Electronic GMBH
#                 Deleted common path define because this is a special version
#                 for use with CMVC.
# changed         from [01SW] at 01.04.96  Sylvia Weber AZ Electronic GmbH
#                 - twg_srv.bic included;
# changed         from [01SW] at 16.04.96  Sylvia Weber AZ Electronic GmbH
#                 - sblogs.h, sbutfct.h, sbdefc and sbnmsc.h added
#                 - new libs: sbnms and sbutfct added
#
#  01/07/98 U. Haller     Changes to create more general makefiles.
#                         - Put '.def' file as inline file into makefile
#                           to reduce number of required files.
#                         - Change file to link via ICC instead of
#                           directly calling the linker.
#
#
#-----------------------------------------------------------------------------
#- c   = no link
#- Fi+ = make precomp headers
#- Si+ = use precomp headers
#- G3  = 386-code
#- Gs- = stack checking on
#- Gm+ = multithreaded
#- Gd- = dynamic linking to runtime-libs
#- Gn  = don't generate default-libs-search
#- O-  = don't optimize
#- Q   = quiet operation
#- W3  = warning level 3
#- K** = generate all sorts of warnings
#- Ss  = allow //
#- Xi  = don't use INCLUDE-environment-variable
#- Ti  = include symbols
#- I   = include-path
#- Ge- = make DLL
#-----------------------------------------------------------------------------
#
#
#
!Include twg_srv.bic
#
#---------------------------------------------------------------------
# Define name of executable.
#---------------------------------------------------------------------
NAME = trctest

#---------------------------------------------------------------------
# Define name of linker definition file.
#---------------------------------------------------------------------
DEFFILE = $(NAME).def

TARGETDIR=.

#---------------------------------------------------------------------
# Additional libraries for link.
#---------------------------------------------------------------------
LIBS = $(TARGETDIR)\sbutfct.lib

#---------------------------------------------------------------------
# Place to add/override runtime libraries.
#---------------------------------------------------------------------
RUNTIMELIBS = $(RUNTIMELIBS)

#---------------------------------------------------------------------
# Place to override linker flags.
#---------------------------------------------------------------------
LFL = $(LFL)

#---------------------------------------------------------------------
# Place to override compile flags for '.c' files.
#---------------------------------------------------------------------
CFL = $(CFL)

#---------------------------------------------------------------------
# Place to override compile flags for '.cpp' files.
#---------------------------------------------------------------------
CFLCPP = $(CFLCPP)

#---------------------------------------------------------------------
# Macro definitions for source modules
#---------------------------------------------------------------------
OBJECTS = trctest.obj \
          trctest1.obj

# ---------- Compiler switches -------------------------------------------
# See in TWG_SRV.BIC file
# ------------------------------------------------------------------------

#--- Generation of program ---
$(NAME).exe: $(OBJECTS) $(LIBS)
#---------------------------------------------------------------------
# Create linker '.def' file inline.
#---------------------------------------------------------------------
    rem <<$(DEFFILE)
NAME $(NAME) WINDOWCOMPAT

DESCRIPTION 'Trace Test'

PROTMODE
STACKSIZE   16000
<<KEEP
#---------------------------------------------------------------------
# Link the file using inline response file.
#---------------------------------------------------------------------
     $(LINKER) @<<
     $(LFLICC)
     $(OBJECTS)
     $(RUNTIMELIBS)
     $(LIBS)
     $(DEFFILE)
     $(LNKOUTPUTOPTION)$@
<<

#--- Compilation of modules ---
compile: $(OBJECTS)
#
#
# eof

#
# Individual File Dependencies
#
DEPEND = ehcdefc.h  \
         sbsprt00.h \
         sblogs00.h \
         sbutfct.h  \
         sbdefc.h   \
         sbnmsc.h   \
         c2sprt00.h \
         ibtwigyc.h \
         ibtwigyd.h

#UPDATE#
#
c2sprt00.obj: c2sprt00.c  $(DEPEND)

c2sprt02.obj: c2sprt02.c  $(DEPEND)

c2sprtsu.obj: c2sprtsu.c  $(DEPEND)

#ENDUPDATE#
