/*------------------------------------------------------------------------*/
/* Classification -  IBM Internal Use Only                                */
/*                                                                        */
/* Name           -  UPFILES  CMD                                         */
/* Programmer     -  Bryan Budak                                          */
/* Date Written   -  21 Aug  1997                                         */
/* Release Level  -  1.0                                                  */
/* Function       -                                                       */
/*                                                                        */
/* Change History -                                                       */
/*                                                                        */
/*                                                                        */
/*                                                                        */
/*------------------------------------------------------------------------*/

/*------------------------------------------------------------------------*/
/* Set the Global variables up.                                           */
/*------------------------------------------------------------------------*/
version = '1.0'
unmapped = 'A: B: C: D: E: F: G: H: I: J: K: L: M: N: O: P: Q: R: S: T: U: '||,
           'V: W: X: Y: Z:'

y = 1
z = 0

validfiles.0 = 2
validfiles.1 = 'FILE-P   FILE-X'
/*--------------------------------------------*/
/* These are files that upscript can't modify */
/*--------------------------------------------*/
just_return = '2'
validfiles.2 = 'MFSYS    MFSYS-P'

/*------------------------------------------------------------------------*/
/* Read in the parameters                                                 */
/*------------------------------------------------------------------------*/
parse upper arg filereq .

  /*----------------------------------------------------------------------*/
  /* Check to see if any parameters were specified                        */
  /*----------------------------------------------------------------------*/
  if filereq = '' then
    call BADPARM

  /*----------------------------------------------------------------------*/
  /* Validate the file specified                                          */
  /*----------------------------------------------------------------------*/
  located = '0'

  do h = 1 to validfiles.0
    if WORDPOS(filereq,validfiles.h) > 0 then
    do
      located = h
      LEAVE
    end
  end

  if located = 0 then
    call BADFILE

  if located >= just_return then
  do
    say ' '
    say ' Upscript has completed modifying:  'filereq
    say ' '
    say '     This file is supported but there isn''t anything to modify.'
    say ' '

    EXIT
  end

  fileorg = filereq || '.org'

  'echo off'

  /*----------------------------------------------------------------------*/
  /* Determine whether the "ORG" file has been created yet or not.  If not*/
  /* then copy the file passed in and make it the backed up version.      */
  /*----------------------------------------------------------------------*/
  if stream(filereq, 'C', 'query exists') == '' then
  do
    if stream(fileorg, 'C', 'query exists') == '' then
      call NOFILE filereq
    else
      'copy 'fileorg filereq
  end
  else
  do
    if stream(fileorg, 'C', 'query exists') == '' then
      'copy 'filereq fileorg

    'copy 'fileorg filereq
  end

  /*----------------------------------------------------------------------*/
  /* If the file exists then erase it so that we can create a new one     */
  /*----------------------------------------------------------------------*/
  if stream(filereq, 'C', 'query exists') \= '' then
    'erase' filereq

  /*----------------------------------------------------------------------*/
  /* Load the Rexx Utilies and the System Functions                       */
  /*----------------------------------------------------------------------*/
  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  call SysLoadFuncs

  /*----------------------------------------------------------------------*/
  /* Map all the drives used starting with 'A:'                           */
  /*----------------------------------------------------------------------*/
  map = SysDriveMap('A:', 'USED')

  /*----------------------------------------------------------------------*/
  /* Go thru all the mapped drives and verify which ones can be used for  */
  /* the testing.                                                         */
  /*----------------------------------------------------------------------*/
  do while y <= WORDS(map)
    drvltr = SUBWORD(map,y,1)

    info = SysDriveInfo(drvltr)

    if info = '' then
    do
      map = DELWORD(map,y,1)
      y = y - 1
    end
    else
      unmapped = DELWORD(unmapped, WORDPOS(drvltr, unmapped), 1)

    y = y + 1
  end

  say ' '
  say ' mapped drives =' map
  say ' '
  say ' unused drives =' unmapped
  say ' '

  /*----------------------------------------------------------------------*/
  /* Set up the variables for Mapped Drives and Unmapped Drives           */
  /*----------------------------------------------------------------------*/
  mdrv.0 = WORDS(map)

  do y = 1 to mdrv.0
    mdrv.y = SUBWORD(map,y,1)
    m1drv.y = SUBSTR(mdrv.y,1,1)
  end

  udrv.0 = WORDS(unmapped)

  do y = 1 to udrv.0
    udrv.y = SUBWORD(unmapped,y,1)
  end

  /*----------------------------------------------------------------------*/
  /* Read all the lines in so that each line can be scanned to see what   */
  /* needs to be commented out and uncommented.                           */
  /*----------------------------------------------------------------------*/
  do while LINES(fileorg) \= 0
    z = z + 1
    fileln.z = LINEIN(fileorg)
  end

  /*----------------------------------------------------------------------*/
  /* Close the file                                                       */
  /*----------------------------------------------------------------------*/
  cond = LINEOUT(fileorg)

  /*----------------------------------------------------------------------*/
  /* Start processing the file                                            */
  /*----------------------------------------------------------------------*/
  do tj = 1 to z
    if (tj // 100) = 0 then
    do
      if (tj % 100) = 1 then
        call CHAROUT ,' Processing '
      else
        call CHAROUT ,'.'
    end

    tmpline = TRANSLATE(fileln.tj)
    fnd = '0'

    if STRIP(tmpline) == '' |,
      SUBSTR(tmpline,1,2) == "''" |,
      POS('SWITCH.EXE',tmpline) > 0 then
      ITERATE

    if POS(':',tmpline) > 0 then
    do
      if POS('UPDATE:',tmpline) > 0 | POS('UPDATED:',tmpline) > 0 then
        ITERATE

      do db = 1 to mdrv.0
        if POS(mdrv.db,tmpline) > 0 then
        do
          fnd = '1'

          if substr(tmpline,1,2) == "''" then
            fileln.tj = DELSTR(fileln.tj,1,2)

          LEAVE
        end
      end

      if fnd = '0' then
      do
        if SUBSTR(fileln.tj,1,2) \= "''" then
          fileln.tj = "''" || fileln.tj
      end
    end
    else
    do
      select
        when filereq == 'FILE-X' |,
             filereq == 'FILE-P' then
          call MODFILE tj
        /*----------------------------------------------------------------*/
        otherwise
          NOP
      end
    end
  end

  /*----------------------------------------------------------------------*/
  /* Create the modified file with the unmapped files commented out.      */
  /*----------------------------------------------------------------------*/
  do y = 1 to z
    cond = LINEOUT(filereq,fileln.y)
  end

  /*----------------------------------------------------------------------*/
  /* Close the new file                                                   */
  /*----------------------------------------------------------------------*/
  cond = LINEOUT(filereq)

  say ' '
  say ' '
  say ' Modification of: 'filereq 'completed with the following drives supported:'
  say ' '
  say '     ' map
  say ' '

EXIT



/*------------------------------------------------------------------------*/
/*------------------------------------------------------------------------*/
/*                                                                        */
/*                       S U B R O U T I N E S                            */
/*                                                                        */
/*------------------------------------------------------------------------*/
/*------------------------------------------------------------------------*/
BADPARM: procedure

  say ' '
  say ' ***************************************************************************'
  say ' ** WARNING  WARNING  WARNING  WARNING  WARNING  WARNING  WARNING  WARNING**'
  say ' ***************************************************************************'
  say ' '
  say ' There wasn''t any file specified to be updated.  The correct syntax is:'
  say ' '
  say '     upfiles  file1'
  say ' '
  say '     where  file1 is the name of the file that should be updated'
  say ' '
  say ' Please try again!'
  say ' '

EXIT


/*------------------------------------------------------------------------*/
/*                                                                        */
/*------------------------------------------------------------------------*/
BADFILE: procedure expose filereq validfiles.

  say ' '
  say ' ***************************************************************************'
  say ' ** WARNING  WARNING  WARNING  WARNING  WARNING  WARNING  WARNING  WARNING**'
  say ' ***************************************************************************'
  say ' '
  say ' The file specified: 'filex' isn''t one of the files supported by this routine.'
  say ' '
  say ' The valid files are as listed:'
  say ' '

  do y = 1 to validfiles.0
    say '     'validfiles.y
  end

  say ' '
  say ' Please try again!'
  say ' '

EXIT


/*------------------------------------------------------------------------*/
/*                                                                        */
/*------------------------------------------------------------------------*/
NOFILE: procedure expose validfiles.

  parse arg fname .

  say ' '
  say ' ***************************************************************************'
  say ' ** WARNING  WARNING  WARNING  WARNING  WARNING  WARNING  WARNING  WARNING**'
  say ' ***************************************************************************'
  say ' '
  say ' The file specified: "'fname'" doesn''t exist the files supported by this routine.'
  say ' '
  say ' The valid files are as listed:'
  say ' '

  do y = 1 to validfiles.0
    say '     'validfiles.y
  end

  say ' '
  say ' Please try again!'
  say ' '

EXIT


/*------------------------------------------------------------------------*/
/*                                                                        */
/*------------------------------------------------------------------------*/
MODFILE: procedure expose m1drv. mdrv. tmpline fileln.

  parse arg tj .

  fndit = '0'

  /*----------------------------------------------------------------------*/
  /*                                                                      */
  /*----------------------------------------------------------------------*/
  if POS('EXPECTED', tmpline) > 0 & SUBSTR(tmpline,1,1) == '0' then
  do
    if DATATYPE(SUBSTR(tmpline,LENGTH(tmpline),1),'N') =  1 then
      minus = '1'
    else
      minus = '0'

    do y = 1 to mdrv.0
      if SUBSTR(tmpline,LENGTH(tmpline) - minus,1) = m1drv.y then
      do
        if SUBSTR(fileln.tj,1,2) == "''" then
          fileln.tj = DELSTR(fileln.tj,1,2)

        fndit = '1'
        LEAVE
      end
    end

    if fndit = 0 then
    do
      if SUBSTR(fileln.tj,1,2) \= "''" then
        fileln.tj = "''" || fileln.tj
    end
  end
  else if SUBSTR(tmpline,1,1) == '0' & SUBSTR(tmpline,LENGTH(tmpline),1) == ')' then
  do
    if DATATYPE(SUBSTR(tmpline,LENGTH(tmpline)-1,1),'N') =  1 then
      minus = '2'
    else
      minus = '1'

    do y = 1 to mdrv.0
      if SUBSTR(tmpline,LENGTH(tmpline) - minus,1) = m1drv.y then
      do
        if SUBSTR(fileln.tj,1,2) == "''" then
          fileln.tj = DELSTR(fileln.tj,1,2)

        fndit = '1'
        LEAVE
      end
    end

    if fndit = 0 then
    do
      if SUBSTR(fileln.tj,1,2) \= "''" then
        fileln.tj = "''" || fileln.tj
    end
  end

RETURN
