/*------------------------------------------------------------------------*/
/* Classification -  IBM Internal Use Only                                */
/*                                                                        */
/* Name           -  ADDHPFS  CMD                                         */
/* Programmer     -  Greg Rollins                                         */
/* Date Written   -  12 June 1990                                         */
/* Release Level  -  1.3                                                  */
/* Function       -  This should be run on machines having a FAT boot     */
/*                   drive with HPFS extended partitions.  This will add  */
/*                   add support to CONFIG.sys so HPFS extended drives    */
/*                   will be useable.                                     */
/*                                                                        */
/* Change History -                                                       */
/*   1.3   08/27/97  B. Budak                                             */
/*                   Check to see if the HPFS.IFS is already in the       */
/*                   config.sys file.  If not then add it and tell user   */
/*                   to remove disks, reboot and then start RSTRESS.      */
/*                                                                        */
/*------------------------------------------------------------------------*/
validdrvs = 'CDEFGHIJKLMNOPQRSTUVWXYZ'

parse upper arg bdrv .

  'echo off'

  if bdrv = '?' then call ADDHPFS_HELP

  if bdrv = '' then
  do
    say ' '
    say ' ADDHPFS is going to use the "C:" drive since you didn''t specify a'
    say ' drive letter.  If you want to change please hit "ALT-C" to exit this'
    say ' program and re-enter.'
    say ' '
    'pause'

    bdrv = 'c:'
  end
  else
  do
    drvltr = SUBSTR(bdrv,1,1)

    if POS(drvltr,validdrvs) = 0 then
      call BADPARM1
  end

  /*----------------------------------------------------------------------*/
  /* Update the config.sys for IFS if it is not installed already.        */
  /*----------------------------------------------------------------------*/
  fname = bdrv||'\config.sys'

  z = 0
  do while LINES(fname) \= 0
    z = z + 1
    cnfgln.z = LINEIN(fname)
  end

  cnfgln.0 = z

  cond = LINEOUT(fname)

  do y = 1 to cnfgln.0
    tmpline = TRANSLATE(cnfgln.y)

    if POS('HPFS.IFS',tmpline) > 0 then
    do
      say ' '
      say ' HPFS.IFS is already installed on your machine.  Found the following statement'
      say ' in your config.sys:'
      say ' '
      say '     'cnfgln.y
      say ' '

      EXIT
    end
  end

  'copy 'fname bdrv'\config.old'

  'echo IFS='bdrv'\OS2\HPFS.IFS /CACHE:64>> 'bdrv'\config.sys'

  'prompt CONFIG.SYS updated for HPFS -- Remove disks, reboot, and then RSTRESS!'

EXIT


/*------------------------------------------------------------------------*/
/*------------------------------------------------------------------------*/
/*                                                                        */
/*                       S U B R O U T I N E S                            */
/*                                                                        */
/*------------------------------------------------------------------------*/
/*------------------------------------------------------------------------*/

/*------------------------------------------------------------------------*/
/*                                                                        */
/*------------------------------------------------------------------------*/
ADDHPFS_HELP: procedure

  say ' '
  say ' ADDHPFS should be run on machines having a FAT boot drive with HPFS'
  say ' extended partitions.  This will add support to CONFIG.sys if needed so'
  say ' HPFS extended drives will be useable.'
  say ' '
  say ' Syntax:'
  say ' '
  say '    ADDHPFS  [bootdrive]'
  say ' '
  say '           [] optional parameter'
  say ' '
  say '           where  bootdrive is the drive letter that OS/2 is installed on'
  say '                            the default is "C:"'
  say ' '

EXIT


/*------------------------------------------------------------------------*/
/*                                                                        */
/*------------------------------------------------------------------------*/
BADPARM1: procedure expose validdrvs

  say ' '
  say ' The supported drive letters are: ' validdrvs
  say ' '
  say ' Please correct and retry the command.'
  say ' '

EXIT
